/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.subjects;

import hu.akarnokd.rxjava2.util.SpmcLinkedArrayQueue;
import io.reactivex.Flowable;
import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.SimplePlainQueue;
import io.reactivex.internal.util.ExceptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.subjects.Subject;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class DispatchWorkSubject<T>
extends Subject<T>
implements Disposable {
    final SimplePlainQueue<T> queue;
    final AtomicInteger wip;
    final AtomicReference<Disposable> upstream;
    final AtomicReference<Throwable> error;
    final boolean delayErrors;
    final AtomicReference<WorkDisposable<T>[]> observers;
    final Scheduler scheduler;
    static final WorkDisposable[] EMPTY = new WorkDisposable[0];
    static final WorkDisposable[] TERMINATED = new WorkDisposable[0];

    public static <T> DispatchWorkSubject<T> create(Scheduler scheduler) {
        return DispatchWorkSubject.create(scheduler, Flowable.bufferSize(), true);
    }

    public static <T> DispatchWorkSubject<T> create(Scheduler scheduler, int capacityHint) {
        return DispatchWorkSubject.create(scheduler, capacityHint, true);
    }

    public static <T> DispatchWorkSubject<T> create(Scheduler scheduler, boolean delayErrors) {
        return DispatchWorkSubject.create(scheduler, Flowable.bufferSize(), delayErrors);
    }

    public static <T> DispatchWorkSubject<T> create(Scheduler scheduler, int capacityHint, boolean delayErrors) {
        return new DispatchWorkSubject<T>(capacityHint, delayErrors, scheduler);
    }

    DispatchWorkSubject(int capacityHint, boolean delayErrors, Scheduler scheduler) {
        this.queue = new SpmcLinkedArrayQueue(capacityHint);
        this.delayErrors = delayErrors;
        this.wip = new AtomicInteger();
        this.upstream = new AtomicReference();
        this.error = new AtomicReference();
        this.observers = new AtomicReference<WorkDisposable[]>(EMPTY);
        this.scheduler = scheduler;
    }

    public void onSubscribe(Disposable d) {
        DisposableHelper.setOnce(this.upstream, (Disposable)d);
    }

    public void onNext(T t) {
        if (this.error.get() == null) {
            this.queue.offer(t);
            for (WorkDisposable<T> wd : this.observers.get()) {
                wd.drain();
            }
        }
    }

    public void onError(Throwable e) {
        ObjectHelper.requireNonNull((Object)e, (String)"e is null");
        if (this.error.compareAndSet(null, e)) {
            for (WorkDisposable wd : this.observers.getAndSet(TERMINATED)) {
                wd.drain();
            }
        } else {
            RxJavaPlugins.onError((Throwable)e);
        }
    }

    public void onComplete() {
        if (this.error.compareAndSet(null, ExceptionHelper.TERMINATED)) {
            for (WorkDisposable wd : this.observers.getAndSet(TERMINATED)) {
                wd.drain();
            }
        }
    }

    protected void subscribeActual(Observer<? super T> observer) {
        WorkDisposable<T> wd = new WorkDisposable<T>(observer, this, this.scheduler.createWorker(), this.delayErrors);
        observer.onSubscribe(wd);
        if (this.add(wd) && wd.isDisposed()) {
            this.remove(wd);
            return;
        }
        wd.drain();
    }

    public void dispose() {
        DisposableHelper.dispose(this.upstream);
    }

    public boolean isDisposed() {
        return DisposableHelper.isDisposed((Disposable)this.upstream.get());
    }

    public boolean hasComplete() {
        return this.error.get() == ExceptionHelper.TERMINATED;
    }

    public boolean hasThrowable() {
        Throwable ex = this.error.get();
        return ex != null && ex != ExceptionHelper.TERMINATED;
    }

    public Throwable getThrowable() {
        Throwable ex = this.error.get();
        return ex != ExceptionHelper.TERMINATED ? ex : null;
    }

    public boolean hasObservers() {
        return this.observers.get().length != 0;
    }

    boolean add(WorkDisposable<T> wd) {
        WorkDisposable[] b;
        WorkDisposable<T>[] a;
        do {
            if ((a = this.observers.get()) == TERMINATED) {
                return false;
            }
            int n = a.length;
            b = new WorkDisposable[n + 1];
            System.arraycopy(a, 0, b, 0, n);
            b[n] = wd;
        } while (!this.observers.compareAndSet(a, b));
        return true;
    }

    void remove(WorkDisposable<T> wd) {
        WorkDisposable<T>[] a;
        int n;
        while ((n = (a = this.observers.get()).length) != 0) {
            WorkDisposable[] b;
            int j = -1;
            for (int i = 0; i < n; ++i) {
                if (a[i] != wd) continue;
                j = i;
                break;
            }
            if (j < 0) break;
            if (n == 1) {
                b = EMPTY;
            } else {
                b = new WorkDisposable[n - 1];
                System.arraycopy(a, 0, b, 0, j);
                System.arraycopy(a, j + 1, b, j, n - j - 1);
            }
            if (!this.observers.compareAndSet(a, b)) continue;
            break;
        }
    }

    static final class WorkDisposable<T>
    extends AtomicInteger
    implements Disposable,
    Runnable {
        private static final long serialVersionUID = 7597704795244221647L;
        final Observer<? super T> downstream;
        final DispatchWorkSubject<T> parent;
        final Scheduler.Worker worker;
        final boolean delayErrors;
        volatile boolean disposed;

        WorkDisposable(Observer<? super T> downstream, DispatchWorkSubject<T> parent, Scheduler.Worker worker, boolean delayErrors) {
            this.downstream = downstream;
            this.parent = parent;
            this.worker = worker;
            this.delayErrors = delayErrors;
        }

        public void dispose() {
            this.disposed = true;
            this.parent.remove(this);
            this.worker.dispose();
        }

        public boolean isDisposed() {
            return this.disposed;
        }

        @Override
        public void run() {
            int missed = 1;
            SimplePlainQueue q = this.parent.queue;
            Observer<? super T> downstream = this.downstream;
            AtomicReference<Throwable> error = this.parent.error;
            boolean delayErrors = this.delayErrors;
            while (true) {
                boolean empty;
                boolean d;
                if (this.disposed) {
                    return;
                }
                Throwable ex = error.get();
                boolean bl = d = ex != null;
                if (d && !delayErrors && ex != ExceptionHelper.TERMINATED) {
                    q.clear();
                    downstream.onError(ex);
                    this.worker.dispose();
                    return;
                }
                Object v = q.poll();
                boolean bl2 = empty = v == null;
                if (d && empty) {
                    if (ex == ExceptionHelper.TERMINATED) {
                        downstream.onComplete();
                    } else {
                        downstream.onError(ex);
                    }
                    this.worker.dispose();
                    return;
                }
                if (!empty) {
                    downstream.onNext(v);
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        void drain() {
            if (this.getAndIncrement() == 0) {
                this.worker.schedule((Runnable)this);
            }
        }
    }
}

