/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.subjects;

import io.reactivex.Flowable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.SimplePlainQueue;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.util.ExceptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.subjects.Subject;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class UnicastWorkSubject<T>
extends Subject<T>
implements Disposable {
    final SimplePlainQueue<T> queue;
    final boolean delayErrors;
    final AtomicInteger wip;
    final AtomicReference<Disposable> upstream;
    final AtomicReference<Throwable> error;
    final AtomicReference<WorkDisposable> consumer;
    T item;

    public static <T> UnicastWorkSubject<T> create() {
        return UnicastWorkSubject.create(Flowable.bufferSize(), true);
    }

    public static <T> UnicastWorkSubject<T> create(int capacityHint) {
        return UnicastWorkSubject.create(capacityHint, true);
    }

    public static <T> UnicastWorkSubject<T> create(boolean delayErrors) {
        return UnicastWorkSubject.create(Flowable.bufferSize(), delayErrors);
    }

    public static <T> UnicastWorkSubject<T> create(int capacityHint, boolean delayErrors) {
        return new UnicastWorkSubject<T>(capacityHint, delayErrors);
    }

    UnicastWorkSubject(int capacityHint, boolean delayErrors) {
        this.queue = new SpscLinkedArrayQueue(capacityHint);
        this.delayErrors = delayErrors;
        this.consumer = new AtomicReference();
        this.upstream = new AtomicReference();
        this.wip = new AtomicInteger();
        this.error = new AtomicReference();
    }

    public void onSubscribe(Disposable d) {
        DisposableHelper.setOnce(this.upstream, (Disposable)d);
    }

    public void onNext(T t) {
        ObjectHelper.requireNonNull(t, (String)"t is null");
        if (this.error.get() == null) {
            this.queue.offer(t);
            this.drain();
        }
    }

    public void onError(Throwable e) {
        ObjectHelper.requireNonNull((Object)e, (String)"e is null");
        if (this.error.compareAndSet(null, e)) {
            this.drain();
        } else {
            RxJavaPlugins.onError((Throwable)e);
        }
    }

    public void onComplete() {
        if (this.error.compareAndSet(null, ExceptionHelper.TERMINATED)) {
            this.drain();
        }
    }

    protected void subscribeActual(Observer<? super T> observer) {
        WorkDisposable w = new WorkDisposable(observer);
        observer.onSubscribe((Disposable)w);
        if (this.consumer.compareAndSet(null, w)) {
            if (w.get()) {
                this.consumer.compareAndSet(w, null);
            } else {
                this.drain();
            }
        } else {
            observer.onError((Throwable)new IllegalStateException("Only one Observer allowed at a time"));
        }
    }

    public void dispose() {
        DisposableHelper.dispose(this.upstream);
        if (this.error.compareAndSet(null, ExceptionHelper.TERMINATED)) {
            this.drain();
        }
    }

    public boolean isDisposed() {
        return DisposableHelper.isDisposed((Disposable)this.upstream.get());
    }

    public boolean hasComplete() {
        return this.error.get() == ExceptionHelper.TERMINATED;
    }

    public boolean hasThrowable() {
        Throwable ex = this.error.get();
        return ex != null && ex != ExceptionHelper.TERMINATED;
    }

    public Throwable getThrowable() {
        Throwable ex = this.error.get();
        return ex != ExceptionHelper.TERMINATED ? ex : null;
    }

    public boolean hasObservers() {
        return this.consumer.get() != null;
    }

    void remove(WorkDisposable d) {
        this.consumer.compareAndSet(d, null);
    }

    void drain() {
        if (this.wip.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        AtomicReference<Throwable> error = this.error;
        AtomicReference<WorkDisposable> consumer = this.consumer;
        boolean delayErrors = this.delayErrors;
        while (true) {
            block6: {
                boolean empty;
                Object v;
                WorkDisposable a;
                block8: {
                    block9: {
                        boolean d;
                        Throwable ex;
                        block7: {
                            if ((a = consumer.get()) == null) break block6;
                            ex = error.get();
                            boolean bl = d = ex != null;
                            if (!d || delayErrors || ex == ExceptionHelper.TERMINATED) break block7;
                            this.queue.clear();
                            this.item = null;
                            if (consumer.compareAndSet(a, null)) {
                                a.downstream.onError(ex);
                            }
                            break block6;
                        }
                        v = this.item;
                        if (v == null) {
                            v = this.queue.poll();
                        }
                        boolean bl = empty = v == null;
                        if (!d || !empty) break block8;
                        if (ex == ExceptionHelper.TERMINATED) break block9;
                        if (consumer.compareAndSet(a, null)) {
                            a.downstream.onError(ex);
                        }
                        break block6;
                    }
                    if (!consumer.compareAndSet(a, null)) break block6;
                    a.downstream.onComplete();
                    break block6;
                }
                if (!empty) {
                    if (a != consumer.get()) continue;
                    this.item = null;
                    a.downstream.onNext(v);
                    continue;
                }
            }
            if ((missed = this.wip.addAndGet(-missed)) == 0) break;
        }
    }

    final class WorkDisposable
    extends AtomicBoolean
    implements Disposable {
        private static final long serialVersionUID = -3574708954225968389L;
        final Observer<? super T> downstream;

        WorkDisposable(Observer<? super T> downstream) {
            this.downstream = downstream;
        }

        public void dispose() {
            if (this.compareAndSet(false, true)) {
                UnicastWorkSubject.this.remove(this);
            }
        }

        public boolean isDisposed() {
            return this.get();
        }
    }
}

