/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.expr;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BooleanSupplier;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.EmptyDisposable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

final class ObservableWhileDoWhile<T>
extends Observable<T> {
    final ObservableSource<? extends T> source;
    final BooleanSupplier preCondition;
    final BooleanSupplier postCondition;

    ObservableWhileDoWhile(ObservableSource<? extends T> source, BooleanSupplier preCondition, BooleanSupplier postCondition) {
        this.source = source;
        this.preCondition = preCondition;
        this.postCondition = postCondition;
    }

    protected void subscribeActual(Observer<? super T> observer) {
        boolean b;
        try {
            b = this.preCondition.getAsBoolean();
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal((Throwable)ex);
            EmptyDisposable.error((Throwable)ex, observer);
            return;
        }
        if (b) {
            WhileDoWhileObserver<T> parent = new WhileDoWhileObserver<T>(observer, this.postCondition, this.source);
            observer.onSubscribe(parent);
            parent.subscribeNext();
        } else {
            EmptyDisposable.complete(observer);
        }
    }

    static final class WhileDoWhileObserver<T>
    extends AtomicReference<Disposable>
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = -5255585317630843019L;
        final Observer<? super T> actual;
        final AtomicInteger wip;
        final BooleanSupplier postCondition;
        final ObservableSource<? extends T> source;
        volatile boolean active;

        WhileDoWhileObserver(Observer<? super T> actual, BooleanSupplier postCondition, ObservableSource<? extends T> source) {
            this.actual = actual;
            this.wip = new AtomicInteger();
            this.postCondition = postCondition;
            this.source = source;
        }

        public void onSubscribe(Disposable d) {
            DisposableHelper.replace((AtomicReference)this, (Disposable)d);
        }

        public void onNext(T value) {
            this.actual.onNext(value);
        }

        public void onError(Throwable e) {
            this.actual.onError(e);
        }

        public void onComplete() {
            boolean b;
            try {
                b = this.postCondition.getAsBoolean();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.actual.onError(ex);
                return;
            }
            if (b) {
                this.active = false;
                this.subscribeNext();
            } else {
                this.actual.onComplete();
            }
        }

        public void dispose() {
            DisposableHelper.dispose((AtomicReference)this);
        }

        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)((Disposable)this.get()));
        }

        void subscribeNext() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            do {
                if (this.isDisposed()) {
                    return;
                }
                if (this.active) continue;
                this.active = true;
                this.source.subscribe((Observer)this);
            } while (this.wip.decrementAndGet() != 0);
        }
    }
}

