/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.math;

import hu.akarnokd.rxjava2.math.ObservableWithSource;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.internal.subscribers.observable.DeferredScalarObserver;

public class ObservableSumFloat
extends ObservableWithSource<Float, Float> {
    public ObservableSumFloat(ObservableSource<Float> source) {
        super(source);
    }

    protected void subscribeActual(Observer<? super Float> observer) {
        this.source.subscribe((Observer)new SumFloatObserver(observer));
    }

    static final class SumFloatObserver
    extends DeferredScalarObserver<Float, Float> {
        private static final long serialVersionUID = -6344890278713820111L;
        float accumulator;
        boolean hasValue;

        SumFloatObserver(Observer<? super Float> actual) {
            super(actual);
        }

        public void onNext(Float value) {
            if (!this.hasValue) {
                this.hasValue = true;
            }
            this.accumulator += value.floatValue();
        }

        public void onComplete() {
            if (this.hasValue) {
                this.complete(Float.valueOf(this.accumulator));
            } else {
                this.actual.onComplete();
            }
        }
    }
}

