/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.math;

import hu.akarnokd.rxjava2.math.FlowableSource;
import io.reactivex.internal.subscribers.flowable.DeferredScalarSubscriber;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

final class FlowableAverageDouble
extends FlowableSource<Number, Double> {
    FlowableAverageDouble(Publisher<Number> source) {
        super(source);
    }

    protected void subscribeActual(Subscriber<? super Double> observer) {
        this.source.subscribe((Subscriber)new AverageDoubleSubscriber(observer));
    }

    static final class AverageDoubleSubscriber
    extends DeferredScalarSubscriber<Number, Double> {
        private static final long serialVersionUID = 600979972678601618L;
        double accumulator;
        long count;

        AverageDoubleSubscriber(Subscriber<? super Double> actual) {
            super(actual);
        }

        public void onNext(Number value) {
            this.accumulator += value.doubleValue();
            ++this.count;
        }

        public void onComplete() {
            long c = this.count;
            if (c != 0L) {
                this.complete(this.accumulator / (double)c);
            } else {
                this.actual.onComplete();
            }
        }
    }
}

