/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.string;

import io.reactivex.Flowable;
import io.reactivex.internal.subscriptions.BasicQueueSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class FlowableCharSequence
extends Flowable<Integer> {
    final CharSequence string;

    FlowableCharSequence(CharSequence string) {
        this.string = string;
    }

    public void subscribeActual(Subscriber<? super Integer> s) {
        s.onSubscribe((Subscription)new CharSequenceSubscription(s, this.string));
    }

    static final class CharSequenceSubscription
    extends BasicQueueSubscription<Integer> {
        private static final long serialVersionUID = -4593793201463047197L;
        final Subscriber<? super Integer> actual;
        final CharSequence string;
        final int end;
        int index;
        volatile boolean cancelled;
        volatile long requested;
        static final AtomicLongFieldUpdater<CharSequenceSubscription> REQUESTED = AtomicLongFieldUpdater.newUpdater(CharSequenceSubscription.class, "requested");

        CharSequenceSubscription(Subscriber<? super Integer> actual, CharSequence string) {
            this.actual = actual;
            this.string = string;
            this.end = string.length();
        }

        public void cancel() {
            this.cancelled = true;
        }

        public void request(long n) {
            if (SubscriptionHelper.validate((long)n) && BackpressureHelper.add((AtomicLong)((Object)this), (long)n) == 0L) {
                if (n == Long.MAX_VALUE) {
                    this.fastPath();
                } else {
                    this.slowPath(n);
                }
            }
        }

        void fastPath() {
            int e = this.end;
            CharSequence s = this.string;
            Subscriber<? super Integer> a = this.actual;
            for (int i = this.index; i != e; ++i) {
                if (this.cancelled) {
                    return;
                }
                a.onNext((Object)s.charAt(i));
            }
            if (!this.cancelled) {
                a.onComplete();
            }
        }

        void slowPath(long r) {
            long e = 0L;
            int i = this.index;
            int f = this.end;
            CharSequence s = this.string;
            Subscriber<? super Integer> a = this.actual;
            while (true) {
                if (e != r && i != f) {
                    if (this.cancelled) {
                        return;
                    }
                    a.onNext((Object)s.charAt(i));
                    ++i;
                    ++e;
                    continue;
                }
                if (i == f) {
                    if (!this.cancelled) {
                        a.onComplete();
                    }
                    return;
                }
                r = this.requested;
                if (e != r) continue;
                this.index = i;
                r = REQUESTED.addAndGet(this, -e);
                if (r == 0L) break;
            }
        }

        public int requestFusion(int requestedMode) {
            return requestedMode & 1;
        }

        public Integer poll() {
            int i = this.index;
            if (i != this.end) {
                this.index = i + 1;
                return this.string.charAt(i);
            }
            return null;
        }

        public boolean isEmpty() {
            return this.index != this.end;
        }

        public void clear() {
            this.index = this.end;
        }
    }
}

