/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable;

import hu.akarnokd.reactivestreams.extensions.ConstantValuePublisher;
import hu.akarnokd.reactivestreams.extensions.RelaxedSubscriber;
import io.reactivex.common.Disposable;
import io.reactivex.common.Emitter;
import io.reactivex.common.ErrorMode;
import io.reactivex.common.Notification;
import io.reactivex.common.RxJavaCommonPlugins;
import io.reactivex.common.Scheduler;
import io.reactivex.common.Schedulers;
import io.reactivex.common.Timed;
import io.reactivex.common.annotations.CheckReturnValue;
import io.reactivex.common.annotations.Experimental;
import io.reactivex.common.annotations.NonNull;
import io.reactivex.common.annotations.SchedulerSupport;
import io.reactivex.common.exceptions.Exceptions;
import io.reactivex.common.functions.Action;
import io.reactivex.common.functions.BiConsumer;
import io.reactivex.common.functions.BiFunction;
import io.reactivex.common.functions.BiPredicate;
import io.reactivex.common.functions.BooleanSupplier;
import io.reactivex.common.functions.Consumer;
import io.reactivex.common.functions.Function;
import io.reactivex.common.functions.Function3;
import io.reactivex.common.functions.Function4;
import io.reactivex.common.functions.Function5;
import io.reactivex.common.functions.Function6;
import io.reactivex.common.functions.Function7;
import io.reactivex.common.functions.Function8;
import io.reactivex.common.functions.Function9;
import io.reactivex.common.functions.LongConsumer;
import io.reactivex.common.functions.Predicate;
import io.reactivex.common.internal.functions.Functions;
import io.reactivex.common.internal.functions.ObjectHelper;
import io.reactivex.common.internal.schedulers.ImmediateThinScheduler;
import io.reactivex.common.internal.utils.ArrayListSupplier;
import io.reactivex.common.internal.utils.ExceptionHelper;
import io.reactivex.common.internal.utils.HashMapSupplier;
import io.reactivex.flowable.BackpressureKind;
import io.reactivex.flowable.BackpressureOverflowStrategy;
import io.reactivex.flowable.BackpressureStrategy;
import io.reactivex.flowable.BackpressureSupport;
import io.reactivex.flowable.ConnectableFlowable;
import io.reactivex.flowable.FlowableOnSubscribe;
import io.reactivex.flowable.FlowableOperator;
import io.reactivex.flowable.FlowableTransformer;
import io.reactivex.flowable.GroupedFlowable;
import io.reactivex.flowable.ParallelFlowable;
import io.reactivex.flowable.RxJavaFlowablePlugins;
import io.reactivex.flowable.internal.operators.BlockingFlowableIterable;
import io.reactivex.flowable.internal.operators.BlockingFlowableLatest;
import io.reactivex.flowable.internal.operators.BlockingFlowableMostRecent;
import io.reactivex.flowable.internal.operators.BlockingFlowableNext;
import io.reactivex.flowable.internal.operators.FlowableAll;
import io.reactivex.flowable.internal.operators.FlowableAmb;
import io.reactivex.flowable.internal.operators.FlowableAny;
import io.reactivex.flowable.internal.operators.FlowableBlockingSubscribe;
import io.reactivex.flowable.internal.operators.FlowableBuffer;
import io.reactivex.flowable.internal.operators.FlowableBufferBoundary;
import io.reactivex.flowable.internal.operators.FlowableBufferBoundarySupplier;
import io.reactivex.flowable.internal.operators.FlowableBufferExactBoundary;
import io.reactivex.flowable.internal.operators.FlowableBufferTimed;
import io.reactivex.flowable.internal.operators.FlowableCache;
import io.reactivex.flowable.internal.operators.FlowableCollect;
import io.reactivex.flowable.internal.operators.FlowableCombineLatest;
import io.reactivex.flowable.internal.operators.FlowableConcatArray;
import io.reactivex.flowable.internal.operators.FlowableConcatMap;
import io.reactivex.flowable.internal.operators.FlowableConcatMapEager;
import io.reactivex.flowable.internal.operators.FlowableConcatMapEagerPublisher;
import io.reactivex.flowable.internal.operators.FlowableCount;
import io.reactivex.flowable.internal.operators.FlowableCreate;
import io.reactivex.flowable.internal.operators.FlowableDebounce;
import io.reactivex.flowable.internal.operators.FlowableDebounceTimed;
import io.reactivex.flowable.internal.operators.FlowableDefer;
import io.reactivex.flowable.internal.operators.FlowableDelay;
import io.reactivex.flowable.internal.operators.FlowableDelaySubscriptionOther;
import io.reactivex.flowable.internal.operators.FlowableDematerialize;
import io.reactivex.flowable.internal.operators.FlowableDetach;
import io.reactivex.flowable.internal.operators.FlowableDistinct;
import io.reactivex.flowable.internal.operators.FlowableDistinctUntilChanged;
import io.reactivex.flowable.internal.operators.FlowableDoAfterNext;
import io.reactivex.flowable.internal.operators.FlowableDoFinally;
import io.reactivex.flowable.internal.operators.FlowableDoOnEach;
import io.reactivex.flowable.internal.operators.FlowableDoOnLifecycle;
import io.reactivex.flowable.internal.operators.FlowableElementAt;
import io.reactivex.flowable.internal.operators.FlowableEmpty;
import io.reactivex.flowable.internal.operators.FlowableError;
import io.reactivex.flowable.internal.operators.FlowableFilter;
import io.reactivex.flowable.internal.operators.FlowableFlatMap;
import io.reactivex.flowable.internal.operators.FlowableFlattenIterable;
import io.reactivex.flowable.internal.operators.FlowableFromArray;
import io.reactivex.flowable.internal.operators.FlowableFromCallable;
import io.reactivex.flowable.internal.operators.FlowableFromFuture;
import io.reactivex.flowable.internal.operators.FlowableFromIterable;
import io.reactivex.flowable.internal.operators.FlowableFromPublisher;
import io.reactivex.flowable.internal.operators.FlowableGenerate;
import io.reactivex.flowable.internal.operators.FlowableGroupBy;
import io.reactivex.flowable.internal.operators.FlowableGroupJoin;
import io.reactivex.flowable.internal.operators.FlowableHide;
import io.reactivex.flowable.internal.operators.FlowableIgnoreElements;
import io.reactivex.flowable.internal.operators.FlowableInternalHelper;
import io.reactivex.flowable.internal.operators.FlowableInterval;
import io.reactivex.flowable.internal.operators.FlowableIntervalRange;
import io.reactivex.flowable.internal.operators.FlowableJoin;
import io.reactivex.flowable.internal.operators.FlowableJust;
import io.reactivex.flowable.internal.operators.FlowableLast;
import io.reactivex.flowable.internal.operators.FlowableLift;
import io.reactivex.flowable.internal.operators.FlowableMap;
import io.reactivex.flowable.internal.operators.FlowableMapNotification;
import io.reactivex.flowable.internal.operators.FlowableMaterialize;
import io.reactivex.flowable.internal.operators.FlowableNever;
import io.reactivex.flowable.internal.operators.FlowableObserveOn;
import io.reactivex.flowable.internal.operators.FlowableOnBackpressureBuffer;
import io.reactivex.flowable.internal.operators.FlowableOnBackpressureBufferStrategy;
import io.reactivex.flowable.internal.operators.FlowableOnBackpressureDrop;
import io.reactivex.flowable.internal.operators.FlowableOnBackpressureLatest;
import io.reactivex.flowable.internal.operators.FlowableOnErrorNext;
import io.reactivex.flowable.internal.operators.FlowableOnErrorReturn;
import io.reactivex.flowable.internal.operators.FlowablePublish;
import io.reactivex.flowable.internal.operators.FlowablePublishMulticast;
import io.reactivex.flowable.internal.operators.FlowableRange;
import io.reactivex.flowable.internal.operators.FlowableRangeLong;
import io.reactivex.flowable.internal.operators.FlowableReduce;
import io.reactivex.flowable.internal.operators.FlowableReduceSeed;
import io.reactivex.flowable.internal.operators.FlowableReduceWith;
import io.reactivex.flowable.internal.operators.FlowableRepeat;
import io.reactivex.flowable.internal.operators.FlowableRepeatUntil;
import io.reactivex.flowable.internal.operators.FlowableRepeatWhen;
import io.reactivex.flowable.internal.operators.FlowableReplay;
import io.reactivex.flowable.internal.operators.FlowableRetryBiPredicate;
import io.reactivex.flowable.internal.operators.FlowableRetryPredicate;
import io.reactivex.flowable.internal.operators.FlowableRetryWhen;
import io.reactivex.flowable.internal.operators.FlowableSamplePublisher;
import io.reactivex.flowable.internal.operators.FlowableSampleTimed;
import io.reactivex.flowable.internal.operators.FlowableScalarXMap;
import io.reactivex.flowable.internal.operators.FlowableScan;
import io.reactivex.flowable.internal.operators.FlowableScanSeed;
import io.reactivex.flowable.internal.operators.FlowableSequenceEqual;
import io.reactivex.flowable.internal.operators.FlowableSerialized;
import io.reactivex.flowable.internal.operators.FlowableSingle;
import io.reactivex.flowable.internal.operators.FlowableSkip;
import io.reactivex.flowable.internal.operators.FlowableSkipLast;
import io.reactivex.flowable.internal.operators.FlowableSkipLastTimed;
import io.reactivex.flowable.internal.operators.FlowableSkipUntil;
import io.reactivex.flowable.internal.operators.FlowableSkipWhile;
import io.reactivex.flowable.internal.operators.FlowableSubscribeOn;
import io.reactivex.flowable.internal.operators.FlowableSwitchIfEmpty;
import io.reactivex.flowable.internal.operators.FlowableSwitchMap;
import io.reactivex.flowable.internal.operators.FlowableTake;
import io.reactivex.flowable.internal.operators.FlowableTakeLast;
import io.reactivex.flowable.internal.operators.FlowableTakeLastOne;
import io.reactivex.flowable.internal.operators.FlowableTakeLastTimed;
import io.reactivex.flowable.internal.operators.FlowableTakeUntil;
import io.reactivex.flowable.internal.operators.FlowableTakeUntilPredicate;
import io.reactivex.flowable.internal.operators.FlowableTakeWhile;
import io.reactivex.flowable.internal.operators.FlowableThrottleFirstTimed;
import io.reactivex.flowable.internal.operators.FlowableTimeInterval;
import io.reactivex.flowable.internal.operators.FlowableTimeout;
import io.reactivex.flowable.internal.operators.FlowableTimeoutTimed;
import io.reactivex.flowable.internal.operators.FlowableTimer;
import io.reactivex.flowable.internal.operators.FlowableToList;
import io.reactivex.flowable.internal.operators.FlowableUnsubscribeOn;
import io.reactivex.flowable.internal.operators.FlowableUsing;
import io.reactivex.flowable.internal.operators.FlowableWindow;
import io.reactivex.flowable.internal.operators.FlowableWindowBoundary;
import io.reactivex.flowable.internal.operators.FlowableWindowBoundarySelector;
import io.reactivex.flowable.internal.operators.FlowableWindowBoundarySupplier;
import io.reactivex.flowable.internal.operators.FlowableWindowTimed;
import io.reactivex.flowable.internal.operators.FlowableWithLatestFrom;
import io.reactivex.flowable.internal.operators.FlowableWithLatestFromMany;
import io.reactivex.flowable.internal.operators.FlowableZip;
import io.reactivex.flowable.internal.operators.FlowableZipIterable;
import io.reactivex.flowable.internal.subscribers.BlockingFirstSubscriber;
import io.reactivex.flowable.internal.subscribers.BlockingLastSubscriber;
import io.reactivex.flowable.internal.subscribers.ForEachWhileSubscriber;
import io.reactivex.flowable.internal.subscribers.FutureSubscriber;
import io.reactivex.flowable.internal.subscribers.LambdaSubscriber;
import io.reactivex.flowable.internal.subscribers.StrictSubscriber;
import io.reactivex.flowable.subscribers.SafeSubscriber;
import io.reactivex.flowable.subscribers.TestSubscriber;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public abstract class Flowable<T>
implements Publisher<T> {
    static final int BUFFER_SIZE = Math.max(1, Integer.getInteger("rx2.buffer-size", 128));

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> amb(Iterable<? extends Publisher<? extends T>> sources) {
        ObjectHelper.requireNonNull(sources, (String)"sources is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableAmb(null, sources));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> ambArray(Publisher<? extends T> ... sources) {
        ObjectHelper.requireNonNull(sources, (String)"sources is null");
        int len = sources.length;
        if (len == 0) {
            return Flowable.empty();
        }
        if (len == 1) {
            return Flowable.fromPublisher(sources[0]);
        }
        return RxJavaFlowablePlugins.onAssembly(new FlowableAmb<T>(sources, null));
    }

    public static int bufferSize() {
        return BUFFER_SIZE;
    }

    @SchedulerSupport(value="none")
    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    public static <T, R> Flowable<R> combineLatest(Publisher<? extends T>[] sources, Function<? super Object[], ? extends R> combiner) {
        return Flowable.combineLatest(sources, combiner, Flowable.bufferSize());
    }

    @SchedulerSupport(value="none")
    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    public static <T, R> Flowable<R> combineLatest(Function<? super Object[], ? extends R> combiner, Publisher<? extends T> ... sources) {
        return Flowable.combineLatest(sources, combiner, Flowable.bufferSize());
    }

    @SchedulerSupport(value="none")
    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    public static <T, R> Flowable<R> combineLatest(Publisher<? extends T>[] sources, Function<? super Object[], ? extends R> combiner, int bufferSize) {
        ObjectHelper.requireNonNull(sources, (String)"sources is null");
        if (sources.length == 0) {
            return Flowable.empty();
        }
        ObjectHelper.requireNonNull(combiner, (String)"combiner is null");
        ObjectHelper.verifyPositive((int)bufferSize, (String)"bufferSize");
        return RxJavaFlowablePlugins.onAssembly(new FlowableCombineLatest<T, R>(sources, combiner, bufferSize, false));
    }

    @SchedulerSupport(value="none")
    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    public static <T, R> Flowable<R> combineLatest(Iterable<? extends Publisher<? extends T>> sources, Function<? super Object[], ? extends R> combiner) {
        return Flowable.combineLatest(sources, combiner, Flowable.bufferSize());
    }

    @SchedulerSupport(value="none")
    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    public static <T, R> Flowable<R> combineLatest(Iterable<? extends Publisher<? extends T>> sources, Function<? super Object[], ? extends R> combiner, int bufferSize) {
        ObjectHelper.requireNonNull(sources, (String)"sources is null");
        ObjectHelper.requireNonNull(combiner, (String)"combiner is null");
        ObjectHelper.verifyPositive((int)bufferSize, (String)"bufferSize");
        return RxJavaFlowablePlugins.onAssembly(new FlowableCombineLatest(sources, combiner, bufferSize, false));
    }

    @SchedulerSupport(value="none")
    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    public static <T, R> Flowable<R> combineLatestDelayError(Publisher<? extends T>[] sources, Function<? super Object[], ? extends R> combiner) {
        return Flowable.combineLatestDelayError(sources, combiner, Flowable.bufferSize());
    }

    @SchedulerSupport(value="none")
    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    public static <T, R> Flowable<R> combineLatestDelayError(Function<? super Object[], ? extends R> combiner, Publisher<? extends T> ... sources) {
        return Flowable.combineLatestDelayError(sources, combiner, Flowable.bufferSize());
    }

    @SchedulerSupport(value="none")
    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    public static <T, R> Flowable<R> combineLatestDelayError(Function<? super Object[], ? extends R> combiner, int bufferSize, Publisher<? extends T> ... sources) {
        return Flowable.combineLatestDelayError(sources, combiner, bufferSize);
    }

    @SchedulerSupport(value="none")
    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    public static <T, R> Flowable<R> combineLatestDelayError(Publisher<? extends T>[] sources, Function<? super Object[], ? extends R> combiner, int bufferSize) {
        ObjectHelper.requireNonNull(sources, (String)"sources is null");
        ObjectHelper.requireNonNull(combiner, (String)"combiner is null");
        ObjectHelper.verifyPositive((int)bufferSize, (String)"bufferSize");
        if (sources.length == 0) {
            return Flowable.empty();
        }
        return RxJavaFlowablePlugins.onAssembly(new FlowableCombineLatest<T, R>(sources, combiner, bufferSize, true));
    }

    @SchedulerSupport(value="none")
    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    public static <T, R> Flowable<R> combineLatestDelayError(Iterable<? extends Publisher<? extends T>> sources, Function<? super Object[], ? extends R> combiner) {
        return Flowable.combineLatestDelayError(sources, combiner, Flowable.bufferSize());
    }

    @SchedulerSupport(value="none")
    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    public static <T, R> Flowable<R> combineLatestDelayError(Iterable<? extends Publisher<? extends T>> sources, Function<? super Object[], ? extends R> combiner, int bufferSize) {
        ObjectHelper.requireNonNull(sources, (String)"sources is null");
        ObjectHelper.requireNonNull(combiner, (String)"combiner is null");
        ObjectHelper.verifyPositive((int)bufferSize, (String)"bufferSize");
        return RxJavaFlowablePlugins.onAssembly(new FlowableCombineLatest(sources, combiner, bufferSize, true));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T1, T2, R> Flowable<R> combineLatest(Publisher<? extends T1> source1, Publisher<? extends T2> source2, BiFunction<? super T1, ? super T2, ? extends R> combiner) {
        ObjectHelper.requireNonNull(source1, (String)"source1 is null");
        ObjectHelper.requireNonNull(source2, (String)"source2 is null");
        Function f = Functions.toFunction(combiner);
        return Flowable.combineLatest(f, source1, source2);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T1, T2, T3, R> Flowable<R> combineLatest(Publisher<? extends T1> source1, Publisher<? extends T2> source2, Publisher<? extends T3> source3, Function3<? super T1, ? super T2, ? super T3, ? extends R> combiner) {
        ObjectHelper.requireNonNull(source1, (String)"source1 is null");
        ObjectHelper.requireNonNull(source2, (String)"source2 is null");
        ObjectHelper.requireNonNull(source3, (String)"source3 is null");
        return Flowable.combineLatest(Functions.toFunction(combiner), source1, source2, source3);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T1, T2, T3, T4, R> Flowable<R> combineLatest(Publisher<? extends T1> source1, Publisher<? extends T2> source2, Publisher<? extends T3> source3, Publisher<? extends T4> source4, Function4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> combiner) {
        ObjectHelper.requireNonNull(source1, (String)"source1 is null");
        ObjectHelper.requireNonNull(source2, (String)"source2 is null");
        ObjectHelper.requireNonNull(source3, (String)"source3 is null");
        ObjectHelper.requireNonNull(source4, (String)"source4 is null");
        return Flowable.combineLatest(Functions.toFunction(combiner), source1, source2, source3, source4);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T1, T2, T3, T4, T5, R> Flowable<R> combineLatest(Publisher<? extends T1> source1, Publisher<? extends T2> source2, Publisher<? extends T3> source3, Publisher<? extends T4> source4, Publisher<? extends T5> source5, Function5<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? extends R> combiner) {
        ObjectHelper.requireNonNull(source1, (String)"source1 is null");
        ObjectHelper.requireNonNull(source2, (String)"source2 is null");
        ObjectHelper.requireNonNull(source3, (String)"source3 is null");
        ObjectHelper.requireNonNull(source4, (String)"source4 is null");
        ObjectHelper.requireNonNull(source5, (String)"source5 is null");
        return Flowable.combineLatest(Functions.toFunction(combiner), source1, source2, source3, source4, source5);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T1, T2, T3, T4, T5, T6, R> Flowable<R> combineLatest(Publisher<? extends T1> source1, Publisher<? extends T2> source2, Publisher<? extends T3> source3, Publisher<? extends T4> source4, Publisher<? extends T5> source5, Publisher<? extends T6> source6, Function6<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? extends R> combiner) {
        ObjectHelper.requireNonNull(source1, (String)"source1 is null");
        ObjectHelper.requireNonNull(source2, (String)"source2 is null");
        ObjectHelper.requireNonNull(source3, (String)"source3 is null");
        ObjectHelper.requireNonNull(source4, (String)"source4 is null");
        ObjectHelper.requireNonNull(source5, (String)"source5 is null");
        ObjectHelper.requireNonNull(source6, (String)"source6 is null");
        return Flowable.combineLatest(Functions.toFunction(combiner), source1, source2, source3, source4, source5, source6);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T1, T2, T3, T4, T5, T6, T7, R> Flowable<R> combineLatest(Publisher<? extends T1> source1, Publisher<? extends T2> source2, Publisher<? extends T3> source3, Publisher<? extends T4> source4, Publisher<? extends T5> source5, Publisher<? extends T6> source6, Publisher<? extends T7> source7, Function7<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? extends R> combiner) {
        ObjectHelper.requireNonNull(source1, (String)"source1 is null");
        ObjectHelper.requireNonNull(source2, (String)"source2 is null");
        ObjectHelper.requireNonNull(source3, (String)"source3 is null");
        ObjectHelper.requireNonNull(source4, (String)"source4 is null");
        ObjectHelper.requireNonNull(source5, (String)"source5 is null");
        ObjectHelper.requireNonNull(source6, (String)"source6 is null");
        ObjectHelper.requireNonNull(source7, (String)"source7 is null");
        return Flowable.combineLatest(Functions.toFunction(combiner), source1, source2, source3, source4, source5, source6, source7);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T1, T2, T3, T4, T5, T6, T7, T8, R> Flowable<R> combineLatest(Publisher<? extends T1> source1, Publisher<? extends T2> source2, Publisher<? extends T3> source3, Publisher<? extends T4> source4, Publisher<? extends T5> source5, Publisher<? extends T6> source6, Publisher<? extends T7> source7, Publisher<? extends T8> source8, Function8<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? extends R> combiner) {
        ObjectHelper.requireNonNull(source1, (String)"source1 is null");
        ObjectHelper.requireNonNull(source2, (String)"source2 is null");
        ObjectHelper.requireNonNull(source3, (String)"source3 is null");
        ObjectHelper.requireNonNull(source4, (String)"source4 is null");
        ObjectHelper.requireNonNull(source5, (String)"source5 is null");
        ObjectHelper.requireNonNull(source6, (String)"source6 is null");
        ObjectHelper.requireNonNull(source7, (String)"source7 is null");
        ObjectHelper.requireNonNull(source8, (String)"source8 is null");
        return Flowable.combineLatest(Functions.toFunction(combiner), source1, source2, source3, source4, source5, source6, source7, source8);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, R> Flowable<R> combineLatest(Publisher<? extends T1> source1, Publisher<? extends T2> source2, Publisher<? extends T3> source3, Publisher<? extends T4> source4, Publisher<? extends T5> source5, Publisher<? extends T6> source6, Publisher<? extends T7> source7, Publisher<? extends T8> source8, Publisher<? extends T9> source9, Function9<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? extends R> combiner) {
        ObjectHelper.requireNonNull(source1, (String)"source1 is null");
        ObjectHelper.requireNonNull(source2, (String)"source2 is null");
        ObjectHelper.requireNonNull(source3, (String)"source3 is null");
        ObjectHelper.requireNonNull(source4, (String)"source4 is null");
        ObjectHelper.requireNonNull(source5, (String)"source5 is null");
        ObjectHelper.requireNonNull(source6, (String)"source6 is null");
        ObjectHelper.requireNonNull(source7, (String)"source7 is null");
        ObjectHelper.requireNonNull(source8, (String)"source8 is null");
        ObjectHelper.requireNonNull(source9, (String)"source9 is null");
        return Flowable.combineLatest(Functions.toFunction(combiner), source1, source2, source3, source4, source5, source6, source7, source8, source9);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> concat(Iterable<? extends Publisher<? extends T>> sources) {
        ObjectHelper.requireNonNull(sources, (String)"sources is null");
        return Flowable.fromIterable(sources).concatMapDelayError(Functions.identity(), 2, false);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> concat(Publisher<? extends Publisher<? extends T>> sources) {
        return Flowable.concat(sources, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> concat(Publisher<? extends Publisher<? extends T>> sources, int prefetch) {
        return Flowable.fromPublisher(sources).concatMap(Functions.identity(), prefetch);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> concat(Publisher<? extends T> source1, Publisher<? extends T> source2) {
        ObjectHelper.requireNonNull(source1, (String)"source1 is null");
        ObjectHelper.requireNonNull(source2, (String)"source2 is null");
        return Flowable.concatArray(source1, source2);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> concat(Publisher<? extends T> source1, Publisher<? extends T> source2, Publisher<? extends T> source3) {
        ObjectHelper.requireNonNull(source1, (String)"source1 is null");
        ObjectHelper.requireNonNull(source2, (String)"source2 is null");
        ObjectHelper.requireNonNull(source3, (String)"source3 is null");
        return Flowable.concatArray(source1, source2, source3);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> concat(Publisher<? extends T> source1, Publisher<? extends T> source2, Publisher<? extends T> source3, Publisher<? extends T> source4) {
        ObjectHelper.requireNonNull(source1, (String)"source1 is null");
        ObjectHelper.requireNonNull(source2, (String)"source2 is null");
        ObjectHelper.requireNonNull(source3, (String)"source3 is null");
        ObjectHelper.requireNonNull(source4, (String)"source4 is null");
        return Flowable.concatArray(source1, source2, source3, source4);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> concatArray(Publisher<? extends T> ... sources) {
        if (sources.length == 0) {
            return Flowable.empty();
        }
        if (sources.length == 1) {
            return Flowable.fromPublisher(sources[0]);
        }
        return RxJavaFlowablePlugins.onAssembly(new FlowableConcatArray<T>(sources, false));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> concatArrayDelayError(Publisher<? extends T> ... sources) {
        if (sources.length == 0) {
            return Flowable.empty();
        }
        if (sources.length == 1) {
            return Flowable.fromPublisher(sources[0]);
        }
        return RxJavaFlowablePlugins.onAssembly(new FlowableConcatArray<T>(sources, true));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> concatArrayEager(Publisher<? extends T> ... sources) {
        return Flowable.concatArrayEager(Flowable.bufferSize(), Flowable.bufferSize(), sources);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> concatArrayEager(int maxConcurrency, int prefetch, Publisher<? extends T> ... sources) {
        ObjectHelper.requireNonNull(sources, (String)"sources is null");
        ObjectHelper.verifyPositive((int)maxConcurrency, (String)"maxConcurrency");
        ObjectHelper.verifyPositive((int)prefetch, (String)"prefetch");
        return RxJavaFlowablePlugins.onAssembly(new FlowableConcatMapEager(new FlowableFromArray<Publisher<? extends T>>(sources), Functions.identity(), maxConcurrency, prefetch, ErrorMode.IMMEDIATE));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> concatDelayError(Iterable<? extends Publisher<? extends T>> sources) {
        ObjectHelper.requireNonNull(sources, (String)"sources is null");
        return Flowable.fromIterable(sources).concatMapDelayError(Functions.identity());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> concatDelayError(Publisher<? extends Publisher<? extends T>> sources) {
        return Flowable.concatDelayError(sources, Flowable.bufferSize(), true);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> concatDelayError(Publisher<? extends Publisher<? extends T>> sources, int prefetch, boolean tillTheEnd) {
        return Flowable.fromPublisher(sources).concatMapDelayError(Functions.identity(), prefetch, tillTheEnd);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> concatEager(Publisher<? extends Publisher<? extends T>> sources) {
        return Flowable.concatEager(sources, Flowable.bufferSize(), Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> concatEager(Publisher<? extends Publisher<? extends T>> sources, int maxConcurrency, int prefetch) {
        ObjectHelper.requireNonNull(sources, (String)"sources is null");
        ObjectHelper.verifyPositive((int)maxConcurrency, (String)"maxConcurrency");
        ObjectHelper.verifyPositive((int)prefetch, (String)"prefetch");
        return RxJavaFlowablePlugins.onAssembly(new FlowableConcatMapEagerPublisher(sources, Functions.identity(), maxConcurrency, prefetch, ErrorMode.IMMEDIATE));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> concatEager(Iterable<? extends Publisher<? extends T>> sources) {
        return Flowable.concatEager(sources, Flowable.bufferSize(), Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> concatEager(Iterable<? extends Publisher<? extends T>> sources, int maxConcurrency, int prefetch) {
        ObjectHelper.requireNonNull(sources, (String)"sources is null");
        ObjectHelper.verifyPositive((int)maxConcurrency, (String)"maxConcurrency");
        ObjectHelper.verifyPositive((int)prefetch, (String)"prefetch");
        return RxJavaFlowablePlugins.onAssembly(new FlowableConcatMapEager(new FlowableFromIterable<Publisher<? extends T>>(sources), Functions.identity(), maxConcurrency, prefetch, ErrorMode.IMMEDIATE));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> create(FlowableOnSubscribe<T> source, BackpressureStrategy mode) {
        ObjectHelper.requireNonNull(source, (String)"source is null");
        ObjectHelper.requireNonNull((Object)((Object)mode), (String)"mode is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableCreate<T>(source, mode));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> defer(Callable<? extends Publisher<? extends T>> supplier) {
        ObjectHelper.requireNonNull(supplier, (String)"supplier is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableDefer(supplier));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> empty() {
        return RxJavaFlowablePlugins.onAssembly(FlowableEmpty.INSTANCE);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> error(Callable<? extends Throwable> supplier) {
        ObjectHelper.requireNonNull(supplier, (String)"errorSupplier is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableError(supplier));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> error(Throwable throwable) {
        ObjectHelper.requireNonNull((Object)throwable, (String)"throwable is null");
        return Flowable.error(Functions.justCallable((Object)throwable));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> fromArray(T ... items) {
        ObjectHelper.requireNonNull(items, (String)"items is null");
        if (items.length == 0) {
            return Flowable.empty();
        }
        if (items.length == 1) {
            return Flowable.just(items[0]);
        }
        return RxJavaFlowablePlugins.onAssembly(new FlowableFromArray<T>(items));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> fromCallable(Callable<? extends T> supplier) {
        ObjectHelper.requireNonNull(supplier, (String)"supplier is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableFromCallable<T>(supplier));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> fromFuture(Future<? extends T> future) {
        ObjectHelper.requireNonNull(future, (String)"future is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableFromFuture<T>(future, 0L, null));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> fromFuture(Future<? extends T> future, long timeout, TimeUnit unit) {
        ObjectHelper.requireNonNull(future, (String)"future is null");
        ObjectHelper.requireNonNull((Object)((Object)unit), (String)"unit is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableFromFuture<T>(future, timeout, unit));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public static <T> Flowable<T> fromFuture(Future<? extends T> future, long timeout, TimeUnit unit, Scheduler scheduler) {
        ObjectHelper.requireNonNull((Object)scheduler, (String)"scheduler is null");
        return Flowable.fromFuture(future, timeout, unit).subscribeOn(scheduler);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public static <T> Flowable<T> fromFuture(Future<? extends T> future, Scheduler scheduler) {
        ObjectHelper.requireNonNull((Object)scheduler, (String)"scheduler is null");
        return Flowable.fromFuture(future).subscribeOn(scheduler);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> fromIterable(Iterable<? extends T> source) {
        ObjectHelper.requireNonNull(source, (String)"source is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableFromIterable<T>(source));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> fromPublisher(Publisher<? extends T> source) {
        if (source instanceof Flowable) {
            return RxJavaFlowablePlugins.onAssembly((Flowable)source);
        }
        ObjectHelper.requireNonNull(source, (String)"publisher is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableFromPublisher<T>(source));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> generate(Consumer<Emitter<T>> generator) {
        ObjectHelper.requireNonNull(generator, (String)"generator is null");
        return Flowable.generate(Functions.nullSupplier(), FlowableInternalHelper.simpleGenerator(generator), Functions.emptyConsumer());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T, S> Flowable<T> generate(Callable<S> initialState, BiConsumer<S, Emitter<T>> generator) {
        ObjectHelper.requireNonNull(generator, (String)"generator is null");
        return Flowable.generate(initialState, FlowableInternalHelper.simpleBiGenerator(generator), Functions.emptyConsumer());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T, S> Flowable<T> generate(Callable<S> initialState, BiConsumer<S, Emitter<T>> generator, Consumer<? super S> disposeState) {
        ObjectHelper.requireNonNull(generator, (String)"generator is null");
        return Flowable.generate(initialState, FlowableInternalHelper.simpleBiGenerator(generator), disposeState);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T, S> Flowable<T> generate(Callable<S> initialState, BiFunction<S, Emitter<T>, S> generator) {
        return Flowable.generate(initialState, generator, Functions.emptyConsumer());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T, S> Flowable<T> generate(Callable<S> initialState, BiFunction<S, Emitter<T>, S> generator, Consumer<? super S> disposeState) {
        ObjectHelper.requireNonNull(initialState, (String)"initialState is null");
        ObjectHelper.requireNonNull(generator, (String)"generator is null");
        ObjectHelper.requireNonNull(disposeState, (String)"disposeState is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableGenerate<T, S>(initialState, generator, disposeState));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    public static Flowable<Long> interval(long initialDelay, long period, TimeUnit unit) {
        return Flowable.interval(initialDelay, period, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    public static Flowable<Long> interval(long initialDelay, long period, TimeUnit unit, Scheduler scheduler) {
        ObjectHelper.requireNonNull((Object)((Object)unit), (String)"unit is null");
        ObjectHelper.requireNonNull((Object)scheduler, (String)"scheduler is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableInterval(Math.max(0L, initialDelay), Math.max(0L, period), unit, scheduler));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    public static Flowable<Long> interval(long period, TimeUnit unit) {
        return Flowable.interval(period, period, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    public static Flowable<Long> interval(long period, TimeUnit unit, Scheduler scheduler) {
        return Flowable.interval(period, period, unit, scheduler);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    public static Flowable<Long> intervalRange(long start, long count, long initialDelay, long period, TimeUnit unit) {
        return Flowable.intervalRange(start, count, initialDelay, period, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    public static Flowable<Long> intervalRange(long start, long count, long initialDelay, long period, TimeUnit unit, Scheduler scheduler) {
        if (count < 0L) {
            throw new IllegalArgumentException("count >= 0 required but it was " + count);
        }
        if (count == 0L) {
            return Flowable.empty().delay(initialDelay, unit, scheduler);
        }
        long end = start + (count - 1L);
        if (start > 0L && end < 0L) {
            throw new IllegalArgumentException("Overflow! start + count is bigger than Long.MAX_VALUE");
        }
        ObjectHelper.requireNonNull((Object)((Object)unit), (String)"unit is null");
        ObjectHelper.requireNonNull((Object)scheduler, (String)"scheduler is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableIntervalRange(start, end, Math.max(0L, initialDelay), Math.max(0L, period), unit, scheduler));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> just(T item) {
        ObjectHelper.requireNonNull(item, (String)"item is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableJust<T>(item));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> just(T item1, T item2) {
        ObjectHelper.requireNonNull(item1, (String)"The first item is null");
        ObjectHelper.requireNonNull(item2, (String)"The second item is null");
        return Flowable.fromArray(item1, item2);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> just(T item1, T item2, T item3) {
        ObjectHelper.requireNonNull(item1, (String)"The first item is null");
        ObjectHelper.requireNonNull(item2, (String)"The second item is null");
        ObjectHelper.requireNonNull(item3, (String)"The third item is null");
        return Flowable.fromArray(item1, item2, item3);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> just(T item1, T item2, T item3, T item4) {
        ObjectHelper.requireNonNull(item1, (String)"The first item is null");
        ObjectHelper.requireNonNull(item2, (String)"The second item is null");
        ObjectHelper.requireNonNull(item3, (String)"The third item is null");
        ObjectHelper.requireNonNull(item4, (String)"The fourth item is null");
        return Flowable.fromArray(item1, item2, item3, item4);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> just(T item1, T item2, T item3, T item4, T item5) {
        ObjectHelper.requireNonNull(item1, (String)"The first item is null");
        ObjectHelper.requireNonNull(item2, (String)"The second item is null");
        ObjectHelper.requireNonNull(item3, (String)"The third item is null");
        ObjectHelper.requireNonNull(item4, (String)"The fourth item is null");
        ObjectHelper.requireNonNull(item5, (String)"The fifth item is null");
        return Flowable.fromArray(item1, item2, item3, item4, item5);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> just(T item1, T item2, T item3, T item4, T item5, T item6) {
        ObjectHelper.requireNonNull(item1, (String)"The first item is null");
        ObjectHelper.requireNonNull(item2, (String)"The second item is null");
        ObjectHelper.requireNonNull(item3, (String)"The third item is null");
        ObjectHelper.requireNonNull(item4, (String)"The fourth item is null");
        ObjectHelper.requireNonNull(item5, (String)"The fifth item is null");
        ObjectHelper.requireNonNull(item6, (String)"The sixth item is null");
        return Flowable.fromArray(item1, item2, item3, item4, item5, item6);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> just(T item1, T item2, T item3, T item4, T item5, T item6, T item7) {
        ObjectHelper.requireNonNull(item1, (String)"The first item is null");
        ObjectHelper.requireNonNull(item2, (String)"The second item is null");
        ObjectHelper.requireNonNull(item3, (String)"The third item is null");
        ObjectHelper.requireNonNull(item4, (String)"The fourth item is null");
        ObjectHelper.requireNonNull(item5, (String)"The fifth item is null");
        ObjectHelper.requireNonNull(item6, (String)"The sixth item is null");
        ObjectHelper.requireNonNull(item7, (String)"The seventh item is null");
        return Flowable.fromArray(item1, item2, item3, item4, item5, item6, item7);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> just(T item1, T item2, T item3, T item4, T item5, T item6, T item7, T item8) {
        ObjectHelper.requireNonNull(item1, (String)"The first item is null");
        ObjectHelper.requireNonNull(item2, (String)"The second item is null");
        ObjectHelper.requireNonNull(item3, (String)"The third item is null");
        ObjectHelper.requireNonNull(item4, (String)"The fourth item is null");
        ObjectHelper.requireNonNull(item5, (String)"The fifth item is null");
        ObjectHelper.requireNonNull(item6, (String)"The sixth item is null");
        ObjectHelper.requireNonNull(item7, (String)"The seventh item is null");
        ObjectHelper.requireNonNull(item8, (String)"The eighth item is null");
        return Flowable.fromArray(item1, item2, item3, item4, item5, item6, item7, item8);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> just(T item1, T item2, T item3, T item4, T item5, T item6, T item7, T item8, T item9) {
        ObjectHelper.requireNonNull(item1, (String)"The first item is null");
        ObjectHelper.requireNonNull(item2, (String)"The second item is null");
        ObjectHelper.requireNonNull(item3, (String)"The third item is null");
        ObjectHelper.requireNonNull(item4, (String)"The fourth item is null");
        ObjectHelper.requireNonNull(item5, (String)"The fifth item is null");
        ObjectHelper.requireNonNull(item6, (String)"The sixth item is null");
        ObjectHelper.requireNonNull(item7, (String)"The seventh item is null");
        ObjectHelper.requireNonNull(item8, (String)"The eighth item is null");
        ObjectHelper.requireNonNull(item9, (String)"The ninth is null");
        return Flowable.fromArray(item1, item2, item3, item4, item5, item6, item7, item8, item9);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> just(T item1, T item2, T item3, T item4, T item5, T item6, T item7, T item8, T item9, T item10) {
        ObjectHelper.requireNonNull(item1, (String)"The first item is null");
        ObjectHelper.requireNonNull(item2, (String)"The second item is null");
        ObjectHelper.requireNonNull(item3, (String)"The third item is null");
        ObjectHelper.requireNonNull(item4, (String)"The fourth item is null");
        ObjectHelper.requireNonNull(item5, (String)"The fifth item is null");
        ObjectHelper.requireNonNull(item6, (String)"The sixth item is null");
        ObjectHelper.requireNonNull(item7, (String)"The seventh item is null");
        ObjectHelper.requireNonNull(item8, (String)"The eighth item is null");
        ObjectHelper.requireNonNull(item9, (String)"The ninth item is null");
        ObjectHelper.requireNonNull(item10, (String)"The tenth item is null");
        return Flowable.fromArray(item1, item2, item3, item4, item5, item6, item7, item8, item9, item10);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> merge(Iterable<? extends Publisher<? extends T>> sources, int maxConcurrency, int bufferSize) {
        return Flowable.fromIterable(sources).flatMap(Functions.identity(), false, maxConcurrency, bufferSize);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> mergeArray(int maxConcurrency, int bufferSize, Publisher<? extends T> ... sources) {
        return Flowable.fromArray(sources).flatMap(Functions.identity(), false, maxConcurrency, bufferSize);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> merge(Iterable<? extends Publisher<? extends T>> sources) {
        return Flowable.fromIterable(sources).flatMap(Functions.identity());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> merge(Iterable<? extends Publisher<? extends T>> sources, int maxConcurrency) {
        return Flowable.fromIterable(sources).flatMap(Functions.identity(), maxConcurrency);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> merge(Publisher<? extends Publisher<? extends T>> sources) {
        return Flowable.merge(sources, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> merge(Publisher<? extends Publisher<? extends T>> sources, int maxConcurrency) {
        return Flowable.fromPublisher(sources).flatMap(Functions.identity(), maxConcurrency);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> mergeArray(Publisher<? extends T> ... sources) {
        return Flowable.fromArray(sources).flatMap(Functions.identity(), sources.length);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> merge(Publisher<? extends T> source1, Publisher<? extends T> source2) {
        ObjectHelper.requireNonNull(source1, (String)"source1 is null");
        ObjectHelper.requireNonNull(source2, (String)"source2 is null");
        return Flowable.fromArray(source1, source2).flatMap(Functions.identity(), false, 2);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> merge(Publisher<? extends T> source1, Publisher<? extends T> source2, Publisher<? extends T> source3) {
        ObjectHelper.requireNonNull(source1, (String)"source1 is null");
        ObjectHelper.requireNonNull(source2, (String)"source2 is null");
        ObjectHelper.requireNonNull(source3, (String)"source3 is null");
        return Flowable.fromArray(source1, source2, source3).flatMap(Functions.identity(), false, 3);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> merge(Publisher<? extends T> source1, Publisher<? extends T> source2, Publisher<? extends T> source3, Publisher<? extends T> source4) {
        ObjectHelper.requireNonNull(source1, (String)"source1 is null");
        ObjectHelper.requireNonNull(source2, (String)"source2 is null");
        ObjectHelper.requireNonNull(source3, (String)"source3 is null");
        ObjectHelper.requireNonNull(source4, (String)"source4 is null");
        return Flowable.fromArray(source1, source2, source3, source4).flatMap(Functions.identity(), false, 4);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> mergeDelayError(Iterable<? extends Publisher<? extends T>> sources) {
        return Flowable.fromIterable(sources).flatMap(Functions.identity(), true);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> mergeDelayError(Iterable<? extends Publisher<? extends T>> sources, int maxConcurrency, int bufferSize) {
        return Flowable.fromIterable(sources).flatMap(Functions.identity(), true, maxConcurrency, bufferSize);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> mergeArrayDelayError(int maxConcurrency, int bufferSize, Publisher<? extends T> ... sources) {
        return Flowable.fromArray(sources).flatMap(Functions.identity(), true, maxConcurrency, bufferSize);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> mergeDelayError(Iterable<? extends Publisher<? extends T>> sources, int maxConcurrency) {
        return Flowable.fromIterable(sources).flatMap(Functions.identity(), true, maxConcurrency);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> mergeDelayError(Publisher<? extends Publisher<? extends T>> sources) {
        return Flowable.mergeDelayError(sources, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> mergeDelayError(Publisher<? extends Publisher<? extends T>> sources, int maxConcurrency) {
        return Flowable.fromPublisher(sources).flatMap(Functions.identity(), true, maxConcurrency);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> mergeArrayDelayError(Publisher<? extends T> ... sources) {
        return Flowable.fromArray(sources).flatMap(Functions.identity(), true, sources.length);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> mergeDelayError(Publisher<? extends T> source1, Publisher<? extends T> source2) {
        ObjectHelper.requireNonNull(source1, (String)"source1 is null");
        ObjectHelper.requireNonNull(source2, (String)"source2 is null");
        return Flowable.fromArray(source1, source2).flatMap(Functions.identity(), true, 2);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> mergeDelayError(Publisher<? extends T> source1, Publisher<? extends T> source2, Publisher<? extends T> source3) {
        ObjectHelper.requireNonNull(source1, (String)"source1 is null");
        ObjectHelper.requireNonNull(source2, (String)"source2 is null");
        ObjectHelper.requireNonNull(source3, (String)"source3 is null");
        return Flowable.fromArray(source1, source2, source3).flatMap(Functions.identity(), true, 3);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> mergeDelayError(Publisher<? extends T> source1, Publisher<? extends T> source2, Publisher<? extends T> source3, Publisher<? extends T> source4) {
        ObjectHelper.requireNonNull(source1, (String)"source1 is null");
        ObjectHelper.requireNonNull(source2, (String)"source2 is null");
        ObjectHelper.requireNonNull(source3, (String)"source3 is null");
        ObjectHelper.requireNonNull(source4, (String)"source4 is null");
        return Flowable.fromArray(source1, source2, source3, source4).flatMap(Functions.identity(), true, 4);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> never() {
        return RxJavaFlowablePlugins.onAssembly(FlowableNever.INSTANCE);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static Flowable<Integer> range(int start, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("count >= 0 required but it was " + count);
        }
        if (count == 0) {
            return Flowable.empty();
        }
        if (count == 1) {
            return Flowable.just(start);
        }
        if ((long)start + (long)(count - 1) > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Integer overflow");
        }
        return RxJavaFlowablePlugins.onAssembly(new FlowableRange(start, count));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static Flowable<Long> rangeLong(long start, long count) {
        if (count < 0L) {
            throw new IllegalArgumentException("count >= 0 required but it was " + count);
        }
        if (count == 0L) {
            return Flowable.empty();
        }
        if (count == 1L) {
            return Flowable.just(start);
        }
        long end = start + (count - 1L);
        if (start > 0L && end < 0L) {
            throw new IllegalArgumentException("Overflow! start + count is bigger than Long.MAX_VALUE");
        }
        return RxJavaFlowablePlugins.onAssembly(new FlowableRangeLong(start, count));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<Boolean> sequenceEqual(Publisher<? extends T> source1, Publisher<? extends T> source2) {
        return Flowable.sequenceEqual(source1, source2, ObjectHelper.equalsPredicate(), Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<Boolean> sequenceEqual(Publisher<? extends T> source1, Publisher<? extends T> source2, BiPredicate<? super T, ? super T> isEqual) {
        return Flowable.sequenceEqual(source1, source2, isEqual, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<Boolean> sequenceEqual(Publisher<? extends T> source1, Publisher<? extends T> source2, BiPredicate<? super T, ? super T> isEqual, int bufferSize) {
        ObjectHelper.requireNonNull(source1, (String)"source1 is null");
        ObjectHelper.requireNonNull(source2, (String)"source2 is null");
        ObjectHelper.requireNonNull(isEqual, (String)"isEqual is null");
        ObjectHelper.verifyPositive((int)bufferSize, (String)"bufferSize");
        return RxJavaFlowablePlugins.onAssembly(new FlowableSequenceEqual<T>(source1, source2, isEqual, bufferSize));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<Boolean> sequenceEqual(Publisher<? extends T> source1, Publisher<? extends T> source2, int bufferSize) {
        return Flowable.sequenceEqual(source1, source2, ObjectHelper.equalsPredicate(), bufferSize);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> switchOnNext(Publisher<? extends Publisher<? extends T>> sources, int bufferSize) {
        return Flowable.fromPublisher(sources).switchMap(Functions.identity(), bufferSize);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> switchOnNext(Publisher<? extends Publisher<? extends T>> sources) {
        return Flowable.fromPublisher(sources).switchMap(Functions.identity());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> switchOnNextDelayError(Publisher<? extends Publisher<? extends T>> sources) {
        return Flowable.switchOnNextDelayError(sources, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> switchOnNextDelayError(Publisher<? extends Publisher<? extends T>> sources, int prefetch) {
        return Flowable.fromPublisher(sources).switchMapDelayError(Functions.identity(), prefetch);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    public static Flowable<Long> timer(long delay, TimeUnit unit) {
        return Flowable.timer(delay, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    public static Flowable<Long> timer(long delay, TimeUnit unit, Scheduler scheduler) {
        ObjectHelper.requireNonNull((Object)((Object)unit), (String)"unit is null");
        ObjectHelper.requireNonNull((Object)scheduler, (String)"scheduler is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableTimer(Math.max(0L, delay), unit, scheduler));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.NONE)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> unsafeCreate(Publisher<T> onSubscribe) {
        ObjectHelper.requireNonNull(onSubscribe, (String)"onSubscribe is null");
        if (onSubscribe instanceof Flowable) {
            throw new IllegalArgumentException("unsafeCreate(Flowable) should be upgraded");
        }
        return RxJavaFlowablePlugins.onAssembly(new FlowableFromPublisher<T>(onSubscribe));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public static <T, D> Flowable<T> using(Callable<? extends D> resourceSupplier, Function<? super D, ? extends Publisher<? extends T>> sourceSupplier, Consumer<? super D> resourceDisposer) {
        return Flowable.using(resourceSupplier, sourceSupplier, resourceDisposer, true);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public static <T, D> Flowable<T> using(Callable<? extends D> resourceSupplier, Function<? super D, ? extends Publisher<? extends T>> sourceSupplier, Consumer<? super D> resourceDisposer, boolean eager) {
        ObjectHelper.requireNonNull(resourceSupplier, (String)"resourceSupplier is null");
        ObjectHelper.requireNonNull(sourceSupplier, (String)"sourceSupplier is null");
        ObjectHelper.requireNonNull(resourceDisposer, (String)"disposer is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableUsing(resourceSupplier, sourceSupplier, resourceDisposer, eager));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T, R> Flowable<R> zip(Iterable<? extends Publisher<? extends T>> sources, Function<? super Object[], ? extends R> zipper) {
        ObjectHelper.requireNonNull(zipper, (String)"zipper is null");
        ObjectHelper.requireNonNull(sources, (String)"sources is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableZip(null, sources, zipper, Flowable.bufferSize(), false));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T, R> Flowable<R> zip(Publisher<? extends Publisher<? extends T>> sources, Function<? super Object[], ? extends R> zipper) {
        ObjectHelper.requireNonNull(zipper, (String)"zipper is null");
        return Flowable.fromPublisher(sources).toList().flatMap(FlowableInternalHelper.zipIterable(zipper));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T1, T2, R> Flowable<R> zip(Publisher<? extends T1> source1, Publisher<? extends T2> source2, BiFunction<? super T1, ? super T2, ? extends R> zipper) {
        ObjectHelper.requireNonNull(source1, (String)"source1 is null");
        ObjectHelper.requireNonNull(source2, (String)"source2 is null");
        return Flowable.zipArray(Functions.toFunction(zipper), false, Flowable.bufferSize(), source1, source2);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T1, T2, R> Flowable<R> zip(Publisher<? extends T1> source1, Publisher<? extends T2> source2, BiFunction<? super T1, ? super T2, ? extends R> zipper, boolean delayError) {
        ObjectHelper.requireNonNull(source1, (String)"source1 is null");
        ObjectHelper.requireNonNull(source2, (String)"source2 is null");
        return Flowable.zipArray(Functions.toFunction(zipper), delayError, Flowable.bufferSize(), source1, source2);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T1, T2, R> Flowable<R> zip(Publisher<? extends T1> source1, Publisher<? extends T2> source2, BiFunction<? super T1, ? super T2, ? extends R> zipper, boolean delayError, int bufferSize) {
        ObjectHelper.requireNonNull(source1, (String)"source1 is null");
        ObjectHelper.requireNonNull(source2, (String)"source2 is null");
        return Flowable.zipArray(Functions.toFunction(zipper), delayError, bufferSize, source1, source2);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T1, T2, T3, R> Flowable<R> zip(Publisher<? extends T1> source1, Publisher<? extends T2> source2, Publisher<? extends T3> source3, Function3<? super T1, ? super T2, ? super T3, ? extends R> zipper) {
        ObjectHelper.requireNonNull(source1, (String)"source1 is null");
        ObjectHelper.requireNonNull(source2, (String)"source2 is null");
        ObjectHelper.requireNonNull(source3, (String)"source3 is null");
        return Flowable.zipArray(Functions.toFunction(zipper), false, Flowable.bufferSize(), source1, source2, source3);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T1, T2, T3, T4, R> Flowable<R> zip(Publisher<? extends T1> source1, Publisher<? extends T2> source2, Publisher<? extends T3> source3, Publisher<? extends T4> source4, Function4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> zipper) {
        ObjectHelper.requireNonNull(source1, (String)"source1 is null");
        ObjectHelper.requireNonNull(source2, (String)"source2 is null");
        ObjectHelper.requireNonNull(source3, (String)"source3 is null");
        ObjectHelper.requireNonNull(source4, (String)"source4 is null");
        return Flowable.zipArray(Functions.toFunction(zipper), false, Flowable.bufferSize(), source1, source2, source3, source4);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T1, T2, T3, T4, T5, R> Flowable<R> zip(Publisher<? extends T1> source1, Publisher<? extends T2> source2, Publisher<? extends T3> source3, Publisher<? extends T4> source4, Publisher<? extends T5> source5, Function5<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? extends R> zipper) {
        ObjectHelper.requireNonNull(source1, (String)"source1 is null");
        ObjectHelper.requireNonNull(source2, (String)"source2 is null");
        ObjectHelper.requireNonNull(source3, (String)"source3 is null");
        ObjectHelper.requireNonNull(source4, (String)"source4 is null");
        ObjectHelper.requireNonNull(source5, (String)"source5 is null");
        return Flowable.zipArray(Functions.toFunction(zipper), false, Flowable.bufferSize(), source1, source2, source3, source4, source5);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T1, T2, T3, T4, T5, T6, R> Flowable<R> zip(Publisher<? extends T1> source1, Publisher<? extends T2> source2, Publisher<? extends T3> source3, Publisher<? extends T4> source4, Publisher<? extends T5> source5, Publisher<? extends T6> source6, Function6<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? extends R> zipper) {
        ObjectHelper.requireNonNull(source1, (String)"source1 is null");
        ObjectHelper.requireNonNull(source2, (String)"source2 is null");
        ObjectHelper.requireNonNull(source3, (String)"source3 is null");
        ObjectHelper.requireNonNull(source4, (String)"source4 is null");
        ObjectHelper.requireNonNull(source5, (String)"source5 is null");
        ObjectHelper.requireNonNull(source6, (String)"source6 is null");
        return Flowable.zipArray(Functions.toFunction(zipper), false, Flowable.bufferSize(), source1, source2, source3, source4, source5, source6);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T1, T2, T3, T4, T5, T6, T7, R> Flowable<R> zip(Publisher<? extends T1> source1, Publisher<? extends T2> source2, Publisher<? extends T3> source3, Publisher<? extends T4> source4, Publisher<? extends T5> source5, Publisher<? extends T6> source6, Publisher<? extends T7> source7, Function7<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? extends R> zipper) {
        ObjectHelper.requireNonNull(source1, (String)"source1 is null");
        ObjectHelper.requireNonNull(source2, (String)"source2 is null");
        ObjectHelper.requireNonNull(source3, (String)"source3 is null");
        ObjectHelper.requireNonNull(source4, (String)"source4 is null");
        ObjectHelper.requireNonNull(source5, (String)"source5 is null");
        ObjectHelper.requireNonNull(source6, (String)"source6 is null");
        ObjectHelper.requireNonNull(source7, (String)"source7 is null");
        return Flowable.zipArray(Functions.toFunction(zipper), false, Flowable.bufferSize(), source1, source2, source3, source4, source5, source6, source7);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T1, T2, T3, T4, T5, T6, T7, T8, R> Flowable<R> zip(Publisher<? extends T1> source1, Publisher<? extends T2> source2, Publisher<? extends T3> source3, Publisher<? extends T4> source4, Publisher<? extends T5> source5, Publisher<? extends T6> source6, Publisher<? extends T7> source7, Publisher<? extends T8> source8, Function8<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? extends R> zipper) {
        ObjectHelper.requireNonNull(source1, (String)"source1 is null");
        ObjectHelper.requireNonNull(source2, (String)"source2 is null");
        ObjectHelper.requireNonNull(source3, (String)"source3 is null");
        ObjectHelper.requireNonNull(source4, (String)"source4 is null");
        ObjectHelper.requireNonNull(source5, (String)"source5 is null");
        ObjectHelper.requireNonNull(source6, (String)"source6 is null");
        ObjectHelper.requireNonNull(source7, (String)"source7 is null");
        ObjectHelper.requireNonNull(source8, (String)"source8 is null");
        return Flowable.zipArray(Functions.toFunction(zipper), false, Flowable.bufferSize(), source1, source2, source3, source4, source5, source6, source7, source8);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, R> Flowable<R> zip(Publisher<? extends T1> source1, Publisher<? extends T2> source2, Publisher<? extends T3> source3, Publisher<? extends T4> source4, Publisher<? extends T5> source5, Publisher<? extends T6> source6, Publisher<? extends T7> source7, Publisher<? extends T8> source8, Publisher<? extends T9> source9, Function9<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? extends R> zipper) {
        ObjectHelper.requireNonNull(source1, (String)"source1 is null");
        ObjectHelper.requireNonNull(source2, (String)"source2 is null");
        ObjectHelper.requireNonNull(source3, (String)"source3 is null");
        ObjectHelper.requireNonNull(source4, (String)"source4 is null");
        ObjectHelper.requireNonNull(source5, (String)"source5 is null");
        ObjectHelper.requireNonNull(source6, (String)"source6 is null");
        ObjectHelper.requireNonNull(source7, (String)"source7 is null");
        ObjectHelper.requireNonNull(source8, (String)"source8 is null");
        ObjectHelper.requireNonNull(source9, (String)"source9 is null");
        return Flowable.zipArray(Functions.toFunction(zipper), false, Flowable.bufferSize(), source1, source2, source3, source4, source5, source6, source7, source8, source9);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T, R> Flowable<R> zipArray(Function<? super Object[], ? extends R> zipper, boolean delayError, int bufferSize, Publisher<? extends T> ... sources) {
        if (sources.length == 0) {
            return Flowable.empty();
        }
        ObjectHelper.requireNonNull(zipper, (String)"zipper is null");
        ObjectHelper.verifyPositive((int)bufferSize, (String)"bufferSize");
        return RxJavaFlowablePlugins.onAssembly(new FlowableZip<T, R>(sources, null, zipper, bufferSize, delayError));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T, R> Flowable<R> zipIterable(Iterable<? extends Publisher<? extends T>> sources, Function<? super Object[], ? extends R> zipper, boolean delayError, int bufferSize) {
        ObjectHelper.requireNonNull(zipper, (String)"zipper is null");
        ObjectHelper.requireNonNull(sources, (String)"sources is null");
        ObjectHelper.verifyPositive((int)bufferSize, (String)"bufferSize");
        return RxJavaFlowablePlugins.onAssembly(new FlowableZip(null, sources, zipper, bufferSize, delayError));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Flowable<Boolean> all(Predicate<? super T> predicate) {
        ObjectHelper.requireNonNull(predicate, (String)"predicate is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableAll<T>(this, predicate));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> ambWith(Publisher<? extends T> other) {
        ObjectHelper.requireNonNull(other, (String)"other is null");
        return Flowable.ambArray(this, other);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Flowable<Boolean> any(Predicate<? super T> predicate) {
        ObjectHelper.requireNonNull(predicate, (String)"predicate is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableAny<T>(this, predicate));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final T blockingFirst() {
        BlockingFirstSubscriber s = new BlockingFirstSubscriber();
        this.subscribe(s);
        Object v = s.blockingGet();
        if (v != null) {
            return v;
        }
        throw new NoSuchElementException();
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final T blockingFirst(T defaultItem) {
        BlockingFirstSubscriber s = new BlockingFirstSubscriber();
        this.subscribe(s);
        Object v = s.blockingGet();
        return v != null ? v : defaultItem;
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final void blockingForEach(Consumer<? super T> onNext) {
        Iterator<T> it = this.blockingIterable().iterator();
        while (it.hasNext()) {
            try {
                onNext.accept(it.next());
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                ((Disposable)it).dispose();
                throw ExceptionHelper.wrapOrThrow((Throwable)e);
            }
        }
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Iterable<T> blockingIterable() {
        return this.blockingIterable(Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Iterable<T> blockingIterable(int bufferSize) {
        ObjectHelper.verifyPositive((int)bufferSize, (String)"bufferSize");
        return new BlockingFlowableIterable(this, bufferSize);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final T blockingLast() {
        BlockingLastSubscriber s = new BlockingLastSubscriber();
        this.subscribe(s);
        Object v = s.blockingGet();
        if (v != null) {
            return v;
        }
        throw new NoSuchElementException();
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final T blockingLast(T defaultItem) {
        BlockingLastSubscriber s = new BlockingLastSubscriber();
        this.subscribe(s);
        Object v = s.blockingGet();
        return v != null ? v : defaultItem;
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Iterable<T> blockingLatest() {
        return new BlockingFlowableLatest(this);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Iterable<T> blockingMostRecent(T initialItem) {
        return new BlockingFlowableMostRecent<T>(this, initialItem);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Iterable<T> blockingNext() {
        return new BlockingFlowableNext(this);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final T blockingSingle() {
        return this.singleOrError().blockingLast();
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final T blockingSingle(T defaultItem) {
        return this.single(defaultItem).blockingLast();
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Future<T> toFuture() {
        return this.subscribeWith((Subscriber)new FutureSubscriber());
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final void blockingSubscribe() {
        FlowableBlockingSubscribe.subscribe(this);
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final void blockingSubscribe(Consumer<? super T> onNext) {
        FlowableBlockingSubscribe.subscribe(this, onNext, (Consumer<? super Throwable>)Functions.ON_ERROR_MISSING, Functions.EMPTY_ACTION);
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final void blockingSubscribe(Consumer<? super T> onNext, Consumer<? super Throwable> onError) {
        FlowableBlockingSubscribe.subscribe(this, onNext, onError, Functions.EMPTY_ACTION);
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final void blockingSubscribe(Consumer<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete) {
        FlowableBlockingSubscribe.subscribe(this, onNext, onError, onComplete);
    }

    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    public final void blockingSubscribe(Subscriber<? super T> subscriber) {
        FlowableBlockingSubscribe.subscribe(this, subscriber);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<List<T>> buffer(int count) {
        return this.buffer(count, count);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<List<T>> buffer(int count, int skip) {
        return this.buffer(count, skip, ArrayListSupplier.asCallable());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <U extends Collection<? super T>> Flowable<U> buffer(int count, int skip, Callable<U> bufferSupplier) {
        ObjectHelper.verifyPositive((int)count, (String)"count");
        ObjectHelper.verifyPositive((int)skip, (String)"skip");
        ObjectHelper.requireNonNull(bufferSupplier, (String)"bufferSupplier is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableBuffer(this, count, skip, bufferSupplier));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <U extends Collection<? super T>> Flowable<U> buffer(int count, Callable<U> bufferSupplier) {
        return this.buffer(count, count, bufferSupplier);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    public final Flowable<List<T>> buffer(long timespan, long timeskip, TimeUnit unit) {
        return this.buffer(timespan, timeskip, unit, Schedulers.computation(), ArrayListSupplier.asCallable());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    public final Flowable<List<T>> buffer(long timespan, long timeskip, TimeUnit unit, Scheduler scheduler) {
        return this.buffer(timespan, timeskip, unit, scheduler, ArrayListSupplier.asCallable());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    public final <U extends Collection<? super T>> Flowable<U> buffer(long timespan, long timeskip, TimeUnit unit, Scheduler scheduler, Callable<U> bufferSupplier) {
        ObjectHelper.requireNonNull((Object)((Object)unit), (String)"unit is null");
        ObjectHelper.requireNonNull((Object)scheduler, (String)"scheduler is null");
        ObjectHelper.requireNonNull(bufferSupplier, (String)"bufferSupplier is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableBufferTimed(this, timespan, timeskip, unit, scheduler, bufferSupplier, Integer.MAX_VALUE, false));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    public final Flowable<List<T>> buffer(long timespan, TimeUnit unit) {
        return this.buffer(timespan, unit, Schedulers.computation(), Integer.MAX_VALUE);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    public final Flowable<List<T>> buffer(long timespan, TimeUnit unit, int count) {
        return this.buffer(timespan, unit, Schedulers.computation(), count);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    public final Flowable<List<T>> buffer(long timespan, TimeUnit unit, Scheduler scheduler, int count) {
        return this.buffer(timespan, unit, scheduler, count, ArrayListSupplier.asCallable(), false);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    public final <U extends Collection<? super T>> Flowable<U> buffer(long timespan, TimeUnit unit, Scheduler scheduler, int count, Callable<U> bufferSupplier, boolean restartTimerOnMaxSize) {
        ObjectHelper.requireNonNull((Object)((Object)unit), (String)"unit is null");
        ObjectHelper.requireNonNull((Object)scheduler, (String)"scheduler is null");
        ObjectHelper.requireNonNull(bufferSupplier, (String)"bufferSupplier is null");
        ObjectHelper.verifyPositive((int)count, (String)"count");
        return RxJavaFlowablePlugins.onAssembly(new FlowableBufferTimed(this, timespan, timespan, unit, scheduler, bufferSupplier, count, restartTimerOnMaxSize));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    public final Flowable<List<T>> buffer(long timespan, TimeUnit unit, Scheduler scheduler) {
        return this.buffer(timespan, unit, scheduler, Integer.MAX_VALUE, ArrayListSupplier.asCallable(), false);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    public final <TOpening, TClosing> Flowable<List<T>> buffer(Flowable<? extends TOpening> openingIndicator, Function<? super TOpening, ? extends Publisher<? extends TClosing>> closingIndicator) {
        return this.buffer(openingIndicator, closingIndicator, ArrayListSupplier.asCallable());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    public final <TOpening, TClosing, U extends Collection<? super T>> Flowable<U> buffer(Flowable<? extends TOpening> openingIndicator, Function<? super TOpening, ? extends Publisher<? extends TClosing>> closingIndicator, Callable<U> bufferSupplier) {
        ObjectHelper.requireNonNull(openingIndicator, (String)"openingIndicator is null");
        ObjectHelper.requireNonNull(closingIndicator, (String)"closingIndicator is null");
        ObjectHelper.requireNonNull(bufferSupplier, (String)"bufferSupplier is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableBufferBoundary(this, openingIndicator, closingIndicator, bufferSupplier));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    public final <B> Flowable<List<T>> buffer(Publisher<B> boundaryIndicator) {
        return this.buffer(boundaryIndicator, ArrayListSupplier.asCallable());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    public final <B> Flowable<List<T>> buffer(Publisher<B> boundaryIndicator, int initialCapacity) {
        ObjectHelper.verifyPositive((int)initialCapacity, (String)"initialCapacity");
        return this.buffer(boundaryIndicator, Functions.createArrayList((int)initialCapacity));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    public final <B, U extends Collection<? super T>> Flowable<U> buffer(Publisher<B> boundaryIndicator, Callable<U> bufferSupplier) {
        ObjectHelper.requireNonNull(boundaryIndicator, (String)"boundaryIndicator is null");
        ObjectHelper.requireNonNull(bufferSupplier, (String)"bufferSupplier is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableBufferExactBoundary(this, boundaryIndicator, bufferSupplier));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    public final <B> Flowable<List<T>> buffer(Callable<? extends Publisher<B>> boundaryIndicatorSupplier) {
        return this.buffer(boundaryIndicatorSupplier, ArrayListSupplier.asCallable());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    public final <B, U extends Collection<? super T>> Flowable<U> buffer(Callable<? extends Publisher<B>> boundaryIndicatorSupplier, Callable<U> bufferSupplier) {
        ObjectHelper.requireNonNull(boundaryIndicatorSupplier, (String)"boundaryIndicatorSupplier is null");
        ObjectHelper.requireNonNull(bufferSupplier, (String)"bufferSupplier is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableBufferBoundarySupplier(this, boundaryIndicatorSupplier, bufferSupplier));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> cache() {
        return this.cacheWithInitialCapacity(16);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> cacheWithInitialCapacity(int initialCapacity) {
        ObjectHelper.verifyPositive((int)initialCapacity, (String)"initialCapacity");
        return RxJavaFlowablePlugins.onAssembly(new FlowableCache(this, initialCapacity));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final <U> Flowable<U> cast(Class<U> clazz) {
        ObjectHelper.requireNonNull(clazz, (String)"clazz is null");
        return this.map(Functions.castFunction(clazz));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final <U> Flowable<U> collect(Callable<? extends U> initialItemSupplier, BiConsumer<? super U, ? super T> collector) {
        ObjectHelper.requireNonNull(initialItemSupplier, (String)"initialItemSupplier is null");
        ObjectHelper.requireNonNull(collector, (String)"collector is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableCollect<T, U>(this, initialItemSupplier, collector));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final <U> Flowable<U> collectInto(U initialItem, BiConsumer<? super U, ? super T> collector) {
        ObjectHelper.requireNonNull(initialItem, (String)"initialItem is null");
        return this.collect(Functions.justCallable(initialItem), collector);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> compose(FlowableTransformer<? super T, ? extends R> composer) {
        return Flowable.fromPublisher(((FlowableTransformer)ObjectHelper.requireNonNull(composer, (String)"composer is null")).apply(this));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> concatMap(Function<? super T, ? extends Publisher<? extends R>> mapper) {
        return this.concatMap(mapper, 2);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> concatMap(Function<? super T, ? extends Publisher<? extends R>> mapper, int prefetch) {
        ObjectHelper.requireNonNull(mapper, (String)"mapper is null");
        ObjectHelper.verifyPositive((int)prefetch, (String)"prefetch");
        if (this instanceof ConstantValuePublisher) {
            Object v = ((ConstantValuePublisher)this).value();
            if (v == null) {
                return Flowable.empty();
            }
            return FlowableScalarXMap.scalarXMap(v, mapper);
        }
        return RxJavaFlowablePlugins.onAssembly(new FlowableConcatMap(this, mapper, prefetch, ErrorMode.IMMEDIATE));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> concatMapDelayError(Function<? super T, ? extends Publisher<? extends R>> mapper) {
        return this.concatMapDelayError(mapper, 2, true);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> concatMapDelayError(Function<? super T, ? extends Publisher<? extends R>> mapper, int prefetch, boolean tillTheEnd) {
        ObjectHelper.requireNonNull(mapper, (String)"mapper is null");
        ObjectHelper.verifyPositive((int)prefetch, (String)"prefetch");
        if (this instanceof ConstantValuePublisher) {
            Object v = ((ConstantValuePublisher)this).value();
            if (v == null) {
                return Flowable.empty();
            }
            return FlowableScalarXMap.scalarXMap(v, mapper);
        }
        return RxJavaFlowablePlugins.onAssembly(new FlowableConcatMap(this, mapper, prefetch, tillTheEnd ? ErrorMode.END : ErrorMode.BOUNDARY));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> concatMapEager(Function<? super T, ? extends Publisher<? extends R>> mapper) {
        return this.concatMapEager(mapper, Flowable.bufferSize(), Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> concatMapEager(Function<? super T, ? extends Publisher<? extends R>> mapper, int maxConcurrency, int prefetch) {
        ObjectHelper.requireNonNull(mapper, (String)"mapper is null");
        ObjectHelper.verifyPositive((int)maxConcurrency, (String)"maxConcurrency");
        ObjectHelper.verifyPositive((int)prefetch, (String)"prefetch");
        return RxJavaFlowablePlugins.onAssembly(new FlowableConcatMapEager(this, mapper, maxConcurrency, prefetch, ErrorMode.IMMEDIATE));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> concatMapEagerDelayError(Function<? super T, ? extends Publisher<? extends R>> mapper, boolean tillTheEnd) {
        return this.concatMapEagerDelayError(mapper, Flowable.bufferSize(), Flowable.bufferSize(), tillTheEnd);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> concatMapEagerDelayError(Function<? super T, ? extends Publisher<? extends R>> mapper, int maxConcurrency, int prefetch, boolean tillTheEnd) {
        ObjectHelper.requireNonNull(mapper, (String)"mapper is null");
        ObjectHelper.verifyPositive((int)maxConcurrency, (String)"maxConcurrency");
        ObjectHelper.verifyPositive((int)prefetch, (String)"prefetch");
        return RxJavaFlowablePlugins.onAssembly(new FlowableConcatMapEager(this, mapper, maxConcurrency, prefetch, tillTheEnd ? ErrorMode.END : ErrorMode.BOUNDARY));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <U> Flowable<U> concatMapIterable(Function<? super T, ? extends Iterable<? extends U>> mapper) {
        return this.concatMapIterable(mapper, 2);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <U> Flowable<U> concatMapIterable(Function<? super T, ? extends Iterable<? extends U>> mapper, int prefetch) {
        ObjectHelper.requireNonNull(mapper, (String)"mapper is null");
        ObjectHelper.verifyPositive((int)prefetch, (String)"prefetch");
        return RxJavaFlowablePlugins.onAssembly(new FlowableFlattenIterable(this, mapper, prefetch));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> concatWith(Publisher<? extends T> other) {
        ObjectHelper.requireNonNull(other, (String)"other is null");
        return Flowable.concat(this, other);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Flowable<Boolean> contains(Object item) {
        ObjectHelper.requireNonNull((Object)item, (String)"item is null");
        return this.any(Functions.equalsWith((Object)item));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Flowable<Long> count() {
        return RxJavaFlowablePlugins.onAssembly(new FlowableCount(this));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    public final <U> Flowable<T> debounce(Function<? super T, ? extends Publisher<U>> debounceIndicator) {
        ObjectHelper.requireNonNull(debounceIndicator, (String)"debounceIndicator is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableDebounce(this, debounceIndicator));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    public final Flowable<T> debounce(long timeout, TimeUnit unit) {
        return this.debounce(timeout, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    public final Flowable<T> debounce(long timeout, TimeUnit unit, Scheduler scheduler) {
        ObjectHelper.requireNonNull((Object)((Object)unit), (String)"unit is null");
        ObjectHelper.requireNonNull((Object)scheduler, (String)"scheduler is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableDebounceTimed(this, timeout, unit, scheduler));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> defaultIfEmpty(T defaultItem) {
        ObjectHelper.requireNonNull(defaultItem, (String)"item is null");
        return this.switchIfEmpty(Flowable.just(defaultItem));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <U> Flowable<T> delay(Function<? super T, ? extends Publisher<U>> itemDelayIndicator) {
        ObjectHelper.requireNonNull(itemDelayIndicator, (String)"itemDelayIndicator is null");
        return this.flatMap(FlowableInternalHelper.itemDelay(itemDelayIndicator));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="io.reactivex:computation")
    public final Flowable<T> delay(long delay, TimeUnit unit) {
        return this.delay(delay, unit, Schedulers.computation(), false);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="io.reactivex:computation")
    public final Flowable<T> delay(long delay, TimeUnit unit, boolean delayError) {
        return this.delay(delay, unit, Schedulers.computation(), delayError);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public final Flowable<T> delay(long delay, TimeUnit unit, Scheduler scheduler) {
        return this.delay(delay, unit, scheduler, false);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public final Flowable<T> delay(long delay, TimeUnit unit, Scheduler scheduler, boolean delayError) {
        ObjectHelper.requireNonNull((Object)((Object)unit), (String)"unit is null");
        ObjectHelper.requireNonNull((Object)scheduler, (String)"scheduler is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableDelay(this, Math.max(0L, delay), unit, scheduler, delayError));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <U, V> Flowable<T> delay(Publisher<U> subscriptionIndicator, Function<? super T, ? extends Publisher<V>> itemDelayIndicator) {
        return this.delaySubscription(subscriptionIndicator).delay(itemDelayIndicator);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <U> Flowable<T> delaySubscription(Publisher<U> subscriptionIndicator) {
        ObjectHelper.requireNonNull(subscriptionIndicator, (String)"subscriptionIndicator is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableDelaySubscriptionOther(this, subscriptionIndicator));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="io.reactivex:computation")
    public final Flowable<T> delaySubscription(long delay, TimeUnit unit) {
        return this.delaySubscription(delay, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public final Flowable<T> delaySubscription(long delay, TimeUnit unit, Scheduler scheduler) {
        return this.delaySubscription(Flowable.timer(delay, unit, scheduler));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <T2> Flowable<T2> dematerialize() {
        Flowable m = this;
        return RxJavaFlowablePlugins.onAssembly(new FlowableDematerialize(m));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> distinct() {
        return this.distinct(Functions.identity(), Functions.createHashSet());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <K> Flowable<T> distinct(Function<? super T, K> keySelector) {
        return this.distinct(keySelector, Functions.createHashSet());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <K> Flowable<T> distinct(Function<? super T, K> keySelector, Callable<? extends Collection<? super K>> collectionSupplier) {
        ObjectHelper.requireNonNull(keySelector, (String)"keySelector is null");
        ObjectHelper.requireNonNull(collectionSupplier, (String)"collectionSupplier is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableDistinct<T, K>(this, keySelector, collectionSupplier));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> distinctUntilChanged() {
        return this.distinctUntilChanged(Functions.identity());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <K> Flowable<T> distinctUntilChanged(Function<? super T, K> keySelector) {
        ObjectHelper.requireNonNull(keySelector, (String)"keySelector is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableDistinctUntilChanged<T, K>(this, keySelector, ObjectHelper.equalsPredicate()));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> distinctUntilChanged(BiPredicate<? super T, ? super T> comparer) {
        ObjectHelper.requireNonNull(comparer, (String)"comparer is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableDistinctUntilChanged(this, Functions.identity(), comparer));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @Experimental
    public final Flowable<T> doFinally(Action onFinally) {
        ObjectHelper.requireNonNull((Object)onFinally, (String)"onFinally is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableDoFinally(this, onFinally));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<T> doAfterNext(Consumer<? super T> onAfterNext) {
        ObjectHelper.requireNonNull(onAfterNext, (String)"onAfterNext is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableDoAfterNext<T>(this, onAfterNext));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<T> doAfterTerminate(Action onAfterTerminate) {
        return this.doOnEach(Functions.emptyConsumer(), (Consumer<Throwable>)Functions.emptyConsumer(), Functions.EMPTY_ACTION, onAfterTerminate);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<T> doOnCancel(Action onCancel) {
        return this.doOnLifecycle((Consumer<Subscription>)Functions.emptyConsumer(), Functions.EMPTY_LONG_CONSUMER, onCancel);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<T> doOnComplete(Action onComplete) {
        return this.doOnEach(Functions.emptyConsumer(), (Consumer<Throwable>)Functions.emptyConsumer(), onComplete, Functions.EMPTY_ACTION);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    private Flowable<T> doOnEach(Consumer<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete, Action onAfterTerminate) {
        ObjectHelper.requireNonNull(onNext, (String)"onNext is null");
        ObjectHelper.requireNonNull(onError, (String)"onError is null");
        ObjectHelper.requireNonNull((Object)onComplete, (String)"onComplete is null");
        ObjectHelper.requireNonNull((Object)onAfterTerminate, (String)"onAfterTerminate is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableDoOnEach<T>(this, onNext, onError, onComplete, onAfterTerminate));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<T> doOnEach(Consumer<? super Notification<T>> onNotification) {
        ObjectHelper.requireNonNull(onNotification, (String)"consumer is null");
        return this.doOnEach(Functions.notificationOnNext(onNotification), (Consumer<Throwable>)Functions.notificationOnError(onNotification), Functions.notificationOnComplete(onNotification), Functions.EMPTY_ACTION);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<T> doOnEach(Subscriber<? super T> subscriber) {
        ObjectHelper.requireNonNull(subscriber, (String)"subscriber is null");
        return this.doOnEach(FlowableInternalHelper.subscriberOnNext(subscriber), FlowableInternalHelper.subscriberOnError(subscriber), FlowableInternalHelper.subscriberOnComplete(subscriber), Functions.EMPTY_ACTION);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<T> doOnError(Consumer<? super Throwable> onError) {
        return this.doOnEach(Functions.emptyConsumer(), onError, Functions.EMPTY_ACTION, Functions.EMPTY_ACTION);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<T> doOnLifecycle(Consumer<? super Subscription> onSubscribe, LongConsumer onRequest, Action onCancel) {
        ObjectHelper.requireNonNull(onSubscribe, (String)"onSubscribe is null");
        ObjectHelper.requireNonNull((Object)onRequest, (String)"onRequest is null");
        ObjectHelper.requireNonNull((Object)onCancel, (String)"onCancel is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableDoOnLifecycle(this, onSubscribe, onRequest, onCancel));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<T> doOnNext(Consumer<? super T> onNext) {
        return this.doOnEach(onNext, (Consumer<Throwable>)Functions.emptyConsumer(), Functions.EMPTY_ACTION, Functions.EMPTY_ACTION);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<T> doOnRequest(LongConsumer onRequest) {
        return this.doOnLifecycle((Consumer<Subscription>)Functions.emptyConsumer(), onRequest, Functions.EMPTY_ACTION);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<T> doOnSubscribe(Consumer<? super Subscription> onSubscribe) {
        return this.doOnLifecycle(onSubscribe, Functions.EMPTY_LONG_CONSUMER, Functions.EMPTY_ACTION);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<T> doOnTerminate(Action onTerminate) {
        return this.doOnEach(Functions.emptyConsumer(), (Consumer<Throwable>)Functions.actionConsumer((Action)onTerminate), onTerminate, Functions.EMPTY_ACTION);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Flowable<T> elementAt(long index) {
        if (index < 0L) {
            throw new IndexOutOfBoundsException("index >= 0 required but it was " + index);
        }
        return RxJavaFlowablePlugins.onAssembly(new FlowableElementAt<Object>(this, index, null, false));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Flowable<T> elementAt(long index, T defaultItem) {
        if (index < 0L) {
            throw new IndexOutOfBoundsException("index >= 0 required but it was " + index);
        }
        ObjectHelper.requireNonNull(defaultItem, (String)"defaultItem is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableElementAt<T>(this, index, defaultItem, false));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Flowable<T> elementAtOrError(long index) {
        if (index < 0L) {
            throw new IndexOutOfBoundsException("index >= 0 required but it was " + index);
        }
        return RxJavaFlowablePlugins.onAssembly(new FlowableElementAt<Object>(this, index, null, true));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<T> filter(Predicate<? super T> predicate) {
        ObjectHelper.requireNonNull(predicate, (String)"predicate is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableFilter<T>(this, predicate));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    public final Flowable<T> firstElement() {
        return this.elementAt(0L);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    public final Flowable<T> first(T defaultItem) {
        return this.elementAt(0L, defaultItem);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    public final Flowable<T> firstOrError() {
        return this.elementAtOrError(0L);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> flatMap(Function<? super T, ? extends Publisher<? extends R>> mapper) {
        return this.flatMap(mapper, false, Flowable.bufferSize(), Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> flatMap(Function<? super T, ? extends Publisher<? extends R>> mapper, boolean delayErrors) {
        return this.flatMap(mapper, delayErrors, Flowable.bufferSize(), Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> flatMap(Function<? super T, ? extends Publisher<? extends R>> mapper, int maxConcurrency) {
        return this.flatMap(mapper, false, maxConcurrency, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> flatMap(Function<? super T, ? extends Publisher<? extends R>> mapper, boolean delayErrors, int maxConcurrency) {
        return this.flatMap(mapper, delayErrors, maxConcurrency, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> flatMap(Function<? super T, ? extends Publisher<? extends R>> mapper, boolean delayErrors, int maxConcurrency, int bufferSize) {
        ObjectHelper.requireNonNull(mapper, (String)"mapper is null");
        ObjectHelper.verifyPositive((int)maxConcurrency, (String)"maxConcurrency");
        ObjectHelper.verifyPositive((int)bufferSize, (String)"bufferSize");
        if (this instanceof ConstantValuePublisher) {
            Object v = ((ConstantValuePublisher)this).value();
            if (v == null) {
                return Flowable.empty();
            }
            return FlowableScalarXMap.scalarXMap(v, mapper);
        }
        return RxJavaFlowablePlugins.onAssembly(new FlowableFlatMap(this, mapper, delayErrors, maxConcurrency, bufferSize));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> flatMap(Function<? super T, ? extends Publisher<? extends R>> onNextMapper, Function<? super Throwable, ? extends Publisher<? extends R>> onErrorMapper, Callable<? extends Publisher<? extends R>> onCompleteSupplier) {
        ObjectHelper.requireNonNull(onNextMapper, (String)"onNextMapper is null");
        ObjectHelper.requireNonNull(onErrorMapper, (String)"onErrorMapper is null");
        ObjectHelper.requireNonNull(onCompleteSupplier, (String)"onCompleteSupplier is null");
        return Flowable.merge(new FlowableMapNotification<T, Publisher<? extends R>>(this, onNextMapper, onErrorMapper, onCompleteSupplier));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> flatMap(Function<? super T, ? extends Publisher<? extends R>> onNextMapper, Function<Throwable, ? extends Publisher<? extends R>> onErrorMapper, Callable<? extends Publisher<? extends R>> onCompleteSupplier, int maxConcurrency) {
        ObjectHelper.requireNonNull(onNextMapper, (String)"onNextMapper is null");
        ObjectHelper.requireNonNull(onErrorMapper, (String)"onErrorMapper is null");
        ObjectHelper.requireNonNull(onCompleteSupplier, (String)"onCompleteSupplier is null");
        return Flowable.merge(new FlowableMapNotification<T, Publisher<? extends R>>(this, onNextMapper, onErrorMapper, onCompleteSupplier), maxConcurrency);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <U, R> Flowable<R> flatMap(Function<? super T, ? extends Publisher<? extends U>> mapper, BiFunction<? super T, ? super U, ? extends R> combiner) {
        return this.flatMap(mapper, combiner, false, Flowable.bufferSize(), Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <U, R> Flowable<R> flatMap(Function<? super T, ? extends Publisher<? extends U>> mapper, BiFunction<? super T, ? super U, ? extends R> combiner, boolean delayErrors) {
        return this.flatMap(mapper, combiner, delayErrors, Flowable.bufferSize(), Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <U, R> Flowable<R> flatMap(Function<? super T, ? extends Publisher<? extends U>> mapper, BiFunction<? super T, ? super U, ? extends R> combiner, boolean delayErrors, int maxConcurrency) {
        return this.flatMap(mapper, combiner, delayErrors, maxConcurrency, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <U, R> Flowable<R> flatMap(Function<? super T, ? extends Publisher<? extends U>> mapper, BiFunction<? super T, ? super U, ? extends R> combiner, boolean delayErrors, int maxConcurrency, int bufferSize) {
        ObjectHelper.requireNonNull(mapper, (String)"mapper is null");
        ObjectHelper.requireNonNull(combiner, (String)"combiner is null");
        ObjectHelper.verifyPositive((int)maxConcurrency, (String)"maxConcurrency");
        ObjectHelper.verifyPositive((int)bufferSize, (String)"bufferSize");
        return this.flatMap(FlowableInternalHelper.flatMapWithCombiner(mapper, combiner), delayErrors, maxConcurrency, bufferSize);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <U, R> Flowable<R> flatMap(Function<? super T, ? extends Publisher<? extends U>> mapper, BiFunction<? super T, ? super U, ? extends R> combiner, int maxConcurrency) {
        return this.flatMap(mapper, combiner, false, maxConcurrency, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <U> Flowable<U> flatMapIterable(Function<? super T, ? extends Iterable<? extends U>> mapper) {
        return this.flatMapIterable(mapper, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <U> Flowable<U> flatMapIterable(Function<? super T, ? extends Iterable<? extends U>> mapper, int bufferSize) {
        ObjectHelper.requireNonNull(mapper, (String)"mapper is null");
        ObjectHelper.verifyPositive((int)bufferSize, (String)"bufferSize");
        return RxJavaFlowablePlugins.onAssembly(new FlowableFlattenIterable(this, mapper, bufferSize));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <U, V> Flowable<V> flatMapIterable(Function<? super T, ? extends Iterable<? extends U>> mapper, BiFunction<? super T, ? super U, ? extends V> resultSelector) {
        ObjectHelper.requireNonNull(mapper, (String)"mapper is null");
        ObjectHelper.requireNonNull(resultSelector, (String)"resultSelector is null");
        return this.flatMap(FlowableInternalHelper.flatMapIntoIterable(mapper), resultSelector, false, Flowable.bufferSize(), Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <U, V> Flowable<V> flatMapIterable(Function<? super T, ? extends Iterable<? extends U>> mapper, BiFunction<? super T, ? super U, ? extends V> resultSelector, int prefetch) {
        ObjectHelper.requireNonNull(mapper, (String)"mapper is null");
        ObjectHelper.requireNonNull(resultSelector, (String)"resultSelector is null");
        return this.flatMap(FlowableInternalHelper.flatMapIntoIterable(mapper), resultSelector, false, Flowable.bufferSize(), prefetch);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.NONE)
    @SchedulerSupport(value="none")
    public final Disposable forEach(Consumer<? super T> onNext) {
        return this.subscribe(onNext);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.NONE)
    @SchedulerSupport(value="none")
    public final Disposable forEachWhile(Predicate<? super T> onNext) {
        return this.forEachWhile(onNext, (Consumer<Throwable>)Functions.ON_ERROR_MISSING, Functions.EMPTY_ACTION);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.NONE)
    @SchedulerSupport(value="none")
    public final Disposable forEachWhile(Predicate<? super T> onNext, Consumer<? super Throwable> onError) {
        return this.forEachWhile(onNext, onError, Functions.EMPTY_ACTION);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.NONE)
    @SchedulerSupport(value="none")
    public final Disposable forEachWhile(Predicate<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete) {
        ObjectHelper.requireNonNull(onNext, (String)"onNext is null");
        ObjectHelper.requireNonNull(onError, (String)"onError is null");
        ObjectHelper.requireNonNull((Object)onComplete, (String)"onComplete is null");
        ForEachWhileSubscriber<? super T> s = new ForEachWhileSubscriber<T>(onNext, onError, onComplete);
        this.subscribe(s);
        return s;
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <K> Flowable<GroupedFlowable<K, T>> groupBy(Function<? super T, ? extends K> keySelector) {
        return this.groupBy(keySelector, Functions.identity(), false, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <K> Flowable<GroupedFlowable<K, T>> groupBy(Function<? super T, ? extends K> keySelector, boolean delayError) {
        return this.groupBy(keySelector, Functions.identity(), delayError, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <K, V> Flowable<GroupedFlowable<K, V>> groupBy(Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector) {
        return this.groupBy(keySelector, valueSelector, false, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <K, V> Flowable<GroupedFlowable<K, V>> groupBy(Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector, boolean delayError) {
        return this.groupBy(keySelector, valueSelector, delayError, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <K, V> Flowable<GroupedFlowable<K, V>> groupBy(Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector, boolean delayError, int bufferSize) {
        ObjectHelper.requireNonNull(keySelector, (String)"keySelector is null");
        ObjectHelper.requireNonNull(valueSelector, (String)"valueSelector is null");
        ObjectHelper.verifyPositive((int)bufferSize, (String)"bufferSize");
        return RxJavaFlowablePlugins.onAssembly(new FlowableGroupBy<T, K, V>(this, keySelector, valueSelector, bufferSize, delayError));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    public final <TRight, TLeftEnd, TRightEnd, R> Flowable<R> groupJoin(Publisher<? extends TRight> other, Function<? super T, ? extends Publisher<TLeftEnd>> leftEnd, Function<? super TRight, ? extends Publisher<TRightEnd>> rightEnd, BiFunction<? super T, ? super Flowable<TRight>, ? extends R> resultSelector) {
        ObjectHelper.requireNonNull(other, (String)"other is null");
        ObjectHelper.requireNonNull(leftEnd, (String)"leftEnd is null");
        ObjectHelper.requireNonNull(rightEnd, (String)"rightEnd is null");
        ObjectHelper.requireNonNull(resultSelector, (String)"resultSelector is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableGroupJoin(this, other, leftEnd, rightEnd, resultSelector));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<T> hide() {
        return RxJavaFlowablePlugins.onAssembly(new FlowableHide(this));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Flowable<T> ignoreElements() {
        return RxJavaFlowablePlugins.onAssembly(new FlowableIgnoreElements(this));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Flowable<Boolean> isEmpty() {
        return this.all(Functions.alwaysFalse());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    public final <TRight, TLeftEnd, TRightEnd, R> Flowable<R> join(Publisher<? extends TRight> other, Function<? super T, ? extends Publisher<TLeftEnd>> leftEnd, Function<? super TRight, ? extends Publisher<TRightEnd>> rightEnd, BiFunction<? super T, ? super TRight, ? extends R> resultSelector) {
        ObjectHelper.requireNonNull(other, (String)"other is null");
        ObjectHelper.requireNonNull(leftEnd, (String)"leftEnd is null");
        ObjectHelper.requireNonNull(rightEnd, (String)"rightEnd is null");
        ObjectHelper.requireNonNull(resultSelector, (String)"resultSelector is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableJoin(this, other, leftEnd, rightEnd, resultSelector));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Flowable<T> lastElement() {
        return RxJavaFlowablePlugins.onAssembly(new FlowableLast<Object>(this, null, false));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Flowable<T> last(T defaultItem) {
        ObjectHelper.requireNonNull(defaultItem, (String)"defaultItem");
        return RxJavaFlowablePlugins.onAssembly(new FlowableLast<T>(this, defaultItem, false));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Flowable<T> lastOrError() {
        return RxJavaFlowablePlugins.onAssembly(new FlowableLast<Object>(this, null, true));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> lift(FlowableOperator<? extends R, ? super T> lifter) {
        ObjectHelper.requireNonNull(lifter, (String)"lifter is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableLift<R, T>(this, lifter));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> map(Function<? super T, ? extends R> mapper) {
        ObjectHelper.requireNonNull(mapper, (String)"mapper is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableMap<T, R>(this, mapper));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<Notification<T>> materialize() {
        return RxJavaFlowablePlugins.onAssembly(new FlowableMaterialize(this));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> mergeWith(Publisher<? extends T> other) {
        ObjectHelper.requireNonNull(other, (String)"other is null");
        return Flowable.merge(this, other);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public final Flowable<T> observeOn(Scheduler scheduler) {
        return this.observeOn(scheduler, false, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public final Flowable<T> observeOn(Scheduler scheduler, boolean delayError) {
        return this.observeOn(scheduler, delayError, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public final Flowable<T> observeOn(Scheduler scheduler, boolean delayError, int bufferSize) {
        ObjectHelper.requireNonNull((Object)scheduler, (String)"scheduler is null");
        ObjectHelper.verifyPositive((int)bufferSize, (String)"bufferSize");
        return RxJavaFlowablePlugins.onAssembly(new FlowableObserveOn(this, scheduler, delayError, bufferSize));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final <U> Flowable<U> ofType(Class<U> clazz) {
        ObjectHelper.requireNonNull(clazz, (String)"clazz is null");
        return this.filter(Functions.isInstanceOf(clazz)).cast(clazz);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Flowable<T> onBackpressureBuffer() {
        return this.onBackpressureBuffer(Flowable.bufferSize(), false, true);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Flowable<T> onBackpressureBuffer(boolean delayError) {
        return this.onBackpressureBuffer(Flowable.bufferSize(), delayError, true);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    public final Flowable<T> onBackpressureBuffer(int capacity) {
        return this.onBackpressureBuffer(capacity, false, false);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    public final Flowable<T> onBackpressureBuffer(int capacity, boolean delayError) {
        return this.onBackpressureBuffer(capacity, delayError, false);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    public final Flowable<T> onBackpressureBuffer(int capacity, boolean delayError, boolean unbounded) {
        ObjectHelper.verifyPositive((int)capacity, (String)"bufferSize");
        return RxJavaFlowablePlugins.onAssembly(new FlowableOnBackpressureBuffer(this, capacity, unbounded, delayError, Functions.EMPTY_ACTION));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    public final Flowable<T> onBackpressureBuffer(int capacity, boolean delayError, boolean unbounded, Action onOverflow) {
        ObjectHelper.requireNonNull((Object)onOverflow, (String)"onOverflow is null");
        ObjectHelper.verifyPositive((int)capacity, (String)"capacity");
        return RxJavaFlowablePlugins.onAssembly(new FlowableOnBackpressureBuffer(this, capacity, unbounded, delayError, onOverflow));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    public final Flowable<T> onBackpressureBuffer(int capacity, Action onOverflow) {
        return this.onBackpressureBuffer(capacity, false, false, onOverflow);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    public final Flowable<T> onBackpressureBuffer(long capacity, Action onOverflow, BackpressureOverflowStrategy overflowStrategy) {
        ObjectHelper.requireNonNull((Object)((Object)overflowStrategy), (String)"strategy is null");
        ObjectHelper.verifyPositive((long)capacity, (String)"capacity");
        return RxJavaFlowablePlugins.onAssembly(new FlowableOnBackpressureBufferStrategy(this, capacity, onOverflow, overflowStrategy));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Flowable<T> onBackpressureDrop() {
        return RxJavaFlowablePlugins.onAssembly(new FlowableOnBackpressureDrop(this));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Flowable<T> onBackpressureDrop(Consumer<? super T> onDrop) {
        ObjectHelper.requireNonNull(onDrop, (String)"onDrop is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableOnBackpressureDrop<T>(this, onDrop));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Flowable<T> onBackpressureLatest() {
        return RxJavaFlowablePlugins.onAssembly(new FlowableOnBackpressureLatest(this));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> onErrorResumeNext(Function<? super Throwable, ? extends Publisher<? extends T>> resumeFunction) {
        ObjectHelper.requireNonNull(resumeFunction, (String)"resumeFunction is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableOnErrorNext(this, resumeFunction, false));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> onErrorResumeNext(Publisher<? extends T> next) {
        ObjectHelper.requireNonNull(next, (String)"next is null");
        return this.onErrorResumeNext(Functions.justFunction(next));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> onErrorReturn(Function<? super Throwable, ? extends T> valueSupplier) {
        ObjectHelper.requireNonNull(valueSupplier, (String)"valueSupplier is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableOnErrorReturn<T>(this, valueSupplier));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> onErrorReturnItem(T item) {
        ObjectHelper.requireNonNull(item, (String)"item is null");
        return this.onErrorReturn(Functions.justFunction(item));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> onExceptionResumeNext(Publisher<? extends T> next) {
        ObjectHelper.requireNonNull(next, (String)"next is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableOnErrorNext(this, Functions.justFunction(next), true));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<T> onTerminateDetach() {
        return RxJavaFlowablePlugins.onAssembly(new FlowableDetach(this));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @CheckReturnValue
    @Experimental
    public final ParallelFlowable<T> parallel() {
        return ParallelFlowable.from(this);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @CheckReturnValue
    public final ParallelFlowable<T> parallel(int parallelism) {
        ObjectHelper.verifyPositive((int)parallelism, (String)"parallelism");
        return ParallelFlowable.from(this, parallelism);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @CheckReturnValue
    @Experimental
    public final ParallelFlowable<T> parallel(int parallelism, int prefetch) {
        ObjectHelper.verifyPositive((int)parallelism, (String)"parallelism");
        ObjectHelper.verifyPositive((int)prefetch, (String)"prefetch");
        return ParallelFlowable.from(this, parallelism, prefetch);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final ConnectableFlowable<T> publish() {
        return this.publish(Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> publish(Function<? super Flowable<T>, ? extends Publisher<R>> selector) {
        return this.publish(selector, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> publish(Function<? super Flowable<T>, ? extends Publisher<? extends R>> selector, int prefetch) {
        ObjectHelper.requireNonNull(selector, (String)"selector is null");
        ObjectHelper.verifyPositive((int)prefetch, (String)"prefetch");
        return RxJavaFlowablePlugins.onAssembly(new FlowablePublishMulticast(this, selector, prefetch, false));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final ConnectableFlowable<T> publish(int bufferSize) {
        ObjectHelper.verifyPositive((int)bufferSize, (String)"bufferSize");
        return FlowablePublish.create(this, bufferSize);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> rebatchRequests(int n) {
        return this.observeOn(ImmediateThinScheduler.INSTANCE, true, n);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Flowable<T> reduce(BiFunction<T, T, T> reducer) {
        ObjectHelper.requireNonNull(reducer, (String)"reducer is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableReduce<T>(this, reducer));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> reduce(R seed, BiFunction<R, ? super T, R> reducer) {
        ObjectHelper.requireNonNull(seed, (String)"seed is null");
        ObjectHelper.requireNonNull(reducer, (String)"reducer is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableReduceSeed<T, R>(this, seed, reducer));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> reduceWith(Callable<R> seedSupplier, BiFunction<R, ? super T, R> reducer) {
        ObjectHelper.requireNonNull(seedSupplier, (String)"seedSupplier is null");
        ObjectHelper.requireNonNull(reducer, (String)"reducer is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableReduceWith<T, R>(this, seedSupplier, reducer));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> repeat() {
        return this.repeat(Long.MAX_VALUE);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> repeat(long times) {
        if (times < 0L) {
            throw new IllegalArgumentException("times >= 0 required but it was " + times);
        }
        if (times == 0L) {
            return Flowable.empty();
        }
        return RxJavaFlowablePlugins.onAssembly(new FlowableRepeat(this, times));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> repeatUntil(BooleanSupplier stop) {
        ObjectHelper.requireNonNull((Object)stop, (String)"stop is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableRepeatUntil(this, stop));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> repeatWhen(Function<? super Flowable<Object>, ? extends Publisher<?>> handler) {
        ObjectHelper.requireNonNull(handler, (String)"handler is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableRepeatWhen(this, handler));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final ConnectableFlowable<T> replay() {
        return FlowableReplay.createFrom(this);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> replay(Function<? super Flowable<T>, ? extends Publisher<R>> selector) {
        ObjectHelper.requireNonNull(selector, (String)"selector is null");
        return FlowableReplay.multicastSelector(FlowableInternalHelper.replayCallable(this), selector);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> replay(Function<? super Flowable<T>, ? extends Publisher<R>> selector, int bufferSize) {
        ObjectHelper.requireNonNull(selector, (String)"selector is null");
        ObjectHelper.verifyPositive((int)bufferSize, (String)"bufferSize");
        return FlowableReplay.multicastSelector(FlowableInternalHelper.replayCallable(this, bufferSize), selector);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="io.reactivex:computation")
    public final <R> Flowable<R> replay(Function<? super Flowable<T>, ? extends Publisher<R>> selector, int bufferSize, long time, TimeUnit unit) {
        return this.replay(selector, bufferSize, time, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public final <R> Flowable<R> replay(Function<? super Flowable<T>, ? extends Publisher<R>> selector, int bufferSize, long time, TimeUnit unit, Scheduler scheduler) {
        ObjectHelper.requireNonNull(selector, (String)"selector is null");
        ObjectHelper.requireNonNull((Object)((Object)unit), (String)"unit is null");
        ObjectHelper.verifyPositive((int)bufferSize, (String)"bufferSize");
        ObjectHelper.requireNonNull((Object)scheduler, (String)"scheduler is null");
        return FlowableReplay.multicastSelector(FlowableInternalHelper.replayCallable(this, bufferSize, time, unit, scheduler), selector);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public final <R> Flowable<R> replay(Function<? super Flowable<T>, ? extends Publisher<R>> selector, int bufferSize, Scheduler scheduler) {
        ObjectHelper.requireNonNull(selector, (String)"selector is null");
        ObjectHelper.requireNonNull((Object)scheduler, (String)"scheduler is null");
        ObjectHelper.verifyPositive((int)bufferSize, (String)"bufferSize");
        return FlowableReplay.multicastSelector(FlowableInternalHelper.replayCallable(this, bufferSize), FlowableInternalHelper.replayFunction(selector, scheduler));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="io.reactivex:computation")
    public final <R> Flowable<R> replay(Function<? super Flowable<T>, ? extends Publisher<R>> selector, long time, TimeUnit unit) {
        return this.replay(selector, time, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public final <R> Flowable<R> replay(Function<? super Flowable<T>, ? extends Publisher<R>> selector, long time, TimeUnit unit, Scheduler scheduler) {
        ObjectHelper.requireNonNull(selector, (String)"selector is null");
        ObjectHelper.requireNonNull((Object)((Object)unit), (String)"unit is null");
        ObjectHelper.requireNonNull((Object)scheduler, (String)"scheduler is null");
        return FlowableReplay.multicastSelector(FlowableInternalHelper.replayCallable(this, time, unit, scheduler), selector);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public final <R> Flowable<R> replay(Function<? super Flowable<T>, ? extends Publisher<R>> selector, Scheduler scheduler) {
        ObjectHelper.requireNonNull(selector, (String)"selector is null");
        ObjectHelper.requireNonNull((Object)scheduler, (String)"scheduler is null");
        return FlowableReplay.multicastSelector(FlowableInternalHelper.replayCallable(this), FlowableInternalHelper.replayFunction(selector, scheduler));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final ConnectableFlowable<T> replay(int bufferSize) {
        ObjectHelper.verifyPositive((int)bufferSize, (String)"bufferSize");
        return FlowableReplay.create(this, bufferSize);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="io.reactivex:computation")
    public final ConnectableFlowable<T> replay(int bufferSize, long time, TimeUnit unit) {
        return this.replay(bufferSize, time, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public final ConnectableFlowable<T> replay(int bufferSize, long time, TimeUnit unit, Scheduler scheduler) {
        ObjectHelper.verifyPositive((int)bufferSize, (String)"bufferSize");
        ObjectHelper.requireNonNull((Object)((Object)unit), (String)"unit is null");
        ObjectHelper.requireNonNull((Object)scheduler, (String)"scheduler is null");
        ObjectHelper.verifyPositive((int)bufferSize, (String)"bufferSize");
        return FlowableReplay.create(this, time, unit, scheduler, bufferSize);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public final ConnectableFlowable<T> replay(int bufferSize, Scheduler scheduler) {
        ObjectHelper.requireNonNull((Object)scheduler, (String)"scheduler is null");
        return FlowableReplay.observeOn(this.replay(bufferSize), scheduler);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="io.reactivex:computation")
    public final ConnectableFlowable<T> replay(long time, TimeUnit unit) {
        return this.replay(time, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public final ConnectableFlowable<T> replay(long time, TimeUnit unit, Scheduler scheduler) {
        ObjectHelper.requireNonNull((Object)((Object)unit), (String)"unit is null");
        ObjectHelper.requireNonNull((Object)scheduler, (String)"scheduler is null");
        return FlowableReplay.create(this, time, unit, scheduler);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public final ConnectableFlowable<T> replay(Scheduler scheduler) {
        ObjectHelper.requireNonNull((Object)scheduler, (String)"scheduler is null");
        return FlowableReplay.observeOn(this.replay(), scheduler);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> retry() {
        return this.retry(Long.MAX_VALUE, (Predicate<Throwable>)Functions.alwaysTrue());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> retry(BiPredicate<? super Integer, ? super Throwable> predicate) {
        ObjectHelper.requireNonNull(predicate, (String)"predicate is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableRetryBiPredicate(this, predicate));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> retry(long count) {
        return this.retry(count, (Predicate<Throwable>)Functions.alwaysTrue());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> retry(long times, Predicate<? super Throwable> predicate) {
        if (times < 0L) {
            throw new IllegalArgumentException("times >= 0 required but it was " + times);
        }
        ObjectHelper.requireNonNull(predicate, (String)"predicate is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableRetryPredicate(this, times, predicate));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> retry(Predicate<? super Throwable> predicate) {
        return this.retry(Long.MAX_VALUE, predicate);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> retryUntil(BooleanSupplier stop) {
        ObjectHelper.requireNonNull((Object)stop, (String)"stop is null");
        return this.retry(Long.MAX_VALUE, (Predicate<Throwable>)Functions.predicateReverseFor((BooleanSupplier)stop));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> retryWhen(Function<? super Flowable<Throwable>, ? extends Publisher<?>> handler) {
        ObjectHelper.requireNonNull(handler, (String)"handler is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableRetryWhen(this, handler));
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final void safeSubscribe(Subscriber<? super T> s) {
        ObjectHelper.requireNonNull(s, (String)"s is null");
        if (s instanceof SafeSubscriber) {
            this.subscribe((SafeSubscriber)s);
        } else {
            this.subscribe(new SafeSubscriber<T>(s));
        }
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    public final Flowable<T> sample(long period, TimeUnit unit) {
        return this.sample(period, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    @Experimental
    public final Flowable<T> sample(long period, TimeUnit unit, boolean emitLast) {
        return this.sample(period, unit, Schedulers.computation(), emitLast);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    public final Flowable<T> sample(long period, TimeUnit unit, Scheduler scheduler) {
        ObjectHelper.requireNonNull((Object)((Object)unit), (String)"unit is null");
        ObjectHelper.requireNonNull((Object)scheduler, (String)"scheduler is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableSampleTimed(this, period, unit, scheduler, false));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    @Experimental
    public final Flowable<T> sample(long period, TimeUnit unit, Scheduler scheduler, boolean emitLast) {
        ObjectHelper.requireNonNull((Object)((Object)unit), (String)"unit is null");
        ObjectHelper.requireNonNull((Object)scheduler, (String)"scheduler is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableSampleTimed(this, period, unit, scheduler, emitLast));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    public final <U> Flowable<T> sample(Publisher<U> sampler) {
        ObjectHelper.requireNonNull(sampler, (String)"sampler is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableSamplePublisher(this, sampler, false));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    @Experimental
    public final <U> Flowable<T> sample(Publisher<U> sampler, boolean emitLast) {
        ObjectHelper.requireNonNull(sampler, (String)"sampler is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableSamplePublisher(this, sampler, emitLast));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> scan(BiFunction<T, T, T> accumulator) {
        ObjectHelper.requireNonNull(accumulator, (String)"accumulator is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableScan<T>(this, accumulator));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> scan(R initialValue, BiFunction<R, ? super T, R> accumulator) {
        ObjectHelper.requireNonNull(initialValue, (String)"seed is null");
        return this.scanWith(Functions.justCallable(initialValue), accumulator);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> scanWith(Callable<R> seedSupplier, BiFunction<R, ? super T, R> accumulator) {
        ObjectHelper.requireNonNull(seedSupplier, (String)"seedSupplier is null");
        ObjectHelper.requireNonNull(accumulator, (String)"accumulator is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableScanSeed<T, R>(this, seedSupplier, accumulator));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<T> serialize() {
        return RxJavaFlowablePlugins.onAssembly(new FlowableSerialized(this));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> share() {
        return this.publish().refCount();
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Flowable<T> singleElement() {
        return RxJavaFlowablePlugins.onAssembly(new FlowableSingle<Object>(this, null, false));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Flowable<T> single(T defaultItem) {
        ObjectHelper.requireNonNull(defaultItem, (String)"defaultItem is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableSingle<T>(this, defaultItem, false));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Flowable<T> singleOrError() {
        return RxJavaFlowablePlugins.onAssembly(new FlowableSingle<Object>(this, null, true));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> skip(long count) {
        if (count <= 0L) {
            return RxJavaFlowablePlugins.onAssembly(this);
        }
        return RxJavaFlowablePlugins.onAssembly(new FlowableSkip(this, count));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> skip(long time, TimeUnit unit) {
        return this.skipUntil(Flowable.timer(time, unit));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public final Flowable<T> skip(long time, TimeUnit unit, Scheduler scheduler) {
        return this.skipUntil(Flowable.timer(time, unit, scheduler));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> skipLast(int count) {
        if (count < 0) {
            throw new IndexOutOfBoundsException("count >= 0 required but it was " + count);
        }
        if (count == 0) {
            return RxJavaFlowablePlugins.onAssembly(this);
        }
        return RxJavaFlowablePlugins.onAssembly(new FlowableSkipLast(this, count));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Flowable<T> skipLast(long time, TimeUnit unit) {
        return this.skipLast(time, unit, Schedulers.computation(), false, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Flowable<T> skipLast(long time, TimeUnit unit, boolean delayError) {
        return this.skipLast(time, unit, Schedulers.computation(), delayError, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="custom")
    public final Flowable<T> skipLast(long time, TimeUnit unit, Scheduler scheduler) {
        return this.skipLast(time, unit, scheduler, false, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="custom")
    public final Flowable<T> skipLast(long time, TimeUnit unit, Scheduler scheduler, boolean delayError) {
        return this.skipLast(time, unit, scheduler, delayError, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="custom")
    public final Flowable<T> skipLast(long time, TimeUnit unit, Scheduler scheduler, boolean delayError, int bufferSize) {
        ObjectHelper.requireNonNull((Object)((Object)unit), (String)"unit is null");
        ObjectHelper.requireNonNull((Object)scheduler, (String)"scheduler is null");
        ObjectHelper.verifyPositive((int)bufferSize, (String)"bufferSize");
        int s = bufferSize << 1;
        return RxJavaFlowablePlugins.onAssembly(new FlowableSkipLastTimed(this, time, unit, scheduler, s, delayError));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <U> Flowable<T> skipUntil(Publisher<U> other) {
        ObjectHelper.requireNonNull(other, (String)"other is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableSkipUntil(this, other));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> skipWhile(Predicate<? super T> predicate) {
        ObjectHelper.requireNonNull(predicate, (String)"predicate is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableSkipWhile<T>(this, predicate));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> sorted() {
        return this.toList().map(Functions.listSorter((Comparator)Functions.naturalComparator())).flatMapIterable(Functions.identity());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> sorted(Comparator<? super T> sortFunction) {
        ObjectHelper.requireNonNull(sortFunction, (String)"sortFunction");
        return this.toList().map(Functions.listSorter(sortFunction)).flatMapIterable(Functions.identity());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> startWith(Iterable<? extends T> items) {
        return Flowable.concatArray(Flowable.fromIterable(items), this);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> startWith(Publisher<? extends T> other) {
        ObjectHelper.requireNonNull(other, (String)"other is null");
        return Flowable.concatArray(other, this);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> startWith(T value) {
        ObjectHelper.requireNonNull(value, (String)"item is null");
        return Flowable.concatArray(Flowable.just(value), this);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> startWithArray(T ... items) {
        Flowable<T> fromArray = Flowable.fromArray(items);
        if (fromArray == Flowable.empty()) {
            return RxJavaFlowablePlugins.onAssembly(this);
        }
        return Flowable.concatArray(fromArray, this);
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @CheckReturnValue
    @Deprecated
    @Experimental
    public final Flowable<T> strict() {
        return this;
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Disposable subscribe() {
        return this.subscribe(Functions.emptyConsumer(), (Consumer<Throwable>)Functions.ON_ERROR_MISSING, Functions.EMPTY_ACTION, FlowableInternalHelper.RequestMax.INSTANCE);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Disposable subscribe(Consumer<? super T> onNext) {
        return this.subscribe(onNext, (Consumer<Throwable>)Functions.ON_ERROR_MISSING, Functions.EMPTY_ACTION, FlowableInternalHelper.RequestMax.INSTANCE);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Disposable subscribe(Consumer<? super T> onNext, Consumer<? super Throwable> onError) {
        return this.subscribe(onNext, onError, Functions.EMPTY_ACTION, FlowableInternalHelper.RequestMax.INSTANCE);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Disposable subscribe(Consumer<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete) {
        return this.subscribe(onNext, onError, onComplete, FlowableInternalHelper.RequestMax.INSTANCE);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    public final Disposable subscribe(Consumer<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete, Consumer<? super Subscription> onSubscribe) {
        ObjectHelper.requireNonNull(onNext, (String)"onNext is null");
        ObjectHelper.requireNonNull(onError, (String)"onError is null");
        ObjectHelper.requireNonNull((Object)onComplete, (String)"onComplete is null");
        ObjectHelper.requireNonNull(onSubscribe, (String)"onSubscribe is null");
        LambdaSubscriber<? super T> ls = new LambdaSubscriber<T>(onNext, onError, onComplete, onSubscribe);
        this.subscribe(ls);
        return ls;
    }

    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    public final void subscribe(Subscriber<? super T> s) {
        if (s instanceof RelaxedSubscriber) {
            this.subscribe((RelaxedSubscriber)s);
        } else {
            ObjectHelper.requireNonNull(s, (String)"s is null");
            this.subscribe(new StrictSubscriber<T>(s));
        }
    }

    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    @Experimental
    public final void subscribe(RelaxedSubscriber<? super T> s) {
        ObjectHelper.requireNonNull(s, (String)"s is null");
        try {
            Subscriber<? super T> z = RxJavaFlowablePlugins.onSubscribe(this, s);
            ObjectHelper.requireNonNull(z, (String)"Plugin returned null Subscriber");
            this.subscribeActual(z);
        }
        catch (NullPointerException e) {
            throw e;
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal((Throwable)e);
            RxJavaCommonPlugins.onError((Throwable)e);
            NullPointerException npe = new NullPointerException("Actually not, but can't throw other exceptions due to RS");
            npe.initCause(e);
            throw npe;
        }
    }

    protected abstract void subscribeActual(Subscriber<? super T> var1);

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    public final <E extends Subscriber<? super T>> E subscribeWith(E subscriber) {
        this.subscribe(subscriber);
        return subscriber;
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="custom")
    public final Flowable<T> subscribeOn(@NonNull Scheduler scheduler) {
        ObjectHelper.requireNonNull((Object)scheduler, (String)"scheduler is null");
        return this.subscribeOn(scheduler, !(this instanceof FlowableCreate));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="custom")
    @Experimental
    public final Flowable<T> subscribeOn(@NonNull Scheduler scheduler, boolean requestOn) {
        ObjectHelper.requireNonNull((Object)scheduler, (String)"scheduler is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableSubscribeOn(this, scheduler, requestOn));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> switchIfEmpty(Publisher<? extends T> other) {
        ObjectHelper.requireNonNull(other, (String)"other is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableSwitchIfEmpty<T>(this, other));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> switchMap(Function<? super T, ? extends Publisher<? extends R>> mapper) {
        return this.switchMap(mapper, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> switchMap(Function<? super T, ? extends Publisher<? extends R>> mapper, int bufferSize) {
        return this.switchMap0(mapper, bufferSize, false);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> switchMapDelayError(Function<? super T, ? extends Publisher<? extends R>> mapper) {
        return this.switchMapDelayError(mapper, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> switchMapDelayError(Function<? super T, ? extends Publisher<? extends R>> mapper, int bufferSize) {
        return this.switchMap0(mapper, bufferSize, true);
    }

    <R> Flowable<R> switchMap0(Function<? super T, ? extends Publisher<? extends R>> mapper, int bufferSize, boolean delayError) {
        ObjectHelper.requireNonNull(mapper, (String)"mapper is null");
        ObjectHelper.verifyPositive((int)bufferSize, (String)"bufferSize");
        if (this instanceof ConstantValuePublisher) {
            Object v = ((ConstantValuePublisher)this).value();
            if (v == null) {
                return Flowable.empty();
            }
            return FlowableScalarXMap.scalarXMap(v, mapper);
        }
        return RxJavaFlowablePlugins.onAssembly(new FlowableSwitchMap(this, mapper, bufferSize, delayError));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    public final Flowable<T> take(long count) {
        if (count < 0L) {
            throw new IllegalArgumentException("count >= 0 required but it was " + count);
        }
        return RxJavaFlowablePlugins.onAssembly(new FlowableTake(this, count));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="io.reactivex:computation")
    public final Flowable<T> take(long time, TimeUnit unit) {
        return this.takeUntil(Flowable.timer(time, unit));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="custom")
    public final Flowable<T> take(long time, TimeUnit unit, Scheduler scheduler) {
        return this.takeUntil(Flowable.timer(time, unit, scheduler));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> takeLast(int count) {
        if (count < 0) {
            throw new IndexOutOfBoundsException("count >= 0 required but it was " + count);
        }
        if (count == 0) {
            return RxJavaFlowablePlugins.onAssembly(new FlowableIgnoreElements(this));
        }
        if (count == 1) {
            return RxJavaFlowablePlugins.onAssembly(new FlowableTakeLastOne(this));
        }
        return RxJavaFlowablePlugins.onAssembly(new FlowableTakeLast(this, count));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> takeLast(long count, long time, TimeUnit unit) {
        return this.takeLast(count, time, unit, Schedulers.computation(), false, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public final Flowable<T> takeLast(long count, long time, TimeUnit unit, Scheduler scheduler) {
        return this.takeLast(count, time, unit, scheduler, false, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public final Flowable<T> takeLast(long count, long time, TimeUnit unit, Scheduler scheduler, boolean delayError, int bufferSize) {
        ObjectHelper.requireNonNull((Object)((Object)unit), (String)"unit is null");
        ObjectHelper.requireNonNull((Object)scheduler, (String)"scheduler is null");
        ObjectHelper.verifyPositive((int)bufferSize, (String)"bufferSize");
        if (count < 0L) {
            throw new IndexOutOfBoundsException("count >= 0 required but it was " + count);
        }
        return RxJavaFlowablePlugins.onAssembly(new FlowableTakeLastTimed(this, count, time, unit, scheduler, bufferSize, delayError));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="io.reactivex:computation")
    public final Flowable<T> takeLast(long time, TimeUnit unit) {
        return this.takeLast(time, unit, Schedulers.computation(), false, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="io.reactivex:computation")
    public final Flowable<T> takeLast(long time, TimeUnit unit, boolean delayError) {
        return this.takeLast(time, unit, Schedulers.computation(), delayError, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public final Flowable<T> takeLast(long time, TimeUnit unit, Scheduler scheduler) {
        return this.takeLast(time, unit, scheduler, false, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public final Flowable<T> takeLast(long time, TimeUnit unit, Scheduler scheduler, boolean delayError) {
        return this.takeLast(time, unit, scheduler, delayError, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public final Flowable<T> takeLast(long time, TimeUnit unit, Scheduler scheduler, boolean delayError, int bufferSize) {
        return this.takeLast(Long.MAX_VALUE, time, unit, scheduler, delayError, bufferSize);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<T> takeUntil(Predicate<? super T> stopPredicate) {
        ObjectHelper.requireNonNull(stopPredicate, (String)"stopPredicate is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableTakeUntilPredicate<T>(this, stopPredicate));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final <U> Flowable<T> takeUntil(Publisher<U> other) {
        ObjectHelper.requireNonNull(other, (String)"other is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableTakeUntil(this, other));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<T> takeWhile(Predicate<? super T> predicate) {
        ObjectHelper.requireNonNull(predicate, (String)"predicate is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableTakeWhile<T>(this, predicate));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    public final Flowable<T> throttleFirst(long windowDuration, TimeUnit unit) {
        return this.throttleFirst(windowDuration, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    public final Flowable<T> throttleFirst(long skipDuration, TimeUnit unit, Scheduler scheduler) {
        ObjectHelper.requireNonNull((Object)((Object)unit), (String)"unit is null");
        ObjectHelper.requireNonNull((Object)scheduler, (String)"scheduler is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableThrottleFirstTimed(this, skipDuration, unit, scheduler));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    public final Flowable<T> throttleLast(long intervalDuration, TimeUnit unit) {
        return this.sample(intervalDuration, unit);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    public final Flowable<T> throttleLast(long intervalDuration, TimeUnit unit, Scheduler scheduler) {
        return this.sample(intervalDuration, unit, scheduler);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    public final Flowable<T> throttleWithTimeout(long timeout, TimeUnit unit) {
        return this.debounce(timeout, unit);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    public final Flowable<T> throttleWithTimeout(long timeout, TimeUnit unit, Scheduler scheduler) {
        return this.debounce(timeout, unit, scheduler);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<Timed<T>> timeInterval() {
        return this.timeInterval(TimeUnit.MILLISECONDS, Schedulers.computation());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<Timed<T>> timeInterval(Scheduler scheduler) {
        return this.timeInterval(TimeUnit.MILLISECONDS, scheduler);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<Timed<T>> timeInterval(TimeUnit unit) {
        return this.timeInterval(unit, Schedulers.computation());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<Timed<T>> timeInterval(TimeUnit unit, Scheduler scheduler) {
        ObjectHelper.requireNonNull((Object)((Object)unit), (String)"unit is null");
        ObjectHelper.requireNonNull((Object)scheduler, (String)"scheduler is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableTimeInterval(this, unit, scheduler));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final <V> Flowable<T> timeout(Function<? super T, ? extends Publisher<V>> itemTimeoutIndicator) {
        return this.timeout0(null, itemTimeoutIndicator, null);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <V> Flowable<T> timeout(Function<? super T, ? extends Publisher<V>> itemTimeoutIndicator, Flowable<? extends T> other) {
        ObjectHelper.requireNonNull(other, (String)"other is null");
        return this.timeout0(null, itemTimeoutIndicator, other);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="io.reactivex:computation")
    public final Flowable<T> timeout(long timeout, TimeUnit timeUnit) {
        return this.timeout0(timeout, timeUnit, null, Schedulers.computation());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="io.reactivex:computation")
    public final Flowable<T> timeout(long timeout, TimeUnit timeUnit, Publisher<? extends T> other) {
        ObjectHelper.requireNonNull(other, (String)"other is null");
        return this.timeout0(timeout, timeUnit, other, Schedulers.computation());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public final Flowable<T> timeout(long timeout, TimeUnit timeUnit, Scheduler scheduler, Publisher<? extends T> other) {
        ObjectHelper.requireNonNull(other, (String)"other is null");
        return this.timeout0(timeout, timeUnit, other, scheduler);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="custom")
    public final Flowable<T> timeout(long timeout, TimeUnit timeUnit, Scheduler scheduler) {
        return this.timeout0(timeout, timeUnit, null, scheduler);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final <U, V> Flowable<T> timeout(Publisher<U> firstTimeoutIndicator, Function<? super T, ? extends Publisher<V>> itemTimeoutIndicator) {
        ObjectHelper.requireNonNull(firstTimeoutIndicator, (String)"firstTimeoutIndicator is null");
        return this.timeout0(firstTimeoutIndicator, itemTimeoutIndicator, null);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <U, V> Flowable<T> timeout(Publisher<U> firstTimeoutIndicator, Function<? super T, ? extends Publisher<V>> itemTimeoutIndicator, Publisher<? extends T> other) {
        ObjectHelper.requireNonNull(firstTimeoutIndicator, (String)"firstTimeoutSelector is null");
        ObjectHelper.requireNonNull(other, (String)"other is null");
        return this.timeout0(firstTimeoutIndicator, itemTimeoutIndicator, other);
    }

    private Flowable<T> timeout0(long timeout, TimeUnit timeUnit, Publisher<? extends T> other, Scheduler scheduler) {
        ObjectHelper.requireNonNull((Object)((Object)timeUnit), (String)"timeUnit is null");
        ObjectHelper.requireNonNull((Object)scheduler, (String)"scheduler is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableTimeoutTimed<T>(this, timeout, timeUnit, scheduler, other));
    }

    private <U, V> Flowable<T> timeout0(Publisher<U> firstTimeoutIndicator, Function<? super T, ? extends Publisher<V>> itemTimeoutIndicator, Publisher<? extends T> other) {
        ObjectHelper.requireNonNull(itemTimeoutIndicator, (String)"itemTimeoutIndicator is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableTimeout(this, firstTimeoutIndicator, itemTimeoutIndicator, other));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<Timed<T>> timestamp() {
        return this.timestamp(TimeUnit.MILLISECONDS, Schedulers.computation());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<Timed<T>> timestamp(Scheduler scheduler) {
        return this.timestamp(TimeUnit.MILLISECONDS, scheduler);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<Timed<T>> timestamp(TimeUnit unit) {
        return this.timestamp(unit, Schedulers.computation());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<Timed<T>> timestamp(TimeUnit unit, Scheduler scheduler) {
        ObjectHelper.requireNonNull((Object)((Object)unit), (String)"unit is null");
        ObjectHelper.requireNonNull((Object)scheduler, (String)"scheduler is null");
        return this.map(Functions.timestampWith((TimeUnit)unit, (Scheduler)scheduler));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    public final <R> R to(Function<? super Flowable<T>, R> converter) {
        try {
            return (R)((Function)ObjectHelper.requireNonNull(converter, (String)"converter is null")).apply((Object)this);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal((Throwable)ex);
            throw ExceptionHelper.wrapOrThrow((Throwable)ex);
        }
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Flowable<List<T>> toList() {
        return RxJavaFlowablePlugins.onAssembly(new FlowableToList(this, ArrayListSupplier.asCallable()));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Flowable<List<T>> toList(int capacityHint) {
        ObjectHelper.verifyPositive((int)capacityHint, (String)"capacityHint");
        return RxJavaFlowablePlugins.onAssembly(new FlowableToList(this, Functions.createArrayList((int)capacityHint)));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final <U extends Collection<? super T>> Flowable<U> toList(Callable<U> collectionSupplier) {
        ObjectHelper.requireNonNull(collectionSupplier, (String)"collectionSupplier is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableToList(this, collectionSupplier));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final <K> Flowable<Map<K, T>> toMap(Function<? super T, ? extends K> keySelector) {
        ObjectHelper.requireNonNull(keySelector, (String)"keySelector is null");
        return this.collect(HashMapSupplier.asCallable(), Functions.toMapKeySelector(keySelector));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final <K, V> Flowable<Map<K, V>> toMap(Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector) {
        ObjectHelper.requireNonNull(keySelector, (String)"keySelector is null");
        ObjectHelper.requireNonNull(valueSelector, (String)"valueSelector is null");
        return this.collect(HashMapSupplier.asCallable(), Functions.toMapKeyValueSelector(keySelector, valueSelector));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final <K, V> Flowable<Map<K, V>> toMap(Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector, Callable<? extends Map<K, V>> mapSupplier) {
        ObjectHelper.requireNonNull(keySelector, (String)"keySelector is null");
        ObjectHelper.requireNonNull(valueSelector, (String)"valueSelector is null");
        return this.collect(mapSupplier, Functions.toMapKeyValueSelector(keySelector, valueSelector));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final <K> Flowable<Map<K, Collection<T>>> toMultimap(Function<? super T, ? extends K> keySelector) {
        Function valueSelector = Functions.identity();
        Callable mapSupplier = HashMapSupplier.asCallable();
        Function collectionFactory = ArrayListSupplier.asFunction();
        return this.toMultimap(keySelector, valueSelector, mapSupplier, collectionFactory);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final <K, V> Flowable<Map<K, Collection<V>>> toMultimap(Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector) {
        Callable mapSupplier = HashMapSupplier.asCallable();
        Function collectionFactory = ArrayListSupplier.asFunction();
        return this.toMultimap(keySelector, valueSelector, mapSupplier, collectionFactory);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final <K, V> Flowable<Map<K, Collection<V>>> toMultimap(Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector, Callable<? extends Map<K, Collection<V>>> mapSupplier, Function<? super K, ? extends Collection<? super V>> collectionFactory) {
        ObjectHelper.requireNonNull(keySelector, (String)"keySelector is null");
        ObjectHelper.requireNonNull(valueSelector, (String)"valueSelector is null");
        ObjectHelper.requireNonNull(mapSupplier, (String)"mapSupplier is null");
        ObjectHelper.requireNonNull(collectionFactory, (String)"collectionFactory is null");
        return this.collect(mapSupplier, Functions.toMultimapKeyValueSelector(keySelector, valueSelector, collectionFactory));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final <K, V> Flowable<Map<K, Collection<V>>> toMultimap(Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector, Callable<Map<K, Collection<V>>> mapSupplier) {
        return this.toMultimap(keySelector, valueSelector, mapSupplier, ArrayListSupplier.asFunction());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Flowable<List<T>> toSortedList() {
        return this.toSortedList(Functions.naturalComparator());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Flowable<List<T>> toSortedList(Comparator<? super T> comparator) {
        ObjectHelper.requireNonNull(comparator, (String)"comparator is null");
        return this.toList().map(Functions.listSorter(comparator));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Flowable<List<T>> toSortedList(Comparator<? super T> comparator, int capacityHint) {
        ObjectHelper.requireNonNull(comparator, (String)"comparator is null");
        return this.toList(capacityHint).map(Functions.listSorter(comparator));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Flowable<List<T>> toSortedList(int capacityHint) {
        return this.toSortedList(Functions.naturalComparator(), capacityHint);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="custom")
    public final Flowable<T> unsubscribeOn(Scheduler scheduler) {
        ObjectHelper.requireNonNull((Object)scheduler, (String)"scheduler is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableUnsubscribeOn(this, scheduler));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<Flowable<T>> window(long count) {
        return this.window(count, count, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<Flowable<T>> window(long count, long skip) {
        return this.window(count, skip, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<Flowable<T>> window(long count, long skip, int bufferSize) {
        ObjectHelper.verifyPositive((long)skip, (String)"skip");
        ObjectHelper.verifyPositive((long)count, (String)"count");
        ObjectHelper.verifyPositive((int)bufferSize, (String)"bufferSize");
        return RxJavaFlowablePlugins.onAssembly(new FlowableWindow(this, count, skip, bufferSize));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    public final Flowable<Flowable<T>> window(long timespan, long timeskip, TimeUnit unit) {
        return this.window(timespan, timeskip, unit, Schedulers.computation(), Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    public final Flowable<Flowable<T>> window(long timespan, long timeskip, TimeUnit unit, Scheduler scheduler) {
        return this.window(timespan, timeskip, unit, scheduler, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    public final Flowable<Flowable<T>> window(long timespan, long timeskip, TimeUnit unit, Scheduler scheduler, int bufferSize) {
        ObjectHelper.verifyPositive((int)bufferSize, (String)"bufferSize");
        ObjectHelper.verifyPositive((long)timespan, (String)"timespan");
        ObjectHelper.verifyPositive((long)timeskip, (String)"timeskip");
        ObjectHelper.requireNonNull((Object)scheduler, (String)"scheduler is null");
        ObjectHelper.requireNonNull((Object)((Object)unit), (String)"unit is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableWindowTimed(this, timespan, timeskip, unit, scheduler, Long.MAX_VALUE, bufferSize, false));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    public final Flowable<Flowable<T>> window(long timespan, TimeUnit unit) {
        return this.window(timespan, unit, Schedulers.computation(), Long.MAX_VALUE, false);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    public final Flowable<Flowable<T>> window(long timespan, TimeUnit unit, long count) {
        return this.window(timespan, unit, Schedulers.computation(), count, false);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    public final Flowable<Flowable<T>> window(long timespan, TimeUnit unit, long count, boolean restart) {
        return this.window(timespan, unit, Schedulers.computation(), count, restart);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    public final Flowable<Flowable<T>> window(long timespan, TimeUnit unit, Scheduler scheduler) {
        return this.window(timespan, unit, scheduler, Long.MAX_VALUE, false);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    public final Flowable<Flowable<T>> window(long timespan, TimeUnit unit, Scheduler scheduler, long count) {
        return this.window(timespan, unit, scheduler, count, false);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    public final Flowable<Flowable<T>> window(long timespan, TimeUnit unit, Scheduler scheduler, long count, boolean restart) {
        return this.window(timespan, unit, scheduler, count, restart, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    public final Flowable<Flowable<T>> window(long timespan, TimeUnit unit, Scheduler scheduler, long count, boolean restart, int bufferSize) {
        ObjectHelper.verifyPositive((int)bufferSize, (String)"bufferSize");
        ObjectHelper.requireNonNull((Object)scheduler, (String)"scheduler is null");
        ObjectHelper.requireNonNull((Object)((Object)unit), (String)"unit is null");
        ObjectHelper.verifyPositive((long)count, (String)"count");
        return RxJavaFlowablePlugins.onAssembly(new FlowableWindowTimed(this, timespan, timespan, unit, scheduler, count, bufferSize, restart));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    public final <B> Flowable<Flowable<T>> window(Publisher<B> boundaryIndicator) {
        return this.window(boundaryIndicator, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    public final <B> Flowable<Flowable<T>> window(Publisher<B> boundaryIndicator, int bufferSize) {
        ObjectHelper.requireNonNull(boundaryIndicator, (String)"boundaryIndicator is null");
        ObjectHelper.verifyPositive((int)bufferSize, (String)"bufferSize");
        return RxJavaFlowablePlugins.onAssembly(new FlowableWindowBoundary(this, boundaryIndicator, bufferSize));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    public final <U, V> Flowable<Flowable<T>> window(Publisher<U> openingIndicator, Function<? super U, ? extends Publisher<V>> closingIndicator) {
        return this.window(openingIndicator, closingIndicator, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    public final <U, V> Flowable<Flowable<T>> window(Publisher<U> openingIndicator, Function<? super U, ? extends Publisher<V>> closingIndicator, int bufferSize) {
        ObjectHelper.requireNonNull(openingIndicator, (String)"openingIndicator is null");
        ObjectHelper.requireNonNull(closingIndicator, (String)"closingIndicator is null");
        ObjectHelper.verifyPositive((int)bufferSize, (String)"bufferSize");
        return RxJavaFlowablePlugins.onAssembly(new FlowableWindowBoundarySelector(this, openingIndicator, closingIndicator, bufferSize));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    public final <B> Flowable<Flowable<T>> window(Callable<? extends Publisher<B>> boundaryIndicatorSupplier) {
        return this.window(boundaryIndicatorSupplier, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    public final <B> Flowable<Flowable<T>> window(Callable<? extends Publisher<B>> boundaryIndicatorSupplier, int bufferSize) {
        ObjectHelper.requireNonNull(boundaryIndicatorSupplier, (String)"boundaryIndicatorSupplier is null");
        ObjectHelper.verifyPositive((int)bufferSize, (String)"bufferSize");
        return RxJavaFlowablePlugins.onAssembly(new FlowableWindowBoundarySupplier(this, boundaryIndicatorSupplier, bufferSize));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final <U, R> Flowable<R> withLatestFrom(Publisher<? extends U> other, BiFunction<? super T, ? super U, ? extends R> combiner) {
        ObjectHelper.requireNonNull(other, (String)"other is null");
        ObjectHelper.requireNonNull(combiner, (String)"combiner is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableWithLatestFrom<T, U, R>(this, combiner, other));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final <T1, T2, R> Flowable<R> withLatestFrom(Publisher<T1> source1, Publisher<T2> source2, Function3<? super T, ? super T1, ? super T2, R> combiner) {
        ObjectHelper.requireNonNull(source1, (String)"source1 is null");
        ObjectHelper.requireNonNull(source2, (String)"source2 is null");
        Function f = Functions.toFunction(combiner);
        return this.withLatestFrom(new Publisher[]{source1, source2}, f);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final <T1, T2, T3, R> Flowable<R> withLatestFrom(Publisher<T1> source1, Publisher<T2> source2, Publisher<T3> source3, Function4<? super T, ? super T1, ? super T2, ? super T3, R> combiner) {
        ObjectHelper.requireNonNull(source1, (String)"source1 is null");
        ObjectHelper.requireNonNull(source2, (String)"source2 is null");
        ObjectHelper.requireNonNull(source3, (String)"source3 is null");
        Function f = Functions.toFunction(combiner);
        return this.withLatestFrom(new Publisher[]{source1, source2, source3}, f);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final <T1, T2, T3, T4, R> Flowable<R> withLatestFrom(Publisher<T1> source1, Publisher<T2> source2, Publisher<T3> source3, Publisher<T4> source4, Function5<? super T, ? super T1, ? super T2, ? super T3, ? super T4, R> combiner) {
        ObjectHelper.requireNonNull(source1, (String)"source1 is null");
        ObjectHelper.requireNonNull(source2, (String)"source2 is null");
        ObjectHelper.requireNonNull(source3, (String)"source3 is null");
        ObjectHelper.requireNonNull(source4, (String)"source4 is null");
        Function f = Functions.toFunction(combiner);
        return this.withLatestFrom(new Publisher[]{source1, source2, source3, source4}, f);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> withLatestFrom(Publisher<?>[] others, Function<? super Object[], R> combiner) {
        ObjectHelper.requireNonNull(others, (String)"others is null");
        ObjectHelper.requireNonNull(combiner, (String)"combiner is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableWithLatestFromMany(this, others, combiner));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> withLatestFrom(Iterable<? extends Publisher<?>> others, Function<? super Object[], R> combiner) {
        ObjectHelper.requireNonNull(others, (String)"others is null");
        ObjectHelper.requireNonNull(combiner, (String)"combiner is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableWithLatestFromMany(this, others, combiner));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <U, R> Flowable<R> zipWith(Iterable<U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        ObjectHelper.requireNonNull(other, (String)"other is null");
        ObjectHelper.requireNonNull(zipper, (String)"zipper is null");
        return RxJavaFlowablePlugins.onAssembly(new FlowableZipIterable<T, U, R>(this, other, zipper));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <U, R> Flowable<R> zipWith(Publisher<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        ObjectHelper.requireNonNull(other, (String)"other is null");
        return Flowable.zip(this, other, zipper);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <U, R> Flowable<R> zipWith(Publisher<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper, boolean delayError) {
        return Flowable.zip(this, other, zipper, delayError);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <U, R> Flowable<R> zipWith(Publisher<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper, boolean delayError, int bufferSize) {
        return Flowable.zip(this, other, zipper, delayError, bufferSize);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final TestSubscriber<T> test() {
        TestSubscriber ts = new TestSubscriber();
        this.subscribe(ts);
        return ts;
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final TestSubscriber<T> test(long initialRequest) {
        TestSubscriber ts = new TestSubscriber(initialRequest);
        this.subscribe(ts);
        return ts;
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final TestSubscriber<T> test(long initialRequest, boolean cancel) {
        TestSubscriber ts = new TestSubscriber(initialRequest);
        if (cancel) {
            ts.cancel();
        }
        this.subscribe(ts);
        return ts;
    }
}

