/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable;

import io.reactivex.common.ErrorMode;
import io.reactivex.common.Scheduler;
import io.reactivex.common.annotations.CheckReturnValue;
import io.reactivex.common.annotations.Experimental;
import io.reactivex.common.annotations.NonNull;
import io.reactivex.common.annotations.SchedulerSupport;
import io.reactivex.common.exceptions.Exceptions;
import io.reactivex.common.functions.Action;
import io.reactivex.common.functions.BiConsumer;
import io.reactivex.common.functions.BiFunction;
import io.reactivex.common.functions.Consumer;
import io.reactivex.common.functions.Function;
import io.reactivex.common.functions.LongConsumer;
import io.reactivex.common.functions.Predicate;
import io.reactivex.common.internal.functions.Functions;
import io.reactivex.common.internal.functions.ObjectHelper;
import io.reactivex.common.internal.utils.ExceptionHelper;
import io.reactivex.common.internal.utils.ListAddBiConsumer;
import io.reactivex.common.internal.utils.MergerBiFunction;
import io.reactivex.common.internal.utils.SorterFunction;
import io.reactivex.flowable.BackpressureKind;
import io.reactivex.flowable.BackpressureSupport;
import io.reactivex.flowable.Flowable;
import io.reactivex.flowable.ParallelFailureHandling;
import io.reactivex.flowable.ParallelTransformer;
import io.reactivex.flowable.RxJavaFlowablePlugins;
import io.reactivex.flowable.internal.operators.ParallelCollect;
import io.reactivex.flowable.internal.operators.ParallelConcatMap;
import io.reactivex.flowable.internal.operators.ParallelDoOnNextTry;
import io.reactivex.flowable.internal.operators.ParallelFilter;
import io.reactivex.flowable.internal.operators.ParallelFilterTry;
import io.reactivex.flowable.internal.operators.ParallelFlatMap;
import io.reactivex.flowable.internal.operators.ParallelFromArray;
import io.reactivex.flowable.internal.operators.ParallelFromPublisher;
import io.reactivex.flowable.internal.operators.ParallelJoin;
import io.reactivex.flowable.internal.operators.ParallelMap;
import io.reactivex.flowable.internal.operators.ParallelMapTry;
import io.reactivex.flowable.internal.operators.ParallelPeek;
import io.reactivex.flowable.internal.operators.ParallelReduce;
import io.reactivex.flowable.internal.operators.ParallelReduceFull;
import io.reactivex.flowable.internal.operators.ParallelRunOn;
import io.reactivex.flowable.internal.operators.ParallelSortedJoin;
import io.reactivex.flowable.internal.subscriptions.EmptySubscription;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public abstract class ParallelFlowable<T> {
    public abstract void subscribe(@NonNull Subscriber<? super T>[] var1);

    public abstract int parallelism();

    protected final boolean validate(@NonNull Subscriber<?>[] subscribers) {
        int p = this.parallelism();
        if (subscribers.length != p) {
            IllegalArgumentException iae = new IllegalArgumentException("parallelism = " + p + ", subscribers = " + subscribers.length);
            for (Subscriber<?> s : subscribers) {
                EmptySubscription.error(iae, s);
            }
            return false;
        }
        return true;
    }

    @CheckReturnValue
    public static <T> ParallelFlowable<T> from(@NonNull Publisher<? extends T> source) {
        return ParallelFlowable.from(source, Runtime.getRuntime().availableProcessors(), Flowable.bufferSize());
    }

    @CheckReturnValue
    public static <T> ParallelFlowable<T> from(@NonNull Publisher<? extends T> source, int parallelism) {
        return ParallelFlowable.from(source, parallelism, Flowable.bufferSize());
    }

    @CheckReturnValue
    @NonNull
    public static <T> ParallelFlowable<T> from(@NonNull Publisher<? extends T> source, int parallelism, int prefetch) {
        ObjectHelper.requireNonNull(source, (String)"source");
        ObjectHelper.verifyPositive((int)parallelism, (String)"parallelism");
        ObjectHelper.verifyPositive((int)prefetch, (String)"prefetch");
        return RxJavaFlowablePlugins.onAssembly(new ParallelFromPublisher<T>(source, parallelism, prefetch));
    }

    @CheckReturnValue
    @NonNull
    public final <R> ParallelFlowable<R> map(@NonNull Function<? super T, ? extends R> mapper) {
        ObjectHelper.requireNonNull(mapper, (String)"mapper");
        return RxJavaFlowablePlugins.onAssembly(new ParallelMap<T, R>(this, mapper));
    }

    @CheckReturnValue
    @Experimental
    @NonNull
    public final <R> ParallelFlowable<R> map(@NonNull Function<? super T, ? extends R> mapper, @NonNull ParallelFailureHandling errorHandler) {
        ObjectHelper.requireNonNull(mapper, (String)"mapper");
        ObjectHelper.requireNonNull((Object)((Object)errorHandler), (String)"errorHandler is null");
        return RxJavaFlowablePlugins.onAssembly(new ParallelMapTry<T, R>(this, mapper, errorHandler));
    }

    @CheckReturnValue
    @Experimental
    @NonNull
    public final <R> ParallelFlowable<R> map(@NonNull Function<? super T, ? extends R> mapper, @NonNull BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler) {
        ObjectHelper.requireNonNull(mapper, (String)"mapper");
        ObjectHelper.requireNonNull(errorHandler, (String)"errorHandler is null");
        return RxJavaFlowablePlugins.onAssembly(new ParallelMapTry<T, R>(this, mapper, errorHandler));
    }

    @CheckReturnValue
    public final ParallelFlowable<T> filter(@NonNull Predicate<? super T> predicate) {
        ObjectHelper.requireNonNull(predicate, (String)"predicate");
        return RxJavaFlowablePlugins.onAssembly(new ParallelFilter<T>(this, predicate));
    }

    @CheckReturnValue
    @Experimental
    public final ParallelFlowable<T> filter(@NonNull Predicate<? super T> predicate, @NonNull ParallelFailureHandling errorHandler) {
        ObjectHelper.requireNonNull(predicate, (String)"predicate");
        ObjectHelper.requireNonNull((Object)((Object)errorHandler), (String)"errorHandler is null");
        return RxJavaFlowablePlugins.onAssembly(new ParallelFilterTry<T>(this, predicate, errorHandler));
    }

    @CheckReturnValue
    @Experimental
    public final ParallelFlowable<T> filter(@NonNull Predicate<? super T> predicate, @NonNull BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler) {
        ObjectHelper.requireNonNull(predicate, (String)"predicate");
        ObjectHelper.requireNonNull(errorHandler, (String)"errorHandler is null");
        return RxJavaFlowablePlugins.onAssembly(new ParallelFilterTry<T>(this, predicate, errorHandler));
    }

    @CheckReturnValue
    @NonNull
    public final ParallelFlowable<T> runOn(@NonNull Scheduler scheduler) {
        return this.runOn(scheduler, Flowable.bufferSize());
    }

    @CheckReturnValue
    @NonNull
    public final ParallelFlowable<T> runOn(@NonNull Scheduler scheduler, int prefetch) {
        ObjectHelper.requireNonNull((Object)scheduler, (String)"scheduler");
        ObjectHelper.verifyPositive((int)prefetch, (String)"prefetch");
        return RxJavaFlowablePlugins.onAssembly(new ParallelRunOn(this, scheduler, prefetch));
    }

    @CheckReturnValue
    @NonNull
    public final Flowable<T> reduce(@NonNull BiFunction<T, T, T> reducer) {
        ObjectHelper.requireNonNull(reducer, (String)"reducer");
        return RxJavaFlowablePlugins.onAssembly(new ParallelReduceFull<T>(this, reducer));
    }

    @CheckReturnValue
    @NonNull
    public final <R> ParallelFlowable<R> reduce(@NonNull Callable<R> initialSupplier, @NonNull BiFunction<R, ? super T, R> reducer) {
        ObjectHelper.requireNonNull(initialSupplier, (String)"initialSupplier");
        ObjectHelper.requireNonNull(reducer, (String)"reducer");
        return RxJavaFlowablePlugins.onAssembly(new ParallelReduce<T, R>(this, initialSupplier, reducer));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @CheckReturnValue
    public final Flowable<T> sequential() {
        return this.sequential(Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @CheckReturnValue
    @NonNull
    public final Flowable<T> sequential(int prefetch) {
        ObjectHelper.verifyPositive((int)prefetch, (String)"prefetch");
        return RxJavaFlowablePlugins.onAssembly(new ParallelJoin(this, prefetch, false));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @CheckReturnValue
    @Experimental
    @NonNull
    public final Flowable<T> sequentialDelayError() {
        return this.sequentialDelayError(Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @CheckReturnValue
    @NonNull
    public final Flowable<T> sequentialDelayError(int prefetch) {
        ObjectHelper.verifyPositive((int)prefetch, (String)"prefetch");
        return RxJavaFlowablePlugins.onAssembly(new ParallelJoin(this, prefetch, true));
    }

    @CheckReturnValue
    @NonNull
    public final Flowable<T> sorted(@NonNull Comparator<? super T> comparator) {
        return this.sorted(comparator, 16);
    }

    @CheckReturnValue
    @NonNull
    public final Flowable<T> sorted(@NonNull Comparator<? super T> comparator, int capacityHint) {
        ObjectHelper.requireNonNull(comparator, (String)"comparator is null");
        ObjectHelper.verifyPositive((int)capacityHint, (String)"capacityHint");
        int ch = capacityHint / this.parallelism() + 1;
        ParallelFlowable railReduced = this.reduce(Functions.createArrayList((int)ch), ListAddBiConsumer.instance());
        ParallelFlowable railSorted = railReduced.map((Function)new SorterFunction(comparator));
        return RxJavaFlowablePlugins.onAssembly(new ParallelSortedJoin<T>(railSorted, comparator));
    }

    @CheckReturnValue
    @NonNull
    public final Flowable<List<T>> toSortedList(@NonNull Comparator<? super T> comparator) {
        return this.toSortedList(comparator, 16);
    }

    @CheckReturnValue
    @NonNull
    public final Flowable<List<T>> toSortedList(@NonNull Comparator<? super T> comparator, int capacityHint) {
        ObjectHelper.requireNonNull(comparator, (String)"comparator is null");
        ObjectHelper.verifyPositive((int)capacityHint, (String)"capacityHint");
        int ch = capacityHint / this.parallelism() + 1;
        ParallelFlowable railReduced = this.reduce(Functions.createArrayList((int)ch), ListAddBiConsumer.instance());
        ParallelFlowable railSorted = railReduced.map((Function)new SorterFunction(comparator));
        Flowable merged = railSorted.reduce((BiFunction)new MergerBiFunction(comparator));
        return RxJavaFlowablePlugins.onAssembly(merged);
    }

    @CheckReturnValue
    @NonNull
    public final ParallelFlowable<T> doOnNext(@NonNull Consumer<? super T> onNext) {
        ObjectHelper.requireNonNull(onNext, (String)"onNext is null");
        return RxJavaFlowablePlugins.onAssembly(new ParallelPeek<T>(this, onNext, Functions.emptyConsumer(), (Consumer<? super Throwable>)Functions.emptyConsumer(), Functions.EMPTY_ACTION, Functions.EMPTY_ACTION, (Consumer<? super Subscription>)Functions.emptyConsumer(), Functions.EMPTY_LONG_CONSUMER, Functions.EMPTY_ACTION));
    }

    @CheckReturnValue
    @Experimental
    @NonNull
    public final ParallelFlowable<T> doOnNext(@NonNull Consumer<? super T> onNext, @NonNull ParallelFailureHandling errorHandler) {
        ObjectHelper.requireNonNull(onNext, (String)"onNext is null");
        ObjectHelper.requireNonNull((Object)((Object)errorHandler), (String)"errorHandler is null");
        return RxJavaFlowablePlugins.onAssembly(new ParallelDoOnNextTry<T>(this, onNext, errorHandler));
    }

    @CheckReturnValue
    @Experimental
    @NonNull
    public final ParallelFlowable<T> doOnNext(@NonNull Consumer<? super T> onNext, @NonNull BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler) {
        ObjectHelper.requireNonNull(onNext, (String)"onNext is null");
        ObjectHelper.requireNonNull(errorHandler, (String)"errorHandler is null");
        return RxJavaFlowablePlugins.onAssembly(new ParallelDoOnNextTry<T>(this, onNext, errorHandler));
    }

    @CheckReturnValue
    @NonNull
    public final ParallelFlowable<T> doAfterNext(@NonNull Consumer<? super T> onAfterNext) {
        ObjectHelper.requireNonNull(onAfterNext, (String)"onAfterNext is null");
        return RxJavaFlowablePlugins.onAssembly(new ParallelPeek<T>(this, Functions.emptyConsumer(), onAfterNext, (Consumer<? super Throwable>)Functions.emptyConsumer(), Functions.EMPTY_ACTION, Functions.EMPTY_ACTION, (Consumer<? super Subscription>)Functions.emptyConsumer(), Functions.EMPTY_LONG_CONSUMER, Functions.EMPTY_ACTION));
    }

    @CheckReturnValue
    @NonNull
    public final ParallelFlowable<T> doOnError(@NonNull Consumer<Throwable> onError) {
        ObjectHelper.requireNonNull(onError, (String)"onError is null");
        return RxJavaFlowablePlugins.onAssembly(new ParallelPeek(this, Functions.emptyConsumer(), Functions.emptyConsumer(), onError, Functions.EMPTY_ACTION, Functions.EMPTY_ACTION, (Consumer<? super Subscription>)Functions.emptyConsumer(), Functions.EMPTY_LONG_CONSUMER, Functions.EMPTY_ACTION));
    }

    @CheckReturnValue
    @NonNull
    public final ParallelFlowable<T> doOnComplete(@NonNull Action onComplete) {
        ObjectHelper.requireNonNull((Object)onComplete, (String)"onComplete is null");
        return RxJavaFlowablePlugins.onAssembly(new ParallelPeek(this, Functions.emptyConsumer(), Functions.emptyConsumer(), (Consumer<? super Throwable>)Functions.emptyConsumer(), onComplete, Functions.EMPTY_ACTION, (Consumer<? super Subscription>)Functions.emptyConsumer(), Functions.EMPTY_LONG_CONSUMER, Functions.EMPTY_ACTION));
    }

    @CheckReturnValue
    @NonNull
    public final ParallelFlowable<T> doAfterTerminated(@NonNull Action onAfterTerminate) {
        ObjectHelper.requireNonNull((Object)onAfterTerminate, (String)"onAfterTerminate is null");
        return RxJavaFlowablePlugins.onAssembly(new ParallelPeek(this, Functions.emptyConsumer(), Functions.emptyConsumer(), (Consumer<? super Throwable>)Functions.emptyConsumer(), Functions.EMPTY_ACTION, onAfterTerminate, (Consumer<? super Subscription>)Functions.emptyConsumer(), Functions.EMPTY_LONG_CONSUMER, Functions.EMPTY_ACTION));
    }

    @CheckReturnValue
    @NonNull
    public final ParallelFlowable<T> doOnSubscribe(@NonNull Consumer<? super Subscription> onSubscribe) {
        ObjectHelper.requireNonNull(onSubscribe, (String)"onSubscribe is null");
        return RxJavaFlowablePlugins.onAssembly(new ParallelPeek(this, Functions.emptyConsumer(), Functions.emptyConsumer(), (Consumer<? super Throwable>)Functions.emptyConsumer(), Functions.EMPTY_ACTION, Functions.EMPTY_ACTION, onSubscribe, Functions.EMPTY_LONG_CONSUMER, Functions.EMPTY_ACTION));
    }

    @CheckReturnValue
    @NonNull
    public final ParallelFlowable<T> doOnRequest(@NonNull LongConsumer onRequest) {
        ObjectHelper.requireNonNull((Object)onRequest, (String)"onRequest is null");
        return RxJavaFlowablePlugins.onAssembly(new ParallelPeek(this, Functions.emptyConsumer(), Functions.emptyConsumer(), (Consumer<? super Throwable>)Functions.emptyConsumer(), Functions.EMPTY_ACTION, Functions.EMPTY_ACTION, (Consumer<? super Subscription>)Functions.emptyConsumer(), onRequest, Functions.EMPTY_ACTION));
    }

    @CheckReturnValue
    @NonNull
    public final ParallelFlowable<T> doOnCancel(@NonNull Action onCancel) {
        ObjectHelper.requireNonNull((Object)onCancel, (String)"onCancel is null");
        return RxJavaFlowablePlugins.onAssembly(new ParallelPeek(this, Functions.emptyConsumer(), Functions.emptyConsumer(), (Consumer<? super Throwable>)Functions.emptyConsumer(), Functions.EMPTY_ACTION, Functions.EMPTY_ACTION, (Consumer<? super Subscription>)Functions.emptyConsumer(), Functions.EMPTY_LONG_CONSUMER, onCancel));
    }

    @CheckReturnValue
    @NonNull
    public final <C> ParallelFlowable<C> collect(@NonNull Callable<? extends C> collectionSupplier, @NonNull BiConsumer<? super C, ? super T> collector) {
        ObjectHelper.requireNonNull(collectionSupplier, (String)"collectionSupplier is null");
        ObjectHelper.requireNonNull(collector, (String)"collector is null");
        return RxJavaFlowablePlugins.onAssembly(new ParallelCollect<T, C>(this, collectionSupplier, collector));
    }

    @CheckReturnValue
    @NonNull
    public static <T> ParallelFlowable<T> fromArray(Publisher<T> ... publishers) {
        if (publishers.length == 0) {
            throw new IllegalArgumentException("Zero publishers not supported");
        }
        return RxJavaFlowablePlugins.onAssembly(new ParallelFromArray<T>(publishers));
    }

    @CheckReturnValue
    @NonNull
    public final <U> U to(@NonNull Function<? super ParallelFlowable<T>, U> converter) {
        try {
            return (U)((Function)ObjectHelper.requireNonNull(converter, (String)"converter is null")).apply((Object)this);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal((Throwable)ex);
            throw ExceptionHelper.wrapOrThrow((Throwable)ex);
        }
    }

    @CheckReturnValue
    @NonNull
    public final <U> ParallelFlowable<U> compose(@NonNull ParallelTransformer<T, U> composer) {
        return RxJavaFlowablePlugins.onAssembly(((ParallelTransformer)ObjectHelper.requireNonNull(composer, (String)"composer is null")).apply(this));
    }

    @CheckReturnValue
    @NonNull
    public final <R> ParallelFlowable<R> flatMap(@NonNull Function<? super T, ? extends Publisher<? extends R>> mapper) {
        return this.flatMap(mapper, false, Integer.MAX_VALUE, Flowable.bufferSize());
    }

    @CheckReturnValue
    @NonNull
    public final <R> ParallelFlowable<R> flatMap(@NonNull Function<? super T, ? extends Publisher<? extends R>> mapper, boolean delayError) {
        return this.flatMap(mapper, delayError, Integer.MAX_VALUE, Flowable.bufferSize());
    }

    @CheckReturnValue
    @NonNull
    public final <R> ParallelFlowable<R> flatMap(@NonNull Function<? super T, ? extends Publisher<? extends R>> mapper, boolean delayError, int maxConcurrency) {
        return this.flatMap(mapper, delayError, maxConcurrency, Flowable.bufferSize());
    }

    @CheckReturnValue
    @NonNull
    public final <R> ParallelFlowable<R> flatMap(@NonNull Function<? super T, ? extends Publisher<? extends R>> mapper, boolean delayError, int maxConcurrency, int prefetch) {
        ObjectHelper.requireNonNull(mapper, (String)"mapper is null");
        ObjectHelper.verifyPositive((int)maxConcurrency, (String)"maxConcurrency");
        ObjectHelper.verifyPositive((int)prefetch, (String)"prefetch");
        return RxJavaFlowablePlugins.onAssembly(new ParallelFlatMap(this, mapper, delayError, maxConcurrency, prefetch));
    }

    @CheckReturnValue
    @NonNull
    public final <R> ParallelFlowable<R> concatMap(@NonNull Function<? super T, ? extends Publisher<? extends R>> mapper) {
        return this.concatMap(mapper, 2);
    }

    @CheckReturnValue
    @NonNull
    public final <R> ParallelFlowable<R> concatMap(@NonNull Function<? super T, ? extends Publisher<? extends R>> mapper, int prefetch) {
        ObjectHelper.requireNonNull(mapper, (String)"mapper is null");
        ObjectHelper.verifyPositive((int)prefetch, (String)"prefetch");
        return RxJavaFlowablePlugins.onAssembly(new ParallelConcatMap(this, mapper, prefetch, ErrorMode.IMMEDIATE));
    }

    @CheckReturnValue
    @NonNull
    public final <R> ParallelFlowable<R> concatMapDelayError(@NonNull Function<? super T, ? extends Publisher<? extends R>> mapper, boolean tillTheEnd) {
        return this.concatMapDelayError(mapper, 2, tillTheEnd);
    }

    @CheckReturnValue
    @NonNull
    public final <R> ParallelFlowable<R> concatMapDelayError(@NonNull Function<? super T, ? extends Publisher<? extends R>> mapper, int prefetch, boolean tillTheEnd) {
        ObjectHelper.requireNonNull(mapper, (String)"mapper is null");
        ObjectHelper.verifyPositive((int)prefetch, (String)"prefetch");
        return RxJavaFlowablePlugins.onAssembly(new ParallelConcatMap(this, mapper, prefetch, tillTheEnd ? ErrorMode.END : ErrorMode.BOUNDARY));
    }
}

