/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.operators;

import io.reactivex.common.functions.Action;
import io.reactivex.common.functions.Consumer;
import io.reactivex.common.internal.functions.Functions;
import io.reactivex.common.internal.functions.ObjectHelper;
import io.reactivex.common.internal.utils.BlockingHelper;
import io.reactivex.common.internal.utils.BlockingIgnoringReceiver;
import io.reactivex.common.internal.utils.ExceptionHelper;
import io.reactivex.flowable.internal.subscribers.BlockingSubscriber;
import io.reactivex.flowable.internal.subscribers.LambdaSubscriber;
import io.reactivex.flowable.internal.utils.MaxRequestSubscription;
import io.reactivex.flowable.internal.utils.NotificationLite;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public final class FlowableBlockingSubscribe {
    private FlowableBlockingSubscribe() {
        throw new IllegalStateException("No instances!");
    }

    public static <T> void subscribe(Publisher<? extends T> o, Subscriber<? super T> subscriber) {
        LinkedBlockingQueue<Object> queue = new LinkedBlockingQueue<Object>();
        BlockingSubscriber bs = new BlockingSubscriber((Queue<Object>)queue);
        o.subscribe(bs);
        try {
            while (!bs.isCancelled()) {
                Object v = queue.poll();
                if (v == null) {
                    if (bs.isCancelled()) break;
                    BlockingHelper.verifyNonBlocking();
                    v = queue.take();
                }
                if (!bs.isCancelled() && o != BlockingSubscriber.TERMINATED && !NotificationLite.acceptFull(v, subscriber)) continue;
                break;
            }
        }
        catch (InterruptedException e) {
            bs.cancel();
            subscriber.onError((Throwable)e);
        }
    }

    public static <T> void subscribe(Publisher<? extends T> o) {
        BlockingIgnoringReceiver callback = new BlockingIgnoringReceiver();
        LambdaSubscriber ls = new LambdaSubscriber(Functions.emptyConsumer(), (Consumer<? super Throwable>)callback, (Action)callback, MaxRequestSubscription.REQUEST_MAX);
        o.subscribe(ls);
        BlockingHelper.awaitForComplete((CountDownLatch)callback, ls);
        Throwable e = callback.error;
        if (e != null) {
            throw ExceptionHelper.wrapOrThrow((Throwable)e);
        }
    }

    public static <T> void subscribe(Publisher<? extends T> o, Consumer<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete) {
        ObjectHelper.requireNonNull(onNext, (String)"onNext is null");
        ObjectHelper.requireNonNull(onError, (String)"onError is null");
        ObjectHelper.requireNonNull((Object)onComplete, (String)"onComplete is null");
        FlowableBlockingSubscribe.subscribe(o, new LambdaSubscriber<T>(onNext, onError, onComplete, MaxRequestSubscription.REQUEST_MAX));
    }
}

