/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.operators;

import io.reactivex.common.Disposable;
import io.reactivex.common.RxJavaCommonPlugins;
import io.reactivex.common.disposables.CompositeDisposable;
import io.reactivex.common.exceptions.Exceptions;
import io.reactivex.common.functions.Function;
import io.reactivex.common.internal.functions.ObjectHelper;
import io.reactivex.flowable.Flowable;
import io.reactivex.flowable.internal.operators.AbstractFlowableWithUpstream;
import io.reactivex.flowable.internal.queues.MpscLinkedQueue;
import io.reactivex.flowable.internal.queues.SimplePlainQueue;
import io.reactivex.flowable.internal.subscribers.QueueDrainSubscriber;
import io.reactivex.flowable.internal.subscriptions.SubscriptionHelper;
import io.reactivex.flowable.internal.utils.QueueDrainHelper;
import io.reactivex.flowable.subscribers.DisposableSubscriber;
import io.reactivex.flowable.subscribers.SerializedSubscriber;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableBufferBoundary<T, U extends Collection<? super T>, Open, Close>
extends AbstractFlowableWithUpstream<T, U> {
    final Callable<U> bufferSupplier;
    final Publisher<? extends Open> bufferOpen;
    final Function<? super Open, ? extends Publisher<? extends Close>> bufferClose;

    public FlowableBufferBoundary(Flowable<T> source, Publisher<? extends Open> bufferOpen, Function<? super Open, ? extends Publisher<? extends Close>> bufferClose, Callable<U> bufferSupplier) {
        super(source);
        this.bufferOpen = bufferOpen;
        this.bufferClose = bufferClose;
        this.bufferSupplier = bufferSupplier;
    }

    @Override
    protected void subscribeActual(Subscriber<? super U> s) {
        this.source.subscribe(new BufferBoundarySubscriber(new SerializedSubscriber<U>(s), this.bufferOpen, this.bufferClose, this.bufferSupplier));
    }

    static final class BufferCloseSubscriber<T, U extends Collection<? super T>, Open, Close>
    extends DisposableSubscriber<Close> {
        final BufferBoundarySubscriber<T, U, Open, Close> parent;
        final U value;
        boolean done;

        BufferCloseSubscriber(U value, BufferBoundarySubscriber<T, U, Open, Close> parent) {
            this.parent = parent;
            this.value = value;
        }

        public void onNext(Close t) {
            this.onComplete();
        }

        public void onError(Throwable t) {
            if (this.done) {
                RxJavaCommonPlugins.onError((Throwable)t);
                return;
            }
            this.parent.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.parent.close(this.value, this);
        }
    }

    static final class BufferOpenSubscriber<T, U extends Collection<? super T>, Open, Close>
    extends DisposableSubscriber<Open> {
        final BufferBoundarySubscriber<T, U, Open, Close> parent;
        boolean done;

        BufferOpenSubscriber(BufferBoundarySubscriber<T, U, Open, Close> parent) {
            this.parent = parent;
        }

        public void onNext(Open t) {
            if (this.done) {
                return;
            }
            this.parent.open(t);
        }

        public void onError(Throwable t) {
            if (this.done) {
                RxJavaCommonPlugins.onError((Throwable)t);
                return;
            }
            this.done = true;
            this.parent.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.parent.openFinished(this);
        }
    }

    static final class BufferBoundarySubscriber<T, U extends Collection<? super T>, Open, Close>
    extends QueueDrainSubscriber<T, U, U>
    implements Subscription,
    Disposable {
        final Publisher<? extends Open> bufferOpen;
        final Function<? super Open, ? extends Publisher<? extends Close>> bufferClose;
        final Callable<U> bufferSupplier;
        final CompositeDisposable resources;
        Subscription s;
        final List<U> buffers;
        final AtomicInteger windows = new AtomicInteger();

        BufferBoundarySubscriber(Subscriber<? super U> actual, Publisher<? extends Open> bufferOpen, Function<? super Open, ? extends Publisher<? extends Close>> bufferClose, Callable<U> bufferSupplier) {
            super(actual, new MpscLinkedQueue());
            this.bufferOpen = bufferOpen;
            this.bufferClose = bufferClose;
            this.bufferSupplier = bufferSupplier;
            this.buffers = new LinkedList<U>();
            this.resources = new CompositeDisposable();
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                BufferOpenSubscriber bos = new BufferOpenSubscriber(this);
                this.resources.add(bos);
                this.actual.onSubscribe((Subscription)this);
                this.windows.lazySet(1);
                this.bufferOpen.subscribe(bos);
                s.request(Long.MAX_VALUE);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(T t) {
            BufferBoundarySubscriber bufferBoundarySubscriber = this;
            synchronized (bufferBoundarySubscriber) {
                for (Collection b : this.buffers) {
                    b.add(t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(Throwable t) {
            this.cancel();
            this.cancelled = true;
            BufferBoundarySubscriber bufferBoundarySubscriber = this;
            synchronized (bufferBoundarySubscriber) {
                this.buffers.clear();
            }
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.windows.decrementAndGet() == 0) {
                this.complete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void complete() {
            ArrayList<U> list;
            BufferBoundarySubscriber bufferBoundarySubscriber = this;
            synchronized (bufferBoundarySubscriber) {
                list = new ArrayList<U>(this.buffers);
                this.buffers.clear();
            }
            SimplePlainQueue q = this.queue;
            for (Collection u : list) {
                q.offer(u);
            }
            this.done = true;
            if (this.enter()) {
                QueueDrainHelper.drainMaxLoop(q, this.actual, false, this, this);
            }
        }

        public void request(long n) {
            this.requested(n);
        }

        public void dispose() {
            this.resources.dispose();
        }

        public boolean isDisposed() {
            return this.resources.isDisposed();
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.dispose();
            }
        }

        @Override
        public boolean accept(Subscriber<? super U> a, U v) {
            a.onNext(v);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void open(Open window) {
            Publisher p;
            Collection b;
            if (this.cancelled) {
                return;
            }
            try {
                b = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), (String)"The buffer supplied is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                this.onError(e);
                return;
            }
            try {
                p = (Publisher)ObjectHelper.requireNonNull((Object)this.bufferClose.apply(window), (String)"The buffer closing publisher is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                this.onError(e);
                return;
            }
            if (this.cancelled) {
                return;
            }
            BufferBoundarySubscriber e = this;
            synchronized (e) {
                if (this.cancelled) {
                    return;
                }
                this.buffers.add(b);
            }
            BufferCloseSubscriber bcs = new BufferCloseSubscriber(b, this);
            this.resources.add(bcs);
            this.windows.getAndIncrement();
            p.subscribe(bcs);
        }

        void openFinished(Disposable d) {
            if (this.resources.remove(d) && this.windows.decrementAndGet() == 0) {
                this.complete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close(U b, Disposable d) {
            boolean e;
            BufferBoundarySubscriber bufferBoundarySubscriber = this;
            synchronized (bufferBoundarySubscriber) {
                e = this.buffers.remove(b);
            }
            if (e) {
                this.fastPathOrderedEmitMax(b, false, this);
            }
            if (this.resources.remove(d) && this.windows.decrementAndGet() == 0) {
                this.complete();
            }
        }
    }
}

