/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.operators;

import hu.akarnokd.reactivestreams.extensions.RelaxedSubscriber;
import io.reactivex.common.Disposable;
import io.reactivex.common.RxJavaCommonPlugins;
import io.reactivex.common.exceptions.Exceptions;
import io.reactivex.common.internal.disposables.DisposableHelper;
import io.reactivex.common.internal.functions.ObjectHelper;
import io.reactivex.flowable.Flowable;
import io.reactivex.flowable.internal.operators.AbstractFlowableWithUpstream;
import io.reactivex.flowable.internal.queues.MpscLinkedQueue;
import io.reactivex.flowable.internal.subscribers.QueueDrainSubscriber;
import io.reactivex.flowable.internal.subscriptions.EmptySubscription;
import io.reactivex.flowable.internal.subscriptions.SubscriptionHelper;
import io.reactivex.flowable.internal.utils.QueueDrainHelper;
import io.reactivex.flowable.subscribers.DisposableSubscriber;
import io.reactivex.flowable.subscribers.SerializedSubscriber;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableBufferBoundarySupplier<T, U extends Collection<? super T>, B>
extends AbstractFlowableWithUpstream<T, U> {
    final Callable<? extends Publisher<B>> boundarySupplier;
    final Callable<U> bufferSupplier;

    public FlowableBufferBoundarySupplier(Flowable<T> source, Callable<? extends Publisher<B>> boundarySupplier, Callable<U> bufferSupplier) {
        super(source);
        this.boundarySupplier = boundarySupplier;
        this.bufferSupplier = bufferSupplier;
    }

    @Override
    protected void subscribeActual(Subscriber<? super U> s) {
        this.source.subscribe(new BufferBoundarySupplierSubscriber(new SerializedSubscriber<U>(s), this.bufferSupplier, this.boundarySupplier));
    }

    static final class BufferBoundarySubscriber<T, U extends Collection<? super T>, B>
    extends DisposableSubscriber<B> {
        final BufferBoundarySupplierSubscriber<T, U, B> parent;
        boolean once;

        BufferBoundarySubscriber(BufferBoundarySupplierSubscriber<T, U, B> parent) {
            this.parent = parent;
        }

        public void onNext(B t) {
            if (this.once) {
                return;
            }
            this.once = true;
            this.cancel();
            this.parent.next();
        }

        public void onError(Throwable t) {
            if (this.once) {
                RxJavaCommonPlugins.onError((Throwable)t);
                return;
            }
            this.once = true;
            this.parent.onError(t);
        }

        public void onComplete() {
            if (this.once) {
                return;
            }
            this.once = true;
            this.parent.next();
        }
    }

    static final class BufferBoundarySupplierSubscriber<T, U extends Collection<? super T>, B>
    extends QueueDrainSubscriber<T, U, U>
    implements RelaxedSubscriber<T>,
    Subscription,
    Disposable {
        final Callable<U> bufferSupplier;
        final Callable<? extends Publisher<B>> boundarySupplier;
        Subscription s;
        final AtomicReference<Disposable> other = new AtomicReference();
        U buffer;

        BufferBoundarySupplierSubscriber(Subscriber<? super U> actual, Callable<U> bufferSupplier, Callable<? extends Publisher<B>> boundarySupplier) {
            super(actual, new MpscLinkedQueue());
            this.bufferSupplier = bufferSupplier;
            this.boundarySupplier = boundarySupplier;
        }

        public void onSubscribe(Subscription s) {
            Publisher boundary;
            Collection b;
            if (!SubscriptionHelper.validate(this.s, s)) {
                return;
            }
            this.s = s;
            Subscriber actual = this.actual;
            try {
                b = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), (String)"The buffer supplied is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                this.cancelled = true;
                s.cancel();
                EmptySubscription.error(e, actual);
                return;
            }
            this.buffer = b;
            try {
                boundary = (Publisher)ObjectHelper.requireNonNull(this.boundarySupplier.call(), (String)"The boundary publisher supplied is null");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.cancelled = true;
                s.cancel();
                EmptySubscription.error(ex, actual);
                return;
            }
            BufferBoundarySubscriber bs = new BufferBoundarySubscriber(this);
            this.other.set(bs);
            actual.onSubscribe((Subscription)this);
            if (!this.cancelled) {
                s.request(Long.MAX_VALUE);
                boundary.subscribe(bs);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(T t) {
            BufferBoundarySupplierSubscriber bufferBoundarySupplierSubscriber = this;
            synchronized (bufferBoundarySupplierSubscriber) {
                U b = this.buffer;
                if (b == null) {
                    return;
                }
                b.add(t);
            }
        }

        public void onError(Throwable t) {
            this.cancel();
            this.actual.onError(t);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onComplete() {
            U b;
            BufferBoundarySupplierSubscriber bufferBoundarySupplierSubscriber = this;
            synchronized (bufferBoundarySupplierSubscriber) {
                b = this.buffer;
                if (b == null) {
                    return;
                }
                this.buffer = null;
            }
            this.queue.offer(b);
            this.done = true;
            if (this.enter()) {
                QueueDrainHelper.drainMaxLoop(this.queue, this.actual, false, this, this);
            }
        }

        public void request(long n) {
            this.requested(n);
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.s.cancel();
                this.disposeOther();
                if (this.enter()) {
                    this.queue.clear();
                }
            }
        }

        void disposeOther() {
            DisposableHelper.dispose(this.other);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void next() {
            U b;
            Publisher boundary;
            Collection next;
            try {
                next = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), (String)"The buffer supplied is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                this.cancel();
                this.actual.onError(e);
                return;
            }
            try {
                boundary = (Publisher)ObjectHelper.requireNonNull(this.boundarySupplier.call(), (String)"The boundary publisher supplied is null");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.cancelled = true;
                this.s.cancel();
                this.actual.onError(ex);
                return;
            }
            BufferBoundarySubscriber bs = new BufferBoundarySubscriber(this);
            Disposable o = this.other.get();
            if (!this.other.compareAndSet(o, bs)) {
                return;
            }
            BufferBoundarySupplierSubscriber bufferBoundarySupplierSubscriber = this;
            synchronized (bufferBoundarySupplierSubscriber) {
                b = this.buffer;
                if (b == null) {
                    return;
                }
                this.buffer = next;
            }
            boundary.subscribe(bs);
            this.fastPathEmitMax(b, false, this);
        }

        public void dispose() {
            this.s.cancel();
            this.disposeOther();
        }

        public boolean isDisposed() {
            return this.other.get() == DisposableHelper.DISPOSED;
        }

        @Override
        public boolean accept(Subscriber<? super U> a, U v) {
            this.actual.onNext(v);
            return true;
        }
    }
}

