/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.operators;

import hu.akarnokd.reactivestreams.extensions.RelaxedSubscriber;
import io.reactivex.common.Disposable;
import io.reactivex.common.exceptions.Exceptions;
import io.reactivex.common.internal.functions.ObjectHelper;
import io.reactivex.flowable.Flowable;
import io.reactivex.flowable.internal.operators.AbstractFlowableWithUpstream;
import io.reactivex.flowable.internal.queues.MpscLinkedQueue;
import io.reactivex.flowable.internal.subscribers.QueueDrainSubscriber;
import io.reactivex.flowable.internal.subscriptions.EmptySubscription;
import io.reactivex.flowable.internal.subscriptions.SubscriptionHelper;
import io.reactivex.flowable.internal.utils.QueueDrainHelper;
import io.reactivex.flowable.subscribers.DisposableSubscriber;
import io.reactivex.flowable.subscribers.SerializedSubscriber;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableBufferExactBoundary<T, U extends Collection<? super T>, B>
extends AbstractFlowableWithUpstream<T, U> {
    final Publisher<B> boundary;
    final Callable<U> bufferSupplier;

    public FlowableBufferExactBoundary(Flowable<T> source, Publisher<B> boundary, Callable<U> bufferSupplier) {
        super(source);
        this.boundary = boundary;
        this.bufferSupplier = bufferSupplier;
    }

    @Override
    protected void subscribeActual(Subscriber<? super U> s) {
        this.source.subscribe(new BufferExactBoundarySubscriber(new SerializedSubscriber<U>(s), this.bufferSupplier, this.boundary));
    }

    static final class BufferBoundarySubscriber<T, U extends Collection<? super T>, B>
    extends DisposableSubscriber<B> {
        final BufferExactBoundarySubscriber<T, U, B> parent;

        BufferBoundarySubscriber(BufferExactBoundarySubscriber<T, U, B> parent) {
            this.parent = parent;
        }

        public void onNext(B t) {
            this.parent.next();
        }

        public void onError(Throwable t) {
            this.parent.onError(t);
        }

        public void onComplete() {
            this.parent.onComplete();
        }
    }

    static final class BufferExactBoundarySubscriber<T, U extends Collection<? super T>, B>
    extends QueueDrainSubscriber<T, U, U>
    implements RelaxedSubscriber<T>,
    Subscription,
    Disposable {
        final Callable<U> bufferSupplier;
        final Publisher<B> boundary;
        Subscription s;
        Disposable other;
        U buffer;

        BufferExactBoundarySubscriber(Subscriber<? super U> actual, Callable<U> bufferSupplier, Publisher<B> boundary) {
            super(actual, new MpscLinkedQueue());
            this.bufferSupplier = bufferSupplier;
            this.boundary = boundary;
        }

        public void onSubscribe(Subscription s) {
            BufferBoundarySubscriber bs;
            Collection b;
            if (!SubscriptionHelper.validate(this.s, s)) {
                return;
            }
            this.s = s;
            try {
                b = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), (String)"The buffer supplied is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                this.cancelled = true;
                s.cancel();
                EmptySubscription.error(e, this.actual);
                return;
            }
            this.buffer = b;
            this.other = bs = new BufferBoundarySubscriber(this);
            this.actual.onSubscribe((Subscription)this);
            if (!this.cancelled) {
                s.request(Long.MAX_VALUE);
                this.boundary.subscribe(bs);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(T t) {
            BufferExactBoundarySubscriber bufferExactBoundarySubscriber = this;
            synchronized (bufferExactBoundarySubscriber) {
                U b = this.buffer;
                if (b == null) {
                    return;
                }
                b.add(t);
            }
        }

        public void onError(Throwable t) {
            this.cancel();
            this.actual.onError(t);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onComplete() {
            U b;
            BufferExactBoundarySubscriber bufferExactBoundarySubscriber = this;
            synchronized (bufferExactBoundarySubscriber) {
                b = this.buffer;
                if (b == null) {
                    return;
                }
                this.buffer = null;
            }
            this.queue.offer(b);
            this.done = true;
            if (this.enter()) {
                QueueDrainHelper.drainMaxLoop(this.queue, this.actual, false, this, this);
            }
        }

        public void request(long n) {
            this.requested(n);
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.other.dispose();
                this.s.cancel();
                if (this.enter()) {
                    this.queue.clear();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void next() {
            U b;
            Collection next;
            try {
                next = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), (String)"The buffer supplied is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                this.cancel();
                this.actual.onError(e);
                return;
            }
            BufferExactBoundarySubscriber bufferExactBoundarySubscriber = this;
            synchronized (bufferExactBoundarySubscriber) {
                b = this.buffer;
                if (b == null) {
                    return;
                }
                this.buffer = next;
            }
            this.fastPathEmitMax(b, false, this);
        }

        public void dispose() {
            this.cancel();
        }

        public boolean isDisposed() {
            return this.cancelled;
        }

        @Override
        public boolean accept(Subscriber<? super U> a, U v) {
            this.actual.onNext(v);
            return true;
        }
    }
}

