/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.operators;

import hu.akarnokd.reactivestreams.extensions.RelaxedSubscriber;
import io.reactivex.common.Disposable;
import io.reactivex.common.RxJavaCommonPlugins;
import io.reactivex.common.exceptions.Exceptions;
import io.reactivex.common.exceptions.MissingBackpressureException;
import io.reactivex.common.functions.Function;
import io.reactivex.common.internal.disposables.DisposableHelper;
import io.reactivex.common.internal.functions.ObjectHelper;
import io.reactivex.flowable.Flowable;
import io.reactivex.flowable.internal.operators.AbstractFlowableWithUpstream;
import io.reactivex.flowable.internal.subscriptions.SubscriptionHelper;
import io.reactivex.flowable.internal.utils.BackpressureHelper;
import io.reactivex.flowable.subscribers.DisposableSubscriber;
import io.reactivex.flowable.subscribers.SerializedSubscriber;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableDebounce<T, U>
extends AbstractFlowableWithUpstream<T, T> {
    final Function<? super T, ? extends Publisher<U>> debounceSelector;

    public FlowableDebounce(Flowable<T> source, Function<? super T, ? extends Publisher<U>> debounceSelector) {
        super(source);
        this.debounceSelector = debounceSelector;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new DebounceSubscriber(new SerializedSubscriber<T>(s), this.debounceSelector));
    }

    static final class DebounceSubscriber<T, U>
    extends AtomicLong
    implements RelaxedSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = 6725975399620862591L;
        final Subscriber<? super T> actual;
        final Function<? super T, ? extends Publisher<U>> debounceSelector;
        Subscription s;
        final AtomicReference<Disposable> debouncer = new AtomicReference();
        volatile long index;
        boolean done;

        DebounceSubscriber(Subscriber<? super T> actual, Function<? super T, ? extends Publisher<U>> debounceSelector) {
            this.actual = actual;
            this.debounceSelector = debounceSelector;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            Publisher p;
            long idx;
            if (this.done) {
                return;
            }
            this.index = idx = this.index + 1L;
            Disposable d = this.debouncer.get();
            if (d != null) {
                d.dispose();
            }
            try {
                p = (Publisher)ObjectHelper.requireNonNull((Object)this.debounceSelector.apply(t), (String)"The publisher supplied is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                this.cancel();
                this.actual.onError(e);
                return;
            }
            DebounceInnerSubscriber dis = new DebounceInnerSubscriber(this, idx, t);
            if (this.debouncer.compareAndSet(d, dis)) {
                p.subscribe(dis);
            }
        }

        public void onError(Throwable t) {
            DisposableHelper.dispose(this.debouncer);
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            Disposable d = this.debouncer.get();
            if (!DisposableHelper.isDisposed((Disposable)d)) {
                DebounceInnerSubscriber dis = (DebounceInnerSubscriber)d;
                dis.emit();
                DisposableHelper.dispose(this.debouncer);
                this.actual.onComplete();
            }
        }

        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this, n);
            }
        }

        public void cancel() {
            this.s.cancel();
            DisposableHelper.dispose(this.debouncer);
        }

        void emit(long idx, T value) {
            if (idx == this.index) {
                long r = this.get();
                if (r != 0L) {
                    this.actual.onNext(value);
                    BackpressureHelper.produced(this, 1L);
                } else {
                    this.cancel();
                    this.actual.onError((Throwable)new MissingBackpressureException("Could not deliver value due to lack of requests"));
                }
            }
        }

        static final class DebounceInnerSubscriber<T, U>
        extends DisposableSubscriber<U> {
            final DebounceSubscriber<T, U> parent;
            final long index;
            final T value;
            boolean done;
            final AtomicBoolean once = new AtomicBoolean();

            DebounceInnerSubscriber(DebounceSubscriber<T, U> parent, long index, T value) {
                this.parent = parent;
                this.index = index;
                this.value = value;
            }

            public void onNext(U t) {
                if (this.done) {
                    return;
                }
                this.done = true;
                this.cancel();
                this.emit();
            }

            void emit() {
                if (this.once.compareAndSet(false, true)) {
                    this.parent.emit(this.index, this.value);
                }
            }

            public void onError(Throwable t) {
                if (this.done) {
                    RxJavaCommonPlugins.onError((Throwable)t);
                    return;
                }
                this.done = true;
                this.parent.onError(t);
            }

            public void onComplete() {
                if (this.done) {
                    return;
                }
                this.done = true;
                this.emit();
            }
        }
    }
}

