/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.operators;

import hu.akarnokd.reactivestreams.extensions.RelaxedSubscriber;
import io.reactivex.common.RxJavaCommonPlugins;
import io.reactivex.flowable.Flowable;
import io.reactivex.flowable.internal.subscriptions.SubscriptionArbiter;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableDelaySubscriptionOther<T, U>
extends Flowable<T> {
    final Publisher<? extends T> main;
    final Publisher<U> other;

    public FlowableDelaySubscriptionOther(Publisher<? extends T> main, Publisher<U> other) {
        this.main = main;
        this.other = other;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> child) {
        SubscriptionArbiter serial = new SubscriptionArbiter();
        child.onSubscribe((Subscription)serial);
        DelaySubscriber otherSubscriber = new DelaySubscriber(serial, child);
        this.other.subscribe((Subscriber)otherSubscriber);
    }

    final class DelaySubscriber
    implements RelaxedSubscriber<U> {
        final SubscriptionArbiter serial;
        final Subscriber<? super T> child;
        boolean done;

        DelaySubscriber(SubscriptionArbiter serial, Subscriber<? super T> child) {
            this.serial = serial;
            this.child = child;
        }

        public void onSubscribe(Subscription s) {
            this.serial.setSubscription(new DelaySubscription(s));
            s.request(Long.MAX_VALUE);
        }

        public void onNext(U t) {
            this.onComplete();
        }

        public void onError(Throwable e) {
            if (this.done) {
                RxJavaCommonPlugins.onError((Throwable)e);
                return;
            }
            this.done = true;
            this.child.onError(e);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            FlowableDelaySubscriptionOther.this.main.subscribe((Subscriber)new OnCompleteSubscriber());
        }

        final class OnCompleteSubscriber
        implements RelaxedSubscriber<T> {
            OnCompleteSubscriber() {
            }

            public void onSubscribe(Subscription s) {
                DelaySubscriber.this.serial.setSubscription(s);
            }

            public void onNext(T t) {
                DelaySubscriber.this.child.onNext(t);
            }

            public void onError(Throwable t) {
                DelaySubscriber.this.child.onError(t);
            }

            public void onComplete() {
                DelaySubscriber.this.child.onComplete();
            }
        }

        final class DelaySubscription
        implements Subscription {
            private final Subscription s;

            DelaySubscription(Subscription s) {
                this.s = s;
            }

            public void request(long n) {
            }

            public void cancel() {
                this.s.cancel();
            }
        }
    }
}

