/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.operators;

import hu.akarnokd.reactivestreams.extensions.ConditionalSubscriber;
import io.reactivex.common.annotations.Nullable;
import io.reactivex.common.functions.BiPredicate;
import io.reactivex.common.functions.Function;
import io.reactivex.flowable.Flowable;
import io.reactivex.flowable.internal.operators.AbstractFlowableWithUpstream;
import io.reactivex.flowable.internal.subscribers.BasicFuseableConditionalSubscriber;
import io.reactivex.flowable.internal.subscribers.BasicFuseableSubscriber;
import org.reactivestreams.Subscriber;

public final class FlowableDistinctUntilChanged<T, K>
extends AbstractFlowableWithUpstream<T, T> {
    final Function<? super T, K> keySelector;
    final BiPredicate<? super K, ? super K> comparer;

    public FlowableDistinctUntilChanged(Flowable<T> source, Function<? super T, K> keySelector, BiPredicate<? super K, ? super K> comparer) {
        super(source);
        this.keySelector = keySelector;
        this.comparer = comparer;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        if (s instanceof ConditionalSubscriber) {
            ConditionalSubscriber cs = (ConditionalSubscriber)s;
            this.source.subscribe(new DistinctUntilChangedConditionalSubscriber<T, K>(cs, this.keySelector, this.comparer));
        } else {
            this.source.subscribe(new DistinctUntilChangedSubscriber<T, K>(s, this.keySelector, this.comparer));
        }
    }

    static final class DistinctUntilChangedConditionalSubscriber<T, K>
    extends BasicFuseableConditionalSubscriber<T, T> {
        final Function<? super T, K> keySelector;
        final BiPredicate<? super K, ? super K> comparer;
        K last;
        boolean hasValue;

        DistinctUntilChangedConditionalSubscriber(ConditionalSubscriber<? super T> actual, Function<? super T, K> keySelector, BiPredicate<? super K, ? super K> comparer) {
            super(actual);
            this.keySelector = keySelector;
            this.comparer = comparer;
        }

        public void onNext(T t) {
            if (!this.tryOnNext(t)) {
                this.s.request(1L);
            }
        }

        public boolean tryOnNext(T t) {
            if (this.done) {
                return false;
            }
            if (this.sourceMode != 0) {
                return this.actual.tryOnNext(t);
            }
            try {
                Object key = this.keySelector.apply(t);
                if (this.hasValue) {
                    boolean equal = this.comparer.test(this.last, key);
                    this.last = key;
                    if (equal) {
                        return false;
                    }
                } else {
                    this.hasValue = true;
                    this.last = key;
                }
            }
            catch (Throwable ex) {
                this.fail(ex);
                return true;
            }
            this.actual.onNext(t);
            return true;
        }

        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        @Nullable
        public T poll() throws Throwable {
            Object v;
            while ((v = this.qs.poll()) != null) {
                Object key = this.keySelector.apply(v);
                if (!this.hasValue) {
                    this.hasValue = true;
                    this.last = key;
                    return (T)v;
                }
                if (!this.comparer.test(this.last, key)) {
                    this.last = key;
                    return (T)v;
                }
                this.last = key;
                if (this.sourceMode == 1) continue;
                this.s.request(1L);
            }
            return null;
        }
    }

    static final class DistinctUntilChangedSubscriber<T, K>
    extends BasicFuseableSubscriber<T, T>
    implements ConditionalSubscriber<T> {
        final Function<? super T, K> keySelector;
        final BiPredicate<? super K, ? super K> comparer;
        K last;
        boolean hasValue;

        DistinctUntilChangedSubscriber(Subscriber<? super T> actual, Function<? super T, K> keySelector, BiPredicate<? super K, ? super K> comparer) {
            super(actual);
            this.keySelector = keySelector;
            this.comparer = comparer;
        }

        public void onNext(T t) {
            if (!this.tryOnNext(t)) {
                this.s.request(1L);
            }
        }

        public boolean tryOnNext(T t) {
            if (this.done) {
                return false;
            }
            if (this.sourceMode != 0) {
                this.actual.onNext(t);
                return true;
            }
            try {
                Object key = this.keySelector.apply(t);
                if (this.hasValue) {
                    boolean equal = this.comparer.test(this.last, key);
                    this.last = key;
                    if (equal) {
                        return false;
                    }
                } else {
                    this.hasValue = true;
                    this.last = key;
                }
            }
            catch (Throwable ex) {
                this.fail(ex);
                return true;
            }
            this.actual.onNext(t);
            return true;
        }

        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        @Nullable
        public T poll() throws Throwable {
            Object v;
            while ((v = this.qs.poll()) != null) {
                Object key = this.keySelector.apply(v);
                if (!this.hasValue) {
                    this.hasValue = true;
                    this.last = key;
                    return (T)v;
                }
                if (!this.comparer.test(this.last, key)) {
                    this.last = key;
                    return (T)v;
                }
                this.last = key;
                if (this.sourceMode == 1) continue;
                this.s.request(1L);
            }
            return null;
        }
    }
}

