/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.operators;

import hu.akarnokd.reactivestreams.extensions.ConditionalSubscriber;
import io.reactivex.common.annotations.Nullable;
import io.reactivex.common.functions.Consumer;
import io.reactivex.flowable.Flowable;
import io.reactivex.flowable.internal.operators.AbstractFlowableWithUpstream;
import io.reactivex.flowable.internal.subscribers.BasicFuseableConditionalSubscriber;
import io.reactivex.flowable.internal.subscribers.BasicFuseableSubscriber;
import org.reactivestreams.Subscriber;

public final class FlowableDoAfterNext<T>
extends AbstractFlowableWithUpstream<T, T> {
    final Consumer<? super T> onAfterNext;

    public FlowableDoAfterNext(Flowable<T> source, Consumer<? super T> onAfterNext) {
        super(source);
        this.onAfterNext = onAfterNext;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        if (s instanceof ConditionalSubscriber) {
            this.source.subscribe(new DoAfterConditionalSubscriber<T>((ConditionalSubscriber)s, this.onAfterNext));
        } else {
            this.source.subscribe(new DoAfterSubscriber<T>(s, this.onAfterNext));
        }
    }

    static final class DoAfterConditionalSubscriber<T>
    extends BasicFuseableConditionalSubscriber<T, T> {
        final Consumer<? super T> onAfterNext;

        DoAfterConditionalSubscriber(ConditionalSubscriber<? super T> actual, Consumer<? super T> onAfterNext) {
            super(actual);
            this.onAfterNext = onAfterNext;
        }

        public void onNext(T t) {
            this.actual.onNext(t);
            if (this.sourceMode == 0) {
                try {
                    this.onAfterNext.accept(t);
                }
                catch (Throwable ex) {
                    this.fail(ex);
                }
            }
        }

        public boolean tryOnNext(T t) {
            boolean b = this.actual.tryOnNext(t);
            try {
                this.onAfterNext.accept(t);
            }
            catch (Throwable ex) {
                this.fail(ex);
            }
            return b;
        }

        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        @Nullable
        public T poll() throws Throwable {
            Object v = this.qs.poll();
            if (v != null) {
                this.onAfterNext.accept(v);
            }
            return (T)v;
        }
    }

    static final class DoAfterSubscriber<T>
    extends BasicFuseableSubscriber<T, T> {
        final Consumer<? super T> onAfterNext;

        DoAfterSubscriber(Subscriber<? super T> actual, Consumer<? super T> onAfterNext) {
            super(actual);
            this.onAfterNext = onAfterNext;
        }

        public void onNext(T t) {
            if (this.done) {
                return;
            }
            this.actual.onNext(t);
            if (this.sourceMode == 0) {
                try {
                    this.onAfterNext.accept(t);
                }
                catch (Throwable ex) {
                    this.fail(ex);
                }
            }
        }

        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        @Nullable
        public T poll() throws Throwable {
            Object v = this.qs.poll();
            if (v != null) {
                this.onAfterNext.accept(v);
            }
            return (T)v;
        }
    }
}

