/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.operators;

import hu.akarnokd.reactivestreams.extensions.FusedQueue;
import hu.akarnokd.reactivestreams.extensions.FusedQueueSubscription;
import hu.akarnokd.reactivestreams.extensions.RelaxedSubscriber;
import io.reactivex.common.Disposable;
import io.reactivex.common.RxJavaCommonPlugins;
import io.reactivex.common.exceptions.Exceptions;
import io.reactivex.common.exceptions.MissingBackpressureException;
import io.reactivex.common.functions.Function;
import io.reactivex.common.internal.functions.ObjectHelper;
import io.reactivex.common.internal.utils.AtomicThrowable;
import io.reactivex.common.internal.utils.ExceptionHelper;
import io.reactivex.flowable.Flowable;
import io.reactivex.flowable.internal.operators.AbstractFlowableWithUpstream;
import io.reactivex.flowable.internal.operators.FlowableScalarXMap;
import io.reactivex.flowable.internal.queues.SimplePlainQueue;
import io.reactivex.flowable.internal.queues.SpscArrayQueue;
import io.reactivex.flowable.internal.queues.SpscLinkedArrayQueue;
import io.reactivex.flowable.internal.subscriptions.SubscriptionHelper;
import io.reactivex.flowable.internal.utils.BackpressureHelper;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableFlatMap<T, U>
extends AbstractFlowableWithUpstream<T, U> {
    final Function<? super T, ? extends Publisher<? extends U>> mapper;
    final boolean delayErrors;
    final int maxConcurrency;
    final int bufferSize;

    public FlowableFlatMap(Flowable<T> source, Function<? super T, ? extends Publisher<? extends U>> mapper, boolean delayErrors, int maxConcurrency, int bufferSize) {
        super(source);
        this.mapper = mapper;
        this.delayErrors = delayErrors;
        this.maxConcurrency = maxConcurrency;
        this.bufferSize = bufferSize;
    }

    @Override
    protected void subscribeActual(Subscriber<? super U> s) {
        if (FlowableScalarXMap.tryScalarXMapSubscribe(this.source, s, this.mapper)) {
            return;
        }
        this.source.subscribe(FlowableFlatMap.subscribe(s, this.mapper, this.delayErrors, this.maxConcurrency, this.bufferSize));
    }

    public static <T, U> RelaxedSubscriber<T> subscribe(Subscriber<? super U> s, Function<? super T, ? extends Publisher<? extends U>> mapper, boolean delayErrors, int maxConcurrency, int bufferSize) {
        return new MergeSubscriber<T, U>(s, mapper, delayErrors, maxConcurrency, bufferSize);
    }

    static final class InnerSubscriber<T, U>
    extends AtomicReference<Subscription>
    implements RelaxedSubscriber<U>,
    Disposable {
        private static final long serialVersionUID = -4606175640614850599L;
        final long id;
        final MergeSubscriber<T, U> parent;
        final int limit;
        final int bufferSize;
        volatile boolean done;
        volatile FusedQueue<U> queue;
        long produced;
        int fusionMode;

        InnerSubscriber(MergeSubscriber<T, U> parent, long id) {
            this.id = id;
            this.parent = parent;
            this.bufferSize = parent.bufferSize;
            this.limit = this.bufferSize >> 2;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.setOnce(this, s)) {
                if (s instanceof FusedQueueSubscription) {
                    FusedQueueSubscription qs = (FusedQueueSubscription)s;
                    int m = qs.requestFusion(7);
                    if (m == 1) {
                        this.fusionMode = m;
                        this.queue = qs;
                        this.done = true;
                        this.parent.drain();
                        return;
                    }
                    if (m == 2) {
                        this.fusionMode = m;
                        this.queue = qs;
                    }
                }
                s.request((long)this.bufferSize);
            }
        }

        public void onNext(U t) {
            if (this.fusionMode != 2) {
                this.parent.tryEmit(t, this);
            } else {
                this.parent.drain();
            }
        }

        public void onError(Throwable t) {
            this.lazySet(SubscriptionHelper.CANCELLED);
            this.parent.innerError(this, t);
        }

        public void onComplete() {
            this.done = true;
            this.parent.drain();
        }

        void requestMore(long n) {
            if (this.fusionMode != 1) {
                long p = this.produced + n;
                if (p >= (long)this.limit) {
                    this.produced = 0L;
                    ((Subscription)this.get()).request(p);
                } else {
                    this.produced = p;
                }
            }
        }

        public void dispose() {
            SubscriptionHelper.cancel(this);
        }

        public boolean isDisposed() {
            return this.get() == SubscriptionHelper.CANCELLED;
        }
    }

    static final class MergeSubscriber<T, U>
    extends AtomicInteger
    implements RelaxedSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = -2117620485640801370L;
        final Subscriber<? super U> actual;
        final Function<? super T, ? extends Publisher<? extends U>> mapper;
        final boolean delayErrors;
        final int maxConcurrency;
        final int bufferSize;
        volatile SimplePlainQueue<U> queue;
        volatile boolean done;
        final AtomicThrowable errs = new AtomicThrowable();
        volatile boolean cancelled;
        final AtomicReference<InnerSubscriber<?, ?>[]> subscribers = new AtomicReference();
        static final InnerSubscriber<?, ?>[] EMPTY = new InnerSubscriber[0];
        static final InnerSubscriber<?, ?>[] CANCELLED = new InnerSubscriber[0];
        final AtomicLong requested = new AtomicLong();
        Subscription s;
        long uniqueId;
        long lastId;
        int lastIndex;
        int scalarEmitted;
        final int scalarLimit;

        MergeSubscriber(Subscriber<? super U> actual, Function<? super T, ? extends Publisher<? extends U>> mapper, boolean delayErrors, int maxConcurrency, int bufferSize) {
            this.actual = actual;
            this.mapper = mapper;
            this.delayErrors = delayErrors;
            this.maxConcurrency = maxConcurrency;
            this.bufferSize = bufferSize;
            this.scalarLimit = Math.max(1, maxConcurrency >> 1);
            this.subscribers.lazySet(EMPTY);
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                if (!this.cancelled) {
                    if (this.maxConcurrency == Integer.MAX_VALUE) {
                        s.request(Long.MAX_VALUE);
                    } else {
                        s.request((long)this.maxConcurrency);
                    }
                }
            }
        }

        public void onNext(T t) {
            InnerSubscriber inner;
            Publisher p;
            if (this.done) {
                return;
            }
            try {
                p = (Publisher)ObjectHelper.requireNonNull((Object)this.mapper.apply(t), (String)"The mapper returned a null Publisher");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                this.s.cancel();
                this.onError(e);
                return;
            }
            if (p instanceof Callable) {
                Object u;
                try {
                    u = ((Callable)p).call();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    this.errs.addThrowable(ex);
                    this.drain();
                    return;
                }
                if (u != null) {
                    this.tryEmitScalar(u);
                } else if (this.maxConcurrency != Integer.MAX_VALUE && !this.cancelled && ++this.scalarEmitted == this.scalarLimit) {
                    this.scalarEmitted = 0;
                    this.s.request((long)this.scalarLimit);
                }
            } else if (this.addInner(inner = new InnerSubscriber(this, this.uniqueId++))) {
                p.subscribe(inner);
            }
        }

        boolean addInner(InnerSubscriber<T, U> inner) {
            InnerSubscriber[] b;
            InnerSubscriber<?, ?>[] a;
            do {
                if ((a = this.subscribers.get()) == CANCELLED) {
                    inner.dispose();
                    return false;
                }
                int n = a.length;
                b = new InnerSubscriber[n + 1];
                System.arraycopy(a, 0, b, 0, n);
                b[n] = inner;
            } while (!this.subscribers.compareAndSet(a, b));
            return true;
        }

        void removeInner(InnerSubscriber<T, U> inner) {
            InnerSubscriber<?, ?>[] b;
            InnerSubscriber<?, ?>[] a;
            do {
                if ((a = this.subscribers.get()) == CANCELLED || a == EMPTY) {
                    return;
                }
                int n = a.length;
                int j = -1;
                for (int i = 0; i < n; ++i) {
                    if (a[i] != inner) continue;
                    j = i;
                    break;
                }
                if (j < 0) {
                    return;
                }
                if (n == 1) {
                    b = EMPTY;
                    continue;
                }
                b = new InnerSubscriber[n - 1];
                System.arraycopy(a, 0, b, 0, j);
                System.arraycopy(a, j + 1, b, j, n - j - 1);
            } while (!this.subscribers.compareAndSet(a, b));
        }

        FusedQueue<U> getMainQueue() {
            SimplePlainQueue<U> q = this.queue;
            if (q == null) {
                q = this.maxConcurrency == Integer.MAX_VALUE ? new SpscLinkedArrayQueue<U>(this.bufferSize) : new SpscArrayQueue<U>(this.maxConcurrency);
                this.queue = q;
            }
            return q;
        }

        void tryEmitScalar(U value) {
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                long r = this.requested.get();
                SimplePlainQueue<U> q = this.queue;
                if (r != 0L && (q == null || q.isEmpty())) {
                    this.actual.onNext(value);
                    if (r != Long.MAX_VALUE) {
                        this.requested.decrementAndGet();
                    }
                    if (this.maxConcurrency != Integer.MAX_VALUE && !this.cancelled && ++this.scalarEmitted == this.scalarLimit) {
                        this.scalarEmitted = 0;
                        this.s.request((long)this.scalarLimit);
                    }
                } else {
                    if (q == null) {
                        q = this.getMainQueue();
                    }
                    if (!q.offer(value)) {
                        this.onError(new IllegalStateException("Scalar queue full?!"));
                        return;
                    }
                }
                if (this.decrementAndGet() == 0) {
                    return;
                }
            } else {
                FusedQueue<U> q = this.getMainQueue();
                if (!q.offer(value)) {
                    this.onError(new IllegalStateException("Scalar queue full?!"));
                    return;
                }
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        FusedQueue<U> getInnerQueue(InnerSubscriber<T, U> inner) {
            FusedQueue q = inner.queue;
            if (q == null) {
                inner.queue = q = new SpscArrayQueue(this.bufferSize);
            }
            return q;
        }

        void tryEmit(U value, InnerSubscriber<T, U> inner) {
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                long r = this.requested.get();
                FusedQueue q = inner.queue;
                if (r != 0L && (q == null || q.isEmpty())) {
                    this.actual.onNext(value);
                    if (r != Long.MAX_VALUE) {
                        this.requested.decrementAndGet();
                    }
                    inner.requestMore(1L);
                } else {
                    if (q == null) {
                        q = this.getInnerQueue(inner);
                    }
                    if (!q.offer(value)) {
                        this.onError((Throwable)new MissingBackpressureException("Inner queue full?!"));
                        return;
                    }
                }
                if (this.decrementAndGet() == 0) {
                    return;
                }
            } else {
                FusedQueue q = inner.queue;
                if (q == null) {
                    inner.queue = q = new SpscArrayQueue(this.bufferSize);
                }
                if (!q.offer(value)) {
                    this.onError((Throwable)new MissingBackpressureException("Inner queue full?!"));
                    return;
                }
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        public void onError(Throwable t) {
            if (this.done) {
                RxJavaCommonPlugins.onError((Throwable)t);
                return;
            }
            if (this.errs.addThrowable(t)) {
                this.done = true;
                this.drain();
            } else {
                RxJavaCommonPlugins.onError((Throwable)t);
            }
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.drain();
        }

        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
                this.drain();
            }
        }

        public void cancel() {
            if (!this.cancelled) {
                SimplePlainQueue<U> q;
                this.cancelled = true;
                this.s.cancel();
                this.disposeAll();
                if (this.getAndIncrement() == 0 && (q = this.queue) != null) {
                    q.clear();
                }
            }
        }

        void drain() {
            if (this.getAndIncrement() == 0) {
                this.drainLoop();
            }
        }

        void drainLoop() {
            boolean innerCompleted;
            Subscriber<? super U> child = this.actual;
            int missed = 1;
            do {
                if (this.checkTerminate()) {
                    return;
                }
                SimplePlainQueue<U> svq = this.queue;
                long r = this.requested.get();
                boolean unbounded = r == Long.MAX_VALUE;
                long replenishMain = 0L;
                if (svq != null) {
                    Object o;
                    do {
                        long scalarEmission = 0L;
                        o = null;
                        while (r != 0L) {
                            o = svq.poll();
                            if (this.checkTerminate()) {
                                return;
                            }
                            if (o == null) break;
                            child.onNext(o);
                            ++replenishMain;
                            ++scalarEmission;
                            --r;
                        }
                        if (scalarEmission == 0L) continue;
                        r = unbounded ? Long.MAX_VALUE : this.requested.addAndGet(-scalarEmission);
                    } while (r != 0L && o != null);
                }
                boolean d = this.done;
                svq = this.queue;
                InnerSubscriber<?, ?>[] inner = this.subscribers.get();
                int n = inner.length;
                if (d && (svq == null || svq.isEmpty()) && n == 0) {
                    Throwable ex = this.errs.terminate();
                    if (ex != ExceptionHelper.TERMINATED) {
                        if (ex == null) {
                            child.onComplete();
                        } else {
                            child.onError(ex);
                        }
                    }
                    return;
                }
                innerCompleted = false;
                if (n != 0) {
                    int i;
                    int j;
                    long startId = this.lastId;
                    int index = this.lastIndex;
                    if (n <= index || inner[index].id != startId) {
                        if (n <= index) {
                            index = 0;
                        }
                        j = index;
                        for (i = 0; i < n && inner[j].id != startId; ++i) {
                            if (++j != n) continue;
                            j = 0;
                        }
                        index = j;
                        this.lastIndex = j;
                        this.lastId = inner[j].id;
                    }
                    j = index;
                    block6: for (i = 0; i < n; ++i) {
                        if (this.checkTerminate()) {
                            return;
                        }
                        InnerSubscriber<?, ?> is = inner[j];
                        Object o = null;
                        do {
                            if (this.checkTerminate()) {
                                return;
                            }
                            FusedQueue q = is.queue;
                            if (q == null) break;
                            long produced = 0L;
                            while (r != 0L) {
                                try {
                                    o = q.poll();
                                }
                                catch (Throwable ex) {
                                    Exceptions.throwIfFatal((Throwable)ex);
                                    is.dispose();
                                    this.errs.addThrowable(ex);
                                    if (this.checkTerminate()) {
                                        return;
                                    }
                                    this.removeInner(is);
                                    innerCompleted = true;
                                    ++i;
                                    continue block6;
                                }
                                if (o == null) break;
                                child.onNext(o);
                                if (this.checkTerminate()) {
                                    return;
                                }
                                --r;
                                ++produced;
                            }
                            if (produced == 0L) continue;
                            r = !unbounded ? this.requested.addAndGet(-produced) : Long.MAX_VALUE;
                            is.requestMore(produced);
                        } while (r != 0L && o != null);
                        boolean innerDone = is.done;
                        FusedQueue innerQueue = is.queue;
                        if (innerDone && (innerQueue == null || innerQueue.isEmpty())) {
                            this.removeInner(is);
                            if (this.checkTerminate()) {
                                return;
                            }
                            ++replenishMain;
                            innerCompleted = true;
                        }
                        if (r == 0L) break;
                        if (++j != n) continue;
                        j = 0;
                    }
                    this.lastIndex = j;
                    this.lastId = inner[j].id;
                }
                if (replenishMain == 0L || this.cancelled) continue;
                this.s.request(replenishMain);
            } while (innerCompleted || (missed = this.addAndGet(-missed)) != 0);
        }

        boolean checkTerminate() {
            if (this.cancelled) {
                this.clearScalarQueue();
                return true;
            }
            if (!this.delayErrors && this.errs.get() != null) {
                this.clearScalarQueue();
                Throwable ex = this.errs.terminate();
                if (ex != ExceptionHelper.TERMINATED) {
                    this.actual.onError(ex);
                }
                return true;
            }
            return false;
        }

        void clearScalarQueue() {
            SimplePlainQueue<U> q = this.queue;
            if (q != null) {
                q.clear();
            }
        }

        void disposeAll() {
            InnerSubscriber<?, ?>[] a = this.subscribers.get();
            if (a != CANCELLED && (a = this.subscribers.getAndSet(CANCELLED)) != CANCELLED) {
                for (InnerSubscriber<?, ?> inner : a) {
                    inner.dispose();
                }
                Throwable ex = this.errs.terminate();
                if (ex != null && ex != ExceptionHelper.TERMINATED) {
                    RxJavaCommonPlugins.onError((Throwable)ex);
                }
            }
        }

        void innerError(InnerSubscriber<T, U> inner, Throwable t) {
            if (this.errs.addThrowable(t)) {
                inner.done = true;
                if (!this.delayErrors) {
                    this.s.cancel();
                    for (InnerSubscriber<?, ?> a : this.subscribers.getAndSet(CANCELLED)) {
                        a.dispose();
                    }
                }
                this.drain();
            } else {
                RxJavaCommonPlugins.onError((Throwable)t);
            }
        }
    }
}

