/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.operators;

import io.reactivex.common.exceptions.CompositeException;
import io.reactivex.common.exceptions.Exceptions;
import io.reactivex.common.functions.Function;
import io.reactivex.common.internal.functions.ObjectHelper;
import io.reactivex.flowable.Flowable;
import io.reactivex.flowable.internal.operators.AbstractFlowableWithUpstream;
import io.reactivex.flowable.internal.subscribers.SinglePostCompleteSubscriber;
import org.reactivestreams.Subscriber;

public final class FlowableOnErrorReturn<T>
extends AbstractFlowableWithUpstream<T, T> {
    final Function<? super Throwable, ? extends T> valueSupplier;

    public FlowableOnErrorReturn(Flowable<T> source, Function<? super Throwable, ? extends T> valueSupplier) {
        super(source);
        this.valueSupplier = valueSupplier;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new OnErrorReturnSubscriber<T>(s, this.valueSupplier));
    }

    static final class OnErrorReturnSubscriber<T>
    extends SinglePostCompleteSubscriber<T, T> {
        private static final long serialVersionUID = -3740826063558713822L;
        final Function<? super Throwable, ? extends T> valueSupplier;

        OnErrorReturnSubscriber(Subscriber<? super T> actual, Function<? super Throwable, ? extends T> valueSupplier) {
            super(actual);
            this.valueSupplier = valueSupplier;
        }

        public void onNext(T t) {
            ++this.produced;
            this.actual.onNext(t);
        }

        public void onError(Throwable t) {
            Object v;
            try {
                v = ObjectHelper.requireNonNull((Object)this.valueSupplier.apply((Object)t), (String)"The valueSupplier returned a null value");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.actual.onError((Throwable)new CompositeException(new Throwable[]{t, ex}));
                return;
            }
            this.complete(v);
        }

        public void onComplete() {
            this.actual.onComplete();
        }
    }
}

