/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.operators;

import hu.akarnokd.reactivestreams.extensions.FusedQueue;
import hu.akarnokd.reactivestreams.extensions.FusedQueueSubscription;
import hu.akarnokd.reactivestreams.extensions.RelaxedSubscriber;
import io.reactivex.common.Disposable;
import io.reactivex.common.RxJavaCommonPlugins;
import io.reactivex.common.exceptions.Exceptions;
import io.reactivex.common.exceptions.MissingBackpressureException;
import io.reactivex.common.functions.Consumer;
import io.reactivex.common.internal.utils.ExceptionHelper;
import io.reactivex.flowable.ConnectableFlowable;
import io.reactivex.flowable.Flowable;
import io.reactivex.flowable.RxJavaFlowablePlugins;
import io.reactivex.flowable.extensions.HasUpstreamPublisher;
import io.reactivex.flowable.internal.queues.SpscArrayQueue;
import io.reactivex.flowable.internal.subscriptions.SubscriptionHelper;
import io.reactivex.flowable.internal.utils.BackpressureHelper;
import io.reactivex.flowable.internal.utils.NotificationLite;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowablePublish<T>
extends ConnectableFlowable<T>
implements HasUpstreamPublisher<T> {
    static final long CANCELLED = Long.MIN_VALUE;
    final Flowable<T> source;
    final AtomicReference<PublishSubscriber<T>> current;
    final int bufferSize;
    final Publisher<T> onSubscribe;

    public static <T> ConnectableFlowable<T> create(Flowable<T> source, int bufferSize) {
        AtomicReference curr = new AtomicReference();
        FlowablePublisher onSubscribe = new FlowablePublisher(curr, bufferSize);
        return RxJavaFlowablePlugins.onAssembly(new FlowablePublish(onSubscribe, source, curr, bufferSize));
    }

    private FlowablePublish(Publisher<T> onSubscribe, Flowable<T> source, AtomicReference<PublishSubscriber<T>> current, int bufferSize) {
        this.onSubscribe = onSubscribe;
        this.source = source;
        this.current = current;
        this.bufferSize = bufferSize;
    }

    @Override
    public Publisher<T> source() {
        return this.source;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.onSubscribe.subscribe(s);
    }

    @Override
    public void connect(Consumer<? super Disposable> connection) {
        PublishSubscriber<T> ps;
        while ((ps = this.current.get()) == null || ps.isDisposed()) {
            PublishSubscriber<T> u = new PublishSubscriber<T>(this.current, this.bufferSize);
            if (!this.current.compareAndSet(ps, u)) continue;
            ps = u;
            break;
        }
        boolean doConnect = !ps.shouldConnect.get() && ps.shouldConnect.compareAndSet(false, true);
        try {
            connection.accept(ps);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal((Throwable)ex);
            throw ExceptionHelper.wrapOrThrow((Throwable)ex);
        }
        if (doConnect) {
            this.source.subscribe(ps);
        }
    }

    static final class FlowablePublisher<T>
    implements Publisher<T> {
        private final AtomicReference<PublishSubscriber<T>> curr;
        private final int bufferSize;

        FlowablePublisher(AtomicReference<PublishSubscriber<T>> curr, int bufferSize) {
            this.curr = curr;
            this.bufferSize = bufferSize;
        }

        public void subscribe(Subscriber<? super T> child) {
            PublishSubscriber<Object> r;
            InnerSubscriber<T> inner = new InnerSubscriber<T>(child);
            child.onSubscribe(inner);
            while (true) {
                if ((r = this.curr.get()) == null || r.isDisposed()) {
                    PublishSubscriber<T> u = new PublishSubscriber<T>(this.curr, this.bufferSize);
                    if (!this.curr.compareAndSet(r, u)) continue;
                    r = u;
                }
                if (r.add(inner)) break;
            }
            if (inner.get() == Long.MIN_VALUE) {
                r.remove(inner);
            } else {
                inner.parent = r;
            }
            r.dispatch();
        }
    }

    static final class InnerSubscriber<T>
    extends AtomicLong
    implements Subscription {
        private static final long serialVersionUID = -4453897557930727610L;
        final Subscriber<? super T> child;
        volatile PublishSubscriber<T> parent;

        InnerSubscriber(Subscriber<? super T> child) {
            this.child = child;
        }

        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.addCancel(this, n);
                PublishSubscriber<T> p = this.parent;
                if (p != null) {
                    p.dispatch();
                }
            }
        }

        public long produced(long n) {
            return BackpressureHelper.producedCancel(this, n);
        }

        public void cancel() {
            PublishSubscriber<T> p;
            long r = this.get();
            if (r != Long.MIN_VALUE && (r = this.getAndSet(Long.MIN_VALUE)) != Long.MIN_VALUE && (p = this.parent) != null) {
                p.remove(this);
                p.dispatch();
            }
        }
    }

    static final class PublishSubscriber<T>
    extends AtomicInteger
    implements RelaxedSubscriber<T>,
    Disposable {
        private static final long serialVersionUID = -202316842419149694L;
        static final InnerSubscriber[] EMPTY = new InnerSubscriber[0];
        static final InnerSubscriber[] TERMINATED = new InnerSubscriber[0];
        final AtomicReference<PublishSubscriber<T>> current;
        final int bufferSize;
        final AtomicReference<InnerSubscriber[]> subscribers;
        final AtomicBoolean shouldConnect;
        final AtomicReference<Subscription> s = new AtomicReference();
        volatile Object terminalEvent;
        int sourceMode;
        volatile FusedQueue<T> queue;

        PublishSubscriber(AtomicReference<PublishSubscriber<T>> current, int bufferSize) {
            this.subscribers = new AtomicReference<InnerSubscriber[]>(EMPTY);
            this.current = current;
            this.shouldConnect = new AtomicBoolean();
            this.bufferSize = bufferSize;
        }

        public void dispose() {
            InnerSubscriber[] ps;
            if (this.subscribers.get() != TERMINATED && (ps = this.subscribers.getAndSet(TERMINATED)) != TERMINATED) {
                this.current.compareAndSet(this, null);
                SubscriptionHelper.cancel(this.s);
            }
        }

        public boolean isDisposed() {
            return this.subscribers.get() == TERMINATED;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.setOnce(this.s, s)) {
                if (s instanceof FusedQueueSubscription) {
                    FusedQueueSubscription qs = (FusedQueueSubscription)s;
                    int m = qs.requestFusion(3);
                    if (m == 1) {
                        this.sourceMode = m;
                        this.queue = qs;
                        this.terminalEvent = NotificationLite.complete();
                        this.dispatch();
                        return;
                    }
                    if (m == 2) {
                        this.sourceMode = m;
                        this.queue = qs;
                        s.request((long)this.bufferSize);
                        return;
                    }
                }
                this.queue = new SpscArrayQueue<T>(this.bufferSize);
                s.request((long)this.bufferSize);
            }
        }

        public void onNext(T t) {
            if (this.sourceMode == 0 && !this.queue.offer(t)) {
                this.onError((Throwable)new MissingBackpressureException("Prefetch queue is full?!"));
                return;
            }
            this.dispatch();
        }

        public void onError(Throwable e) {
            if (this.terminalEvent == null) {
                this.terminalEvent = NotificationLite.error(e);
                this.dispatch();
            } else {
                RxJavaCommonPlugins.onError((Throwable)e);
            }
        }

        public void onComplete() {
            if (this.terminalEvent == null) {
                this.terminalEvent = NotificationLite.complete();
                this.dispatch();
            }
        }

        boolean add(InnerSubscriber<T> producer) {
            InnerSubscriber[] u;
            InnerSubscriber[] c;
            do {
                if ((c = this.subscribers.get()) == TERMINATED) {
                    return false;
                }
                int len = c.length;
                u = new InnerSubscriber[len + 1];
                System.arraycopy(c, 0, u, 0, len);
                u[len] = producer;
            } while (!this.subscribers.compareAndSet(c, u));
            return true;
        }

        void remove(InnerSubscriber<T> producer) {
            InnerSubscriber[] c;
            int len;
            while ((len = (c = this.subscribers.get()).length) != 0) {
                InnerSubscriber[] u;
                int j = -1;
                for (int i = 0; i < len; ++i) {
                    if (!c[i].equals(producer)) continue;
                    j = i;
                    break;
                }
                if (j < 0) {
                    return;
                }
                if (len == 1) {
                    u = EMPTY;
                } else {
                    u = new InnerSubscriber[len - 1];
                    System.arraycopy(c, 0, u, 0, j);
                    System.arraycopy(c, j + 1, u, j, len - j - 1);
                }
                if (!this.subscribers.compareAndSet(c, u)) continue;
                break;
            }
        }

        boolean checkTerminated(Object term, boolean empty) {
            if (term != null) {
                if (NotificationLite.isComplete(term)) {
                    if (empty) {
                        this.current.compareAndSet(this, null);
                        for (InnerSubscriber ip : this.subscribers.getAndSet(TERMINATED)) {
                            ip.child.onComplete();
                        }
                        return true;
                    }
                } else {
                    Throwable t = NotificationLite.getError(term);
                    this.current.compareAndSet(this, null);
                    InnerSubscriber[] a = this.subscribers.getAndSet(TERMINATED);
                    if (a.length != 0) {
                        for (InnerSubscriber ip : a) {
                            ip.child.onError(t);
                        }
                    } else {
                        RxJavaCommonPlugins.onError((Throwable)t);
                    }
                    return true;
                }
            }
            return false;
        }

        void dispatch() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            while (true) {
                boolean empty;
                Object term = this.terminalEvent;
                FusedQueue<T> q = this.queue;
                boolean bl = empty = q == null || q.isEmpty();
                if (this.checkTerminated(term, empty)) {
                    return;
                }
                if (!empty) {
                    InnerSubscriber[] ps = this.subscribers.get();
                    int len = ps.length;
                    long maxRequested = Long.MAX_VALUE;
                    int cancelled = 0;
                    for (InnerSubscriber ip : ps) {
                        long r = ip.get();
                        if (r >= 0L) {
                            maxRequested = Math.min(maxRequested, r);
                            continue;
                        }
                        if (r != Long.MIN_VALUE) continue;
                        ++cancelled;
                    }
                    if (len == cancelled) {
                        Object v;
                        term = this.terminalEvent;
                        try {
                            v = q.poll();
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal((Throwable)ex);
                            this.s.get().cancel();
                            this.terminalEvent = term = NotificationLite.error(ex);
                            v = null;
                        }
                        if (this.checkTerminated(term, v == null)) {
                            return;
                        }
                        if (this.sourceMode == 1) continue;
                        this.s.get().request(1L);
                        continue;
                    }
                    int d = 0;
                    while ((long)d < maxRequested) {
                        Object v;
                        term = this.terminalEvent;
                        try {
                            v = q.poll();
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal((Throwable)ex);
                            this.s.get().cancel();
                            this.terminalEvent = term = NotificationLite.error(ex);
                            v = null;
                        }
                        boolean bl2 = empty = v == null;
                        if (this.checkTerminated(term, empty)) {
                            return;
                        }
                        if (empty) break;
                        Object value = NotificationLite.getValue(v);
                        for (InnerSubscriber ip : ps) {
                            if (ip.get() <= 0L) continue;
                            ip.child.onNext(value);
                            ip.produced(1L);
                        }
                        ++d;
                    }
                    if (d > 0 && this.sourceMode != 1) {
                        this.s.get().request((long)d);
                    }
                    if (maxRequested != 0L && !empty) continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }
    }
}

