/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.operators;

import hu.akarnokd.reactivestreams.extensions.ConditionalSubscriber;
import io.reactivex.common.annotations.Nullable;
import io.reactivex.flowable.Flowable;
import io.reactivex.flowable.internal.subscriptions.BasicFusedQueueSubscription;
import io.reactivex.flowable.internal.subscriptions.SubscriptionHelper;
import io.reactivex.flowable.internal.utils.BackpressureHelper;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableRangeLong
extends Flowable<Long> {
    final long start;
    final long end;

    public FlowableRangeLong(long start, long count) {
        this.start = start;
        this.end = start + count;
    }

    @Override
    public void subscribeActual(Subscriber<? super Long> s) {
        if (s instanceof ConditionalSubscriber) {
            s.onSubscribe((Subscription)new RangeConditionalSubscription((ConditionalSubscriber<? super Long>)((ConditionalSubscriber)s), this.start, this.end));
        } else {
            s.onSubscribe((Subscription)new RangeSubscription(s, this.start, this.end));
        }
    }

    static final class RangeConditionalSubscription
    extends BaseRangeSubscription {
        private static final long serialVersionUID = 2587302975077663557L;
        final ConditionalSubscriber<? super Long> actual;

        RangeConditionalSubscription(ConditionalSubscriber<? super Long> actual, long index, long end) {
            super(index, end);
            this.actual = actual;
        }

        @Override
        void fastPath() {
            long f = this.end;
            ConditionalSubscriber<? super Long> a = this.actual;
            for (long i = this.index; i != f; ++i) {
                if (this.cancelled) {
                    return;
                }
                a.tryOnNext((Object)i);
            }
            if (this.cancelled) {
                return;
            }
            a.onComplete();
        }

        @Override
        void slowPath(long r) {
            long e = 0L;
            long f = this.end;
            long i = this.index;
            ConditionalSubscriber<? super Long> a = this.actual;
            while (true) {
                if (e != r && i != f) {
                    if (this.cancelled) {
                        return;
                    }
                    if (a.tryOnNext((Object)i)) {
                        ++e;
                    }
                    ++i;
                    continue;
                }
                if (i == f) {
                    if (!this.cancelled) {
                        a.onComplete();
                    }
                    return;
                }
                r = this.get();
                if (e != r) continue;
                this.index = i;
                r = this.addAndGet(-e);
                if (r == 0L) {
                    return;
                }
                e = 0L;
            }
        }
    }

    static final class RangeSubscription
    extends BaseRangeSubscription {
        private static final long serialVersionUID = 2587302975077663557L;
        final Subscriber<? super Long> actual;

        RangeSubscription(Subscriber<? super Long> actual, long index, long end) {
            super(index, end);
            this.actual = actual;
        }

        @Override
        void fastPath() {
            long f = this.end;
            Subscriber<? super Long> a = this.actual;
            for (long i = this.index; i != f; ++i) {
                if (this.cancelled) {
                    return;
                }
                a.onNext((Object)i);
            }
            if (this.cancelled) {
                return;
            }
            a.onComplete();
        }

        @Override
        void slowPath(long r) {
            long e = 0L;
            long f = this.end;
            long i = this.index;
            Subscriber<? super Long> a = this.actual;
            while (true) {
                if (e != r && i != f) {
                    if (this.cancelled) {
                        return;
                    }
                    a.onNext((Object)i);
                    ++e;
                    ++i;
                    continue;
                }
                if (i == f) {
                    if (!this.cancelled) {
                        a.onComplete();
                    }
                    return;
                }
                r = this.get();
                if (e != r) continue;
                this.index = i;
                r = this.addAndGet(-e);
                if (r == 0L) {
                    return;
                }
                e = 0L;
            }
        }
    }

    static abstract class BaseRangeSubscription
    extends BasicFusedQueueSubscription<Long> {
        private static final long serialVersionUID = -2252972430506210021L;
        final long end;
        long index;
        volatile boolean cancelled;

        BaseRangeSubscription(long index, long end) {
            this.index = index;
            this.end = end;
        }

        public final int requestFusion(int mode) {
            return mode & 1;
        }

        @Nullable
        public final Long poll() {
            long i = this.index;
            if (i == this.end) {
                return null;
            }
            this.index = i + 1L;
            return i;
        }

        public final boolean isEmpty() {
            return this.index == this.end;
        }

        public final void clear() {
            this.index = this.end;
        }

        public final void request(long n) {
            if (SubscriptionHelper.validate(n) && BackpressureHelper.add(this, n) == 0L) {
                if (n == Long.MAX_VALUE) {
                    this.fastPath();
                } else {
                    this.slowPath(n);
                }
            }
        }

        public final void cancel() {
            this.cancelled = true;
        }

        abstract void fastPath();

        abstract void slowPath(long var1);
    }
}

