/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.operators;

import hu.akarnokd.reactivestreams.extensions.RelaxedSubscriber;
import io.reactivex.common.exceptions.Exceptions;
import io.reactivex.common.functions.BiFunction;
import io.reactivex.common.internal.functions.ObjectHelper;
import io.reactivex.flowable.Flowable;
import io.reactivex.flowable.internal.operators.AbstractFlowableWithUpstream;
import io.reactivex.flowable.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.flowable.internal.subscriptions.EmptySubscription;
import io.reactivex.flowable.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.Callable;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableReduceWith<T, R>
extends AbstractFlowableWithUpstream<T, R> {
    final Callable<R> initialValueSupplier;
    final BiFunction<R, ? super T, R> reducer;

    public FlowableReduceWith(Flowable<T> source, Callable<R> initialValueSupplier, BiFunction<R, ? super T, R> reducer) {
        super(source);
        this.initialValueSupplier = initialValueSupplier;
        this.reducer = reducer;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s) {
        Object initialValue;
        try {
            initialValue = ObjectHelper.requireNonNull(this.initialValueSupplier.call(), (String)"The initialValueSupplier returned a null value");
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal((Throwable)ex);
            EmptySubscription.error(ex, s);
            return;
        }
        this.source.subscribe(new ReduceWithSubscriber<T, Object>(s, initialValue, this.reducer));
    }

    static final class ReduceWithSubscriber<T, R>
    extends DeferredScalarSubscription<R>
    implements RelaxedSubscriber<T> {
        private static final long serialVersionUID = 7129356975009970557L;
        final BiFunction<R, ? super T, R> reducer;
        Subscription upstream;
        boolean done;

        ReduceWithSubscriber(Subscriber<? super R> actual, R value, BiFunction<R, ? super T, R> reducer) {
            super(actual);
            this.value = value;
            this.reducer = reducer;
        }

        public void onNext(T t) {
            if (!this.done) {
                try {
                    this.value = ObjectHelper.requireNonNull((Object)this.reducer.apply(this.value, t), (String)"The reducer returned a null value");
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    this.onError(ex);
                }
            }
        }

        public void onError(Throwable t) {
            if (this.done) {
                return;
            }
            this.done = true;
            this.value = null;
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            Object v = this.value;
            this.value = null;
            this.complete(v);
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void cancel() {
            super.cancel();
            this.upstream.cancel();
        }
    }
}

