/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.operators;

import hu.akarnokd.reactivestreams.extensions.RelaxedSubscriber;
import io.reactivex.common.RxJavaCommonPlugins;
import io.reactivex.common.exceptions.Exceptions;
import io.reactivex.common.functions.BiFunction;
import io.reactivex.common.internal.functions.ObjectHelper;
import io.reactivex.flowable.Flowable;
import io.reactivex.flowable.internal.operators.AbstractFlowableWithUpstream;
import io.reactivex.flowable.internal.subscriptions.SubscriptionHelper;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableScan<T>
extends AbstractFlowableWithUpstream<T, T> {
    final BiFunction<T, T, T> accumulator;

    public FlowableScan(Flowable<T> source, BiFunction<T, T, T> accumulator) {
        super(source);
        this.accumulator = accumulator;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new ScanSubscriber<T>(s, this.accumulator));
    }

    static final class ScanSubscriber<T>
    implements RelaxedSubscriber<T>,
    Subscription {
        final Subscriber<? super T> actual;
        final BiFunction<T, T, T> accumulator;
        Subscription s;
        T value;
        boolean done;

        ScanSubscriber(Subscriber<? super T> actual, BiFunction<T, T, T> accumulator) {
            this.actual = actual;
            this.accumulator = accumulator;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            if (this.done) {
                return;
            }
            Subscriber<? super T> a = this.actual;
            T v = this.value;
            if (v == null) {
                this.value = t;
                a.onNext(t);
            } else {
                Object u;
                try {
                    u = ObjectHelper.requireNonNull((Object)this.accumulator.apply(v, t), (String)"The value returned by the accumulator is null");
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal((Throwable)e);
                    this.s.cancel();
                    this.onError(e);
                    return;
                }
                this.value = u;
                a.onNext(u);
            }
        }

        public void onError(Throwable t) {
            if (this.done) {
                RxJavaCommonPlugins.onError((Throwable)t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
        }
    }
}

