/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.operators;

import hu.akarnokd.reactivestreams.extensions.RelaxedSubscriber;
import io.reactivex.common.RxJavaCommonPlugins;
import io.reactivex.flowable.Flowable;
import io.reactivex.flowable.internal.operators.AbstractFlowableWithUpstream;
import io.reactivex.flowable.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.flowable.internal.subscriptions.SubscriptionHelper;
import java.util.NoSuchElementException;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableSingle<T>
extends AbstractFlowableWithUpstream<T, T> {
    final T defaultValue;
    final boolean errorOnEmpty;

    public FlowableSingle(Flowable<T> source, T defaultValue, boolean errorOnEmpty) {
        super(source);
        this.defaultValue = defaultValue;
        this.errorOnEmpty = errorOnEmpty;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new SingleElementSubscriber<T>(s, this.defaultValue, this.errorOnEmpty));
    }

    static final class SingleElementSubscriber<T>
    extends DeferredScalarSubscription<T>
    implements RelaxedSubscriber<T> {
        private static final long serialVersionUID = -5526049321428043809L;
        final T defaultValue;
        final boolean errorOnEmpty;
        Subscription s;
        boolean done;

        SingleElementSubscriber(Subscriber<? super T> actual, T defaultValue, boolean errorOnEmpty) {
            super(actual);
            this.defaultValue = defaultValue;
            this.errorOnEmpty = errorOnEmpty;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            if (this.done) {
                return;
            }
            if (this.value != null) {
                this.done = true;
                this.s.cancel();
                this.actual.onError((Throwable)new IllegalArgumentException("Sequence contains more than one element!"));
                return;
            }
            this.value = t;
        }

        public void onError(Throwable t) {
            if (this.done) {
                RxJavaCommonPlugins.onError((Throwable)t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            Object v = this.value;
            this.value = null;
            if (v == null) {
                v = this.defaultValue;
            }
            if (v == null) {
                if (this.errorOnEmpty) {
                    this.actual.onError((Throwable)new NoSuchElementException());
                } else {
                    this.actual.onComplete();
                }
            } else {
                this.complete(v);
            }
        }

        @Override
        public void cancel() {
            super.cancel();
            this.s.cancel();
        }
    }
}

