/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.operators;

import hu.akarnokd.reactivestreams.extensions.RelaxedSubscriber;
import io.reactivex.common.Disposable;
import io.reactivex.common.RxJavaCommonPlugins;
import io.reactivex.common.Scheduler;
import io.reactivex.common.internal.disposables.DisposableHelper;
import io.reactivex.flowable.Flowable;
import io.reactivex.flowable.internal.operators.AbstractFlowableWithUpstream;
import io.reactivex.flowable.internal.subscribers.FullArbiterSubscriber;
import io.reactivex.flowable.internal.subscriptions.FullArbiter;
import io.reactivex.flowable.internal.subscriptions.SubscriptionHelper;
import io.reactivex.flowable.subscribers.SerializedSubscriber;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableTimeoutTimed<T>
extends AbstractFlowableWithUpstream<T, T> {
    final long timeout;
    final TimeUnit unit;
    final Scheduler scheduler;
    final Publisher<? extends T> other;
    static final Disposable NEW_TIMER = new EmptyDispose();

    public FlowableTimeoutTimed(Flowable<T> source, long timeout, TimeUnit unit, Scheduler scheduler, Publisher<? extends T> other) {
        super(source);
        this.timeout = timeout;
        this.unit = unit;
        this.scheduler = scheduler;
        this.other = other;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        if (this.other == null) {
            this.source.subscribe(new TimeoutTimedSubscriber<T>(new SerializedSubscriber<T>(s), this.timeout, this.unit, this.scheduler.createWorker()));
        } else {
            this.source.subscribe(new TimeoutTimedOtherSubscriber<T>(s, this.timeout, this.unit, this.scheduler.createWorker(), this.other));
        }
    }

    static final class EmptyDispose
    implements Disposable {
        EmptyDispose() {
        }

        public void dispose() {
        }

        public boolean isDisposed() {
            return true;
        }
    }

    static final class TimeoutTimedSubscriber<T>
    implements RelaxedSubscriber<T>,
    Disposable,
    Subscription {
        final Subscriber<? super T> actual;
        final long timeout;
        final TimeUnit unit;
        final Scheduler.Worker worker;
        Subscription s;
        final AtomicReference<Disposable> timer = new AtomicReference();
        volatile long index;
        volatile boolean done;

        TimeoutTimedSubscriber(Subscriber<? super T> actual, long timeout, TimeUnit unit, Scheduler.Worker worker) {
            this.actual = actual;
            this.timeout = timeout;
            this.unit = unit;
            this.worker = worker;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                this.scheduleTimeout(0L);
            }
        }

        public void onNext(T t) {
            long idx;
            if (this.done) {
                return;
            }
            this.index = idx = this.index + 1L;
            this.actual.onNext(t);
            this.scheduleTimeout(idx);
        }

        void scheduleTimeout(long idx) {
            Disposable d = this.timer.get();
            if (d != null) {
                d.dispose();
            }
            if (this.timer.compareAndSet(d, NEW_TIMER)) {
                d = this.worker.schedule((Runnable)new TimeoutTask(idx), this.timeout, this.unit);
                DisposableHelper.replace(this.timer, (Disposable)d);
            }
        }

        public void onError(Throwable t) {
            if (this.done) {
                RxJavaCommonPlugins.onError((Throwable)t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
            this.worker.dispose();
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
            this.worker.dispose();
        }

        public void dispose() {
            this.s.cancel();
            this.worker.dispose();
        }

        public boolean isDisposed() {
            return this.worker.isDisposed();
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.dispose();
        }

        final class TimeoutTask
        implements Runnable {
            private final long idx;

            TimeoutTask(long idx) {
                this.idx = idx;
            }

            @Override
            public void run() {
                if (this.idx == TimeoutTimedSubscriber.this.index) {
                    TimeoutTimedSubscriber.this.done = true;
                    TimeoutTimedSubscriber.this.dispose();
                    TimeoutTimedSubscriber.this.actual.onError((Throwable)new TimeoutException());
                }
            }
        }
    }

    static final class TimeoutTimedOtherSubscriber<T>
    implements RelaxedSubscriber<T>,
    Disposable {
        final Subscriber<? super T> actual;
        final long timeout;
        final TimeUnit unit;
        final Scheduler.Worker worker;
        final Publisher<? extends T> other;
        Subscription s;
        final FullArbiter<T> arbiter;
        final AtomicReference<Disposable> timer = new AtomicReference();
        volatile long index;
        volatile boolean done;

        TimeoutTimedOtherSubscriber(Subscriber<? super T> actual, long timeout, TimeUnit unit, Scheduler.Worker worker, Publisher<? extends T> other) {
            this.actual = actual;
            this.timeout = timeout;
            this.unit = unit;
            this.worker = worker;
            this.other = other;
            this.arbiter = new FullArbiter<T>(actual, this, 8);
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                if (this.arbiter.setSubscription(s)) {
                    this.actual.onSubscribe(this.arbiter);
                    this.scheduleTimeout(0L);
                }
            }
        }

        public void onNext(T t) {
            long idx;
            if (this.done) {
                return;
            }
            this.index = idx = this.index + 1L;
            if (this.arbiter.onNext(t, this.s)) {
                this.scheduleTimeout(idx);
            }
        }

        void scheduleTimeout(long idx) {
            Disposable d = this.timer.get();
            if (d != null) {
                d.dispose();
            }
            if (this.timer.compareAndSet(d, NEW_TIMER)) {
                d = this.worker.schedule((Runnable)new TimeoutTask(idx), this.timeout, this.unit);
                DisposableHelper.replace(this.timer, (Disposable)d);
            }
        }

        void subscribeNext() {
            this.other.subscribe(new FullArbiterSubscriber<T>(this.arbiter));
        }

        public void onError(Throwable t) {
            if (this.done) {
                RxJavaCommonPlugins.onError((Throwable)t);
                return;
            }
            this.done = true;
            this.arbiter.onError(t, this.s);
            this.worker.dispose();
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.arbiter.onComplete(this.s);
            this.worker.dispose();
        }

        public void dispose() {
            this.s.cancel();
            this.worker.dispose();
        }

        public boolean isDisposed() {
            return this.worker.isDisposed();
        }

        final class TimeoutTask
        implements Runnable {
            private final long idx;

            TimeoutTask(long idx) {
                this.idx = idx;
            }

            @Override
            public void run() {
                if (this.idx == TimeoutTimedOtherSubscriber.this.index) {
                    TimeoutTimedOtherSubscriber.this.done = true;
                    TimeoutTimedOtherSubscriber.this.s.cancel();
                    DisposableHelper.dispose(TimeoutTimedOtherSubscriber.this.timer);
                    TimeoutTimedOtherSubscriber.this.subscribeNext();
                    TimeoutTimedOtherSubscriber.this.worker.dispose();
                }
            }
        }
    }
}

