/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.operators;

import hu.akarnokd.reactivestreams.extensions.RelaxedSubscriber;
import io.reactivex.common.RxJavaCommonPlugins;
import io.reactivex.common.exceptions.CompositeException;
import io.reactivex.common.exceptions.Exceptions;
import io.reactivex.common.functions.Consumer;
import io.reactivex.common.functions.Function;
import io.reactivex.common.internal.functions.ObjectHelper;
import io.reactivex.flowable.Flowable;
import io.reactivex.flowable.internal.subscriptions.EmptySubscription;
import io.reactivex.flowable.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableUsing<T, D>
extends Flowable<T> {
    final Callable<? extends D> resourceSupplier;
    final Function<? super D, ? extends Publisher<? extends T>> sourceSupplier;
    final Consumer<? super D> disposer;
    final boolean eager;

    public FlowableUsing(Callable<? extends D> resourceSupplier, Function<? super D, ? extends Publisher<? extends T>> sourceSupplier, Consumer<? super D> disposer, boolean eager) {
        this.resourceSupplier = resourceSupplier;
        this.sourceSupplier = sourceSupplier;
        this.disposer = disposer;
        this.eager = eager;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> s) {
        Publisher source;
        D resource;
        try {
            resource = this.resourceSupplier.call();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal((Throwable)e);
            EmptySubscription.error(e, s);
            return;
        }
        try {
            source = (Publisher)ObjectHelper.requireNonNull((Object)this.sourceSupplier.apply(resource), (String)"The sourceSupplier returned a null Publisher");
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal((Throwable)e);
            try {
                this.disposer.accept(resource);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                EmptySubscription.error((Throwable)new CompositeException(new Throwable[]{e, ex}), s);
                return;
            }
            EmptySubscription.error(e, s);
            return;
        }
        UsingSubscriber<? super T, ? super D> us = new UsingSubscriber<T, D>(s, resource, this.disposer, this.eager);
        source.subscribe(us);
    }

    static final class UsingSubscriber<T, D>
    extends AtomicBoolean
    implements RelaxedSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = 5904473792286235046L;
        final Subscriber<? super T> actual;
        final D resource;
        final Consumer<? super D> disposer;
        final boolean eager;
        Subscription s;

        UsingSubscriber(Subscriber<? super T> actual, D resource, Consumer<? super D> disposer, boolean eager) {
            this.actual = actual;
            this.resource = resource;
            this.disposer = disposer;
            this.eager = eager;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            this.actual.onNext(t);
        }

        public void onError(Throwable t) {
            if (this.eager) {
                Throwable innerError = null;
                if (this.compareAndSet(false, true)) {
                    try {
                        this.disposer.accept(this.resource);
                    }
                    catch (Throwable e) {
                        Exceptions.throwIfFatal((Throwable)e);
                        innerError = e;
                    }
                }
                this.s.cancel();
                if (innerError != null) {
                    this.actual.onError((Throwable)new CompositeException(new Throwable[]{t, innerError}));
                } else {
                    this.actual.onError(t);
                }
            } else {
                this.actual.onError(t);
                this.s.cancel();
                this.disposeAfter();
            }
        }

        public void onComplete() {
            if (this.eager) {
                if (this.compareAndSet(false, true)) {
                    try {
                        this.disposer.accept(this.resource);
                    }
                    catch (Throwable e) {
                        Exceptions.throwIfFatal((Throwable)e);
                        this.actual.onError(e);
                        return;
                    }
                }
                this.s.cancel();
                this.actual.onComplete();
            } else {
                this.actual.onComplete();
                this.s.cancel();
                this.disposeAfter();
            }
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.disposeAfter();
            this.s.cancel();
        }

        void disposeAfter() {
            if (this.compareAndSet(false, true)) {
                try {
                    this.disposer.accept(this.resource);
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal((Throwable)e);
                    RxJavaCommonPlugins.onError((Throwable)e);
                }
            }
        }
    }
}

