/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.operators;

import hu.akarnokd.reactivestreams.extensions.ConditionalSubscriber;
import io.reactivex.common.RxJavaCommonPlugins;
import io.reactivex.common.exceptions.CompositeException;
import io.reactivex.common.exceptions.Exceptions;
import io.reactivex.common.functions.BiFunction;
import io.reactivex.common.functions.Consumer;
import io.reactivex.common.internal.functions.ObjectHelper;
import io.reactivex.flowable.ParallelFailureHandling;
import io.reactivex.flowable.ParallelFlowable;
import io.reactivex.flowable.internal.subscriptions.SubscriptionHelper;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class ParallelDoOnNextTry<T>
extends ParallelFlowable<T> {
    final ParallelFlowable<T> source;
    final Consumer<? super T> onNext;
    final BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler;

    public ParallelDoOnNextTry(ParallelFlowable<T> source, Consumer<? super T> onNext, BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler) {
        this.source = source;
        this.onNext = onNext;
        this.errorHandler = errorHandler;
    }

    @Override
    public void subscribe(Subscriber<? super T>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n = subscribers.length;
        Subscriber[] parents = new Subscriber[n];
        for (int i = 0; i < n; ++i) {
            Subscriber<? super T> a = subscribers[i];
            parents[i] = a instanceof ConditionalSubscriber ? new ParallelDoOnNextConditionalSubscriber<T>((ConditionalSubscriber)a, this.onNext, this.errorHandler) : new ParallelDoOnNextSubscriber<T>(a, this.onNext, this.errorHandler);
        }
        this.source.subscribe(parents);
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    static final class ParallelDoOnNextConditionalSubscriber<T>
    implements ConditionalSubscriber<T>,
    Subscription {
        final ConditionalSubscriber<? super T> actual;
        final Consumer<? super T> onNext;
        final BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler;
        Subscription s;
        boolean done;

        ParallelDoOnNextConditionalSubscriber(ConditionalSubscriber<? super T> actual, Consumer<? super T> onNext, BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler) {
            this.actual = actual;
            this.onNext = onNext;
            this.errorHandler = errorHandler;
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            if (!this.tryOnNext(t) && !this.done) {
                this.s.request(1L);
            }
        }

        public boolean tryOnNext(T t) {
            if (this.done) {
                return false;
            }
            long retries = 0L;
            block9: while (true) {
                try {
                    this.onNext.accept(t);
                }
                catch (Throwable ex) {
                    ParallelFailureHandling h;
                    Exceptions.throwIfFatal((Throwable)ex);
                    try {
                        h = (ParallelFailureHandling)((Object)ObjectHelper.requireNonNull((Object)this.errorHandler.apply((Object)(++retries), (Object)ex), (String)"The errorHandler returned a null item"));
                    }
                    catch (Throwable exc) {
                        Exceptions.throwIfFatal((Throwable)exc);
                        this.cancel();
                        this.onError((Throwable)new CompositeException(new Throwable[]{ex, exc}));
                        return false;
                    }
                    switch (h) {
                        case RETRY: {
                            continue block9;
                        }
                        case SKIP: {
                            return false;
                        }
                        case STOP: {
                            this.cancel();
                            this.onComplete();
                            return false;
                        }
                    }
                    this.cancel();
                    this.onError(ex);
                    return false;
                }
                break;
            }
            return this.actual.tryOnNext(t);
        }

        public void onError(Throwable t) {
            if (this.done) {
                RxJavaCommonPlugins.onError((Throwable)t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }
    }

    static final class ParallelDoOnNextSubscriber<T>
    implements ConditionalSubscriber<T>,
    Subscription {
        final Subscriber<? super T> actual;
        final Consumer<? super T> onNext;
        final BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler;
        Subscription s;
        boolean done;

        ParallelDoOnNextSubscriber(Subscriber<? super T> actual, Consumer<? super T> onNext, BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler) {
            this.actual = actual;
            this.onNext = onNext;
            this.errorHandler = errorHandler;
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            if (!this.tryOnNext(t)) {
                this.s.request(1L);
            }
        }

        public boolean tryOnNext(T t) {
            if (this.done) {
                return false;
            }
            long retries = 0L;
            block9: while (true) {
                try {
                    this.onNext.accept(t);
                }
                catch (Throwable ex) {
                    ParallelFailureHandling h;
                    Exceptions.throwIfFatal((Throwable)ex);
                    try {
                        h = (ParallelFailureHandling)((Object)ObjectHelper.requireNonNull((Object)this.errorHandler.apply((Object)(++retries), (Object)ex), (String)"The errorHandler returned a null item"));
                    }
                    catch (Throwable exc) {
                        Exceptions.throwIfFatal((Throwable)exc);
                        this.cancel();
                        this.onError((Throwable)new CompositeException(new Throwable[]{ex, exc}));
                        return false;
                    }
                    switch (h) {
                        case RETRY: {
                            continue block9;
                        }
                        case SKIP: {
                            return false;
                        }
                        case STOP: {
                            this.cancel();
                            this.onComplete();
                            return false;
                        }
                    }
                    this.cancel();
                    this.onError(ex);
                    return false;
                }
                break;
            }
            this.actual.onNext(t);
            return true;
        }

        public void onError(Throwable t) {
            if (this.done) {
                RxJavaCommonPlugins.onError((Throwable)t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }
    }
}

