/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.subscribers;

import hu.akarnokd.reactivestreams.extensions.RelaxedSubscriber;
import io.reactivex.common.Disposable;
import io.reactivex.common.RxJavaCommonPlugins;
import io.reactivex.common.exceptions.CompositeException;
import io.reactivex.common.exceptions.Exceptions;
import io.reactivex.common.functions.Action;
import io.reactivex.common.functions.Consumer;
import io.reactivex.common.functions.Predicate;
import io.reactivex.flowable.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscription;

public final class ForEachWhileSubscriber<T>
extends AtomicReference<Subscription>
implements RelaxedSubscriber<T>,
Disposable {
    private static final long serialVersionUID = -4403180040475402120L;
    final Predicate<? super T> onNext;
    final Consumer<? super Throwable> onError;
    final Action onComplete;
    boolean done;

    public ForEachWhileSubscriber(Predicate<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete) {
        this.onNext = onNext;
        this.onError = onError;
        this.onComplete = onComplete;
    }

    public void onSubscribe(Subscription s) {
        if (SubscriptionHelper.setOnce(this, s)) {
            s.request(Long.MAX_VALUE);
        }
    }

    public void onNext(T t) {
        boolean b;
        if (this.done) {
            return;
        }
        try {
            b = this.onNext.test(t);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal((Throwable)ex);
            this.dispose();
            this.onError(ex);
            return;
        }
        if (!b) {
            this.dispose();
            this.onComplete();
        }
    }

    public void onError(Throwable t) {
        if (this.done) {
            RxJavaCommonPlugins.onError((Throwable)t);
            return;
        }
        this.done = true;
        try {
            this.onError.accept((Object)t);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal((Throwable)ex);
            RxJavaCommonPlugins.onError((Throwable)new CompositeException(new Throwable[]{t, ex}));
        }
    }

    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        try {
            this.onComplete.run();
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal((Throwable)ex);
            RxJavaCommonPlugins.onError((Throwable)ex);
        }
    }

    public void dispose() {
        SubscriptionHelper.cancel(this);
    }

    public boolean isDisposed() {
        return SubscriptionHelper.isCancelled((Subscription)this.get());
    }
}

