/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.subscribers;

import hu.akarnokd.reactivestreams.extensions.RelaxedSubscriber;
import io.reactivex.common.Disposable;
import io.reactivex.common.internal.disposables.DisposableHelper;
import io.reactivex.flowable.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class SubscriberResourceWrapper<T>
extends AtomicReference<Disposable>
implements RelaxedSubscriber<T>,
Disposable,
Subscription {
    private static final long serialVersionUID = -8612022020200669122L;
    final Subscriber<? super T> actual;
    final AtomicReference<Subscription> subscription = new AtomicReference();

    public SubscriberResourceWrapper(Subscriber<? super T> actual) {
        this.actual = actual;
    }

    public void onSubscribe(Subscription s) {
        if (SubscriptionHelper.setOnce(this.subscription, s)) {
            this.actual.onSubscribe((Subscription)this);
        }
    }

    public void onNext(T t) {
        this.actual.onNext(t);
    }

    public void onError(Throwable t) {
        DisposableHelper.dispose((AtomicReference)this);
        this.actual.onError(t);
    }

    public void onComplete() {
        DisposableHelper.dispose((AtomicReference)this);
        this.actual.onComplete();
    }

    public void request(long n) {
        if (SubscriptionHelper.validate(n)) {
            this.subscription.get().request(n);
        }
    }

    public void dispose() {
        SubscriptionHelper.cancel(this.subscription);
        DisposableHelper.dispose((AtomicReference)this);
    }

    public boolean isDisposed() {
        return this.subscription.get() == SubscriptionHelper.CANCELLED;
    }

    public void cancel() {
        this.dispose();
    }

    public void setResource(Disposable resource) {
        DisposableHelper.set((AtomicReference)this, (Disposable)resource);
    }
}

