/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.subscriptions;

import io.reactivex.common.Disposable;
import io.reactivex.common.RxJavaCommonPlugins;
import io.reactivex.common.internal.functions.ObjectHelper;
import io.reactivex.flowable.internal.queues.SpscLinkedArrayQueue;
import io.reactivex.flowable.internal.subscriptions.FullArbiterPad2;
import io.reactivex.flowable.internal.subscriptions.SubscriptionHelper;
import io.reactivex.flowable.internal.utils.BackpressureHelper;
import io.reactivex.flowable.internal.utils.NotificationLite;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FullArbiter<T>
extends FullArbiterPad2
implements Subscription {
    final Subscriber<? super T> actual;
    final SpscLinkedArrayQueue<Object> queue;
    long requested;
    volatile Subscription s;
    static final Subscription INITIAL = new InitialSubscription();
    Disposable resource;
    volatile boolean cancelled;
    static final Object REQUEST = new Object();

    public FullArbiter(Subscriber<? super T> actual, Disposable resource, int capacity) {
        this.actual = actual;
        this.resource = resource;
        this.queue = new SpscLinkedArrayQueue(capacity);
        this.s = INITIAL;
    }

    public void request(long n) {
        if (SubscriptionHelper.validate(n)) {
            BackpressureHelper.add(this.missedRequested, n);
            this.queue.offer(REQUEST, REQUEST);
            this.drain();
        }
    }

    public void cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.dispose();
        }
    }

    void dispose() {
        Disposable d = this.resource;
        this.resource = null;
        if (d != null) {
            d.dispose();
        }
    }

    public boolean setSubscription(Subscription s) {
        if (this.cancelled) {
            if (s != null) {
                s.cancel();
            }
            return false;
        }
        ObjectHelper.requireNonNull((Object)s, (String)"s is null");
        this.queue.offer(this.s, NotificationLite.subscription(s));
        this.drain();
        return true;
    }

    public boolean onNext(T value, Subscription s) {
        if (this.cancelled) {
            return false;
        }
        this.queue.offer(s, NotificationLite.next(value));
        this.drain();
        return true;
    }

    public void onError(Throwable value, Subscription s) {
        if (this.cancelled) {
            RxJavaCommonPlugins.onError((Throwable)value);
            return;
        }
        this.queue.offer(s, NotificationLite.error(value));
        this.drain();
    }

    public void onComplete(Subscription s) {
        this.queue.offer(s, NotificationLite.complete());
        this.drain();
    }

    void drain() {
        if (this.wip.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        SpscLinkedArrayQueue<Object> q = this.queue;
        Subscriber<? super T> a = this.actual;
        while (true) {
            Object o;
            if ((o = q.poll()) != null) {
                Object v = q.poll();
                if (o == REQUEST) {
                    long mr = this.missedRequested.getAndSet(0L);
                    if (mr == 0L) continue;
                    this.requested = BackpressureHelper.addCap(this.requested, mr);
                    this.s.request(mr);
                    continue;
                }
                if (o != this.s) continue;
                if (NotificationLite.isSubscription(v)) {
                    Subscription next = NotificationLite.getSubscription(v);
                    if (!this.cancelled) {
                        this.s = next;
                        long r = this.requested;
                        if (r == 0L) continue;
                        next.request(r);
                        continue;
                    }
                    next.cancel();
                    continue;
                }
                if (NotificationLite.isError(v)) {
                    q.clear();
                    this.dispose();
                    Throwable ex = NotificationLite.getError(v);
                    if (!this.cancelled) {
                        this.cancelled = true;
                        a.onError(ex);
                        continue;
                    }
                    RxJavaCommonPlugins.onError((Throwable)ex);
                    continue;
                }
                if (NotificationLite.isComplete(v)) {
                    q.clear();
                    this.dispose();
                    if (this.cancelled) continue;
                    this.cancelled = true;
                    a.onComplete();
                    continue;
                }
                long r = this.requested;
                if (r == 0L) continue;
                a.onNext(NotificationLite.getValue(v));
                this.requested = r - 1L;
                continue;
            }
            if ((missed = this.wip.addAndGet(-missed)) == 0) break;
        }
    }

    static final class InitialSubscription
    implements Subscription {
        InitialSubscription() {
        }

        public void request(long n) {
        }

        public void cancel() {
        }
    }
}

