/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.utils;

import io.reactivex.common.RxJavaCommonPlugins;
import io.reactivex.common.exceptions.ProtocolViolationException;
import io.reactivex.common.internal.functions.ObjectHelper;
import io.reactivex.flowable.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscription;

public final class EndSubscriberHelper {
    private EndSubscriberHelper() {
        throw new IllegalStateException("No instances!");
    }

    public static boolean validate(Subscription upstream, Subscription next, Class<?> subscriber) {
        ObjectHelper.requireNonNull((Object)next, (String)"next is null");
        if (upstream != null) {
            next.cancel();
            if (upstream != SubscriptionHelper.CANCELLED) {
                EndSubscriberHelper.reportDoubleSubscription(subscriber);
            }
            return false;
        }
        return true;
    }

    public static boolean setOnce(AtomicReference<Subscription> upstream, Subscription next, Class<?> subscriber) {
        ObjectHelper.requireNonNull((Object)next, (String)"next is null");
        if (!upstream.compareAndSet(null, next)) {
            next.cancel();
            if (upstream.get() != SubscriptionHelper.CANCELLED) {
                EndSubscriberHelper.reportDoubleSubscription(subscriber);
            }
            return false;
        }
        return true;
    }

    public static String composeMessage(String consumer) {
        return "It is not allowed to subscribe with a(n) " + consumer + " multiple times. Please create a fresh instance of " + consumer + " and subscribe that to the target source instead.";
    }

    public static void reportDoubleSubscription(Class<?> consumer) {
        RxJavaCommonPlugins.onError((Throwable)new ProtocolViolationException(EndSubscriberHelper.composeMessage(consumer.getName())));
    }
}

