/*
 * Copyright 2018 Anton Straka
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package sk.antons.json.match.wild;

import sk.antons.json.match.*;
import java.util.List;

/**
 * SimplePathMatcher provider with short name;
 * @author antons
 */
public class WPM  {

    public static WildPathMatcher path(List<String> path) {
        return WildPathMatcher.instance(path);
    }
    
    public static WildPathMatcher path(String... path) {
        return WildPathMatcher.instance(path);
    }
    
    public static WildPathMatcher fromPath(String path) {
        return new WildPathMatcher(PathSplitter.split(path));
    }
    
}
