/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.tempdb;

import java.io.File;
import sk.antons.tempdb.TempDbException;
import sk.antons.tempdb.base.DbFile;
import sk.antons.tempdb.serialization.BytesDeserializer;
import sk.antons.tempdb.serialization.BytesSerializer;
import sk.antons.tempdb.tree.AvlTreeDb;
import sk.antons.tempdb.tree.MapTreeDb;

public class TreeDbBuilder<K, V> {
    private DbFile dbfile;
    private BytesDeserializer<K> keydeserializer;
    private BytesSerializer<K> keyserializer;
    private BytesDeserializer<V> deserializer;
    private BytesSerializer<V> serializer;

    private TreeDbBuilder(Class<K> clazz, Class<V> clazz2) {
    }

    public static <E, W> TreeDbBuilder<E, W> instance(Class<E> clazz, Class<W> clazz2) {
        return new TreeDbBuilder<E, W>(clazz, clazz2);
    }

    public TreeDbBuilder<K, V> dbfile(DbFile dbfile) {
        this.dbfile = dbfile;
        return this;
    }

    public TreeDbBuilder<K, V> file(File file) {
        this.dbfile = DbFile.instance(file);
        return this;
    }

    public TreeDbBuilder<K, V> file(String filename) {
        this.dbfile = DbFile.instance(filename);
        return this;
    }

    public TreeDbBuilder<K, V> tempfile(String prefix, String postfix, boolean deleteOnExit) {
        this.dbfile = DbFile.temporary(prefix, postfix, deleteOnExit);
        return this;
    }

    public TreeDbBuilder<K, V> keyserializer(BytesSerializer<K> keyserializer) {
        this.keyserializer = keyserializer;
        return this;
    }

    public TreeDbBuilder<K, V> keydeserializer(BytesDeserializer<K> keydeserializer) {
        this.keydeserializer = keydeserializer;
        return this;
    }

    public TreeDbBuilder<K, V> serializer(BytesSerializer<V> serializer) {
        this.serializer = serializer;
        return this;
    }

    public TreeDbBuilder<K, V> deserializer(BytesDeserializer<V> deserializer) {
        this.deserializer = deserializer;
        return this;
    }

    public AvlTreeDb<K, V> avlTreeDb() {
        if (this.dbfile == null) {
            throw new TempDbException("No dbfile defined fo new database");
        }
        if (this.serializer == null) {
            throw new TempDbException("No serializer defined fo new database");
        }
        if (this.deserializer == null) {
            throw new TempDbException("No deserializer defined fo new database");
        }
        if (this.keyserializer == null) {
            throw new TempDbException("No keyserializer defined fo new database");
        }
        if (this.keydeserializer == null) {
            throw new TempDbException("No keydeserializer defined fo new database");
        }
        return new AvlTreeDb<K, V>(this.dbfile, this.keyserializer, this.keydeserializer, this.serializer, this.deserializer);
    }

    public MapTreeDb<K, V> mapTreeDb() {
        if (this.dbfile == null) {
            throw new TempDbException("No dbfile defined fo new database");
        }
        if (this.serializer == null) {
            throw new TempDbException("No serializer defined fo new database");
        }
        if (this.deserializer == null) {
            throw new TempDbException("No deserializer defined fo new database");
        }
        return new MapTreeDb(this.dbfile, this.serializer, this.deserializer);
    }
}

