/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.tempdb.sequence;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import sk.antons.tempdb.TempDbException;
import sk.antons.tempdb.base.AbstractDb;
import sk.antons.tempdb.base.DbByteArrayInputStream;
import sk.antons.tempdb.base.DbByteArrayOutputStream;
import sk.antons.tempdb.base.DbFile;
import sk.antons.tempdb.serialization.BytesDeserializer;
import sk.antons.tempdb.serialization.BytesSerializer;

public class SequenceDb<T>
extends AbstractDb {
    protected BytesSerializer<T> serializer;
    protected BytesDeserializer<T> deserializer;
    protected RandomAccessFile raf;
    protected long index = 0L;
    protected long size = 0L;
    private DbByteArrayOutputStream os;
    private DataOutputStream dos;
    private DbByteArrayInputStream is;
    private DataInputStream dis;

    public SequenceDb(DbFile dbfile, BytesSerializer<T> serializer, BytesDeserializer<T> deserializer) {
        super(dbfile);
        this.serializer = serializer;
        this.deserializer = deserializer;
        this.raf = dbfile.randomAccessFile();
        if (dbfile.exists()) {
            try {
                this.size = this.raf.length();
            }
            catch (IOException e) {
                throw new TempDbException("Unable to read file lenagth from " + dbfile, e);
            }
        }
        this.os = new DbByteArrayOutputStream();
        try {
            this.dos = new DataOutputStream(this.os);
        }
        catch (Exception e) {
            throw new TempDbException("Unable to create temporary output stream from " + dbfile, e);
        }
        this.is = new DbByteArrayInputStream(new byte[1]);
        try {
            this.dis = new DataInputStream(this.is);
        }
        catch (Exception e) {
            throw new TempDbException("Unable to create temporary input stream from " + dbfile, e);
        }
    }

    @Override
    public void close() {
        try {
            this.raf.close();
        }
        catch (Exception e) {
            throw new TempDbException("Unable to close random access file from " + this.dbfile, e);
        }
    }

    public synchronized void add(T value) {
        try {
            this.os.reset();
            this.serializer.serialize(value, this.dos);
            this.raf.seek(this.size);
            int sz = this.os.size();
            this.raf.writeInt(sz);
            this.raf.write(this.os.buff(), 0, sz);
            this.size = this.size + (long)sz + 4L;
        }
        catch (Exception e) {
            throw new TempDbException("Unable to write to random access file from " + this.dbfile, e);
        }
    }

    public synchronized T next() {
        if (this.index >= this.size) {
            return null;
        }
        try {
            this.raf.seek(this.index);
            int sz = this.raf.readInt();
            this.is.allocate(sz);
            int n = this.raf.read(this.is.buff(), 0, sz);
            this.is.count(n);
            this.index = this.index + (long)n + 4L;
            T rv = this.deserializer.deserialize(this.dis);
            return rv;
        }
        catch (Exception e) {
            throw new TempDbException("Unable to read random access file from " + this.dbfile, e);
        }
    }
}

