/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.tempdb.sequence;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.InputStream;
import sk.antons.tempdb.TempDbException;
import sk.antons.tempdb.base.AbstractDb;
import sk.antons.tempdb.base.DbFile;
import sk.antons.tempdb.serialization.BytesDeserializer;

public class SequenceDbReader<T>
extends AbstractDb {
    protected BytesDeserializer<T> deserializer;
    protected InputStream is;
    protected DataInputStream dis;

    public SequenceDbReader(DbFile dbfile, BytesDeserializer<T> deserializer) {
        super(dbfile);
        dbfile.checkExistence();
        this.deserializer = deserializer;
        this.is = dbfile.inputStream();
        try {
            this.dis = new DataInputStream(this.is);
        }
        catch (Exception e) {
            throw new TempDbException("Unable to create input stream from " + dbfile, e);
        }
    }

    @Override
    public void close() {
        try {
            this.is.close();
        }
        catch (Exception e) {
            throw new TempDbException("Unable to close input stream from " + this.dbfile, e);
        }
    }

    public synchronized T next() {
        try {
            T rv = this.deserializer.deserialize(this.dis);
            return rv;
        }
        catch (EOFException e) {
            return null;
        }
        catch (Exception e) {
            throw new TempDbException("Unable to read input stream from " + this.dbfile, e);
        }
    }
}

