/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.tempdb.sequence;

import java.io.DataOutputStream;
import java.io.OutputStream;
import sk.antons.tempdb.TempDbException;
import sk.antons.tempdb.base.AbstractDb;
import sk.antons.tempdb.base.DbFile;
import sk.antons.tempdb.serialization.BytesSerializer;

public class SequenceDbWriter<T>
extends AbstractDb {
    protected BytesSerializer<T> serializer;
    protected OutputStream os;
    protected DataOutputStream dos;

    public SequenceDbWriter(DbFile dbfile, BytesSerializer<T> serializer) {
        super(dbfile);
        this.serializer = serializer;
        this.os = dbfile.outputStream();
        try {
            this.dos = new DataOutputStream(this.os);
        }
        catch (Exception e) {
            throw new TempDbException("Unable to create output stream from " + dbfile, e);
        }
    }

    @Override
    public void close() {
        try {
            this.dos.flush();
            this.os.flush();
            this.os.close();
        }
        catch (Exception e) {
            throw new TempDbException("Unable to close output stream from " + this.dbfile, e);
        }
    }

    public synchronized void add(T value) {
        try {
            this.serializer.serialize(value, this.dos);
        }
        catch (Exception e) {
            throw new TempDbException("Unable to write to output stream from " + this.dbfile, e);
        }
    }
}

