/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.tempdb.tree;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import sk.antons.tempdb.TempDbException;
import sk.antons.tempdb.base.AbstractDb;
import sk.antons.tempdb.base.DbByteArrayInputStream;
import sk.antons.tempdb.base.DbByteArrayOutputStream;
import sk.antons.tempdb.base.DbFile;
import sk.antons.tempdb.serialization.BytesDeserializer;
import sk.antons.tempdb.serialization.BytesSerializer;

public class MapTreeDb<K, V>
extends AbstractDb {
    Map<K, List<Long>> keymap = new TreeMap<K, List<Long>>();
    protected BytesSerializer<V> serializer;
    protected BytesDeserializer<V> deserializer;
    protected RandomAccessFile raf;
    protected long index = 0L;
    protected long size = 0L;
    private DbByteArrayOutputStream os;
    private DataOutputStream dos;
    private DbByteArrayInputStream is;
    private DataInputStream dis;

    public MapTreeDb(DbFile dbfile, BytesSerializer<V> serializer, BytesDeserializer<V> deserializer) {
        super(dbfile);
        this.serializer = serializer;
        this.deserializer = deserializer;
        this.raf = dbfile.randomAccessFile();
        if (dbfile.exists()) {
            try {
                this.size = this.raf.length();
            }
            catch (IOException e) {
                throw new TempDbException("Unable to read file lenagth from " + dbfile, e);
            }
        }
        this.os = new DbByteArrayOutputStream();
        try {
            this.dos = new DataOutputStream(this.os);
        }
        catch (Exception e) {
            throw new TempDbException("Unable to create temporary output stream from " + dbfile, e);
        }
        this.is = new DbByteArrayInputStream(new byte[1]);
        try {
            this.dis = new DataInputStream(this.is);
        }
        catch (Exception e) {
            throw new TempDbException("Unable to create temporary input stream from " + dbfile, e);
        }
    }

    @Override
    public void close() {
        try {
            this.raf.close();
        }
        catch (Exception e) {
            throw new TempDbException("Unable to close random access file from " + this.dbfile, e);
        }
    }

    public synchronized void put(K key, V value) {
        try {
            List<Long> ids;
            if (this.size != this.index) {
                this.raf.seek(this.size);
            }
            if ((ids = this.keymap.get(key)) == null) {
                ids = new ArrayList<Long>(2);
                this.keymap.put(key, ids);
            }
            ids.add(this.size);
            this.os.reset();
            this.serializer.serialize(value, this.dos);
            int sz = this.os.count();
            this.raf.writeInt(sz);
            this.raf.write(this.os.buff(), 0, sz);
            this.index = this.size = this.size + 4L + (long)sz;
        }
        catch (Exception e) {
            throw new TempDbException("Unable to write to random access file from " + this.dbfile, e);
        }
    }

    private V read(long id) throws IOException {
        if (id != this.index) {
            this.raf.seek(id);
        }
        int sz = this.raf.readInt();
        this.is.allocate(sz);
        int n = this.raf.read(this.is.buff(), 0, sz);
        this.is.count(n);
        V rv = this.deserializer.deserialize(this.dis);
        this.index = id + 4L + (long)n;
        return rv;
    }

    public synchronized List<V> get(K key) {
        try {
            ArrayList<V> rv = new ArrayList<V>();
            List<Long> list = this.keymap.get(key);
            if (list == null || list.isEmpty()) {
                return rv;
            }
            for (Long long1 : list) {
                rv.add(this.read(long1));
            }
            return rv;
        }
        catch (Exception e) {
            throw new TempDbException("Unable to read to random access file from " + this.dbfile, e);
        }
    }
}

