/*
 * Decompiled with CFR 0.152.
 */
package httpserver.handlers;

import httpserver.HttpHandler;
import httpserver.core.HttpServerExchange;
import httpserver.util.Functions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;

public final class Compression
extends Enum<Compression> {
    private static final /* synthetic */ Compression[] $VALUES;

    public static Compression[] values() {
        return (Compression[])$VALUES.clone();
    }

    public static Compression valueOf(String string) {
        return Enum.valueOf(Compression.class, string);
    }

    public static HttpHandler compress(HttpHandler httpHandler) {
        return httpServerExchange -> {
            httpHandler.handleRequest(httpServerExchange);
            if (!httpServerExchange.isResponseSent()) {
                if (Compression.acceptsEncoding(httpServerExchange, "gzip")) {
                    Compression.compressGzip(httpServerExchange);
                } else if (Compression.acceptsEncoding(httpServerExchange, "deflate")) {
                    Compression.compressDeflate(httpServerExchange);
                }
            }
        };
    }

    public static HttpHandler compressGzip(HttpHandler httpHandler) {
        return httpServerExchange -> {
            httpHandler.handleRequest(httpServerExchange);
            if (!httpServerExchange.isResponseSent() && Compression.acceptsEncoding(httpServerExchange, "gzip")) {
                Compression.compressGzip(httpServerExchange);
            }
        };
    }

    public static HttpHandler compressDeflate(HttpHandler httpHandler) {
        return httpServerExchange -> {
            httpHandler.handleRequest(httpServerExchange);
            if (!httpServerExchange.isResponseSent() && Compression.acceptsEncoding(httpServerExchange, "deflate")) {
                Compression.compressDeflate(httpServerExchange);
            }
        };
    }

    public static void compressGzip(HttpServerExchange httpServerExchange) throws IOException {
        httpServerExchange.setResponseHeader("Content-Encoding", "gzip");
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            try (GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);){
                httpServerExchange.getResponseBody().writeTo(gZIPOutputStream);
            }
            httpServerExchange.send(byteArrayOutputStream.toByteArray());
        }
    }

    public static void compressDeflate(HttpServerExchange httpServerExchange) throws IOException {
        httpServerExchange.setResponseHeader("Content-Encoding", "deflate");
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            try (DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);){
                httpServerExchange.getResponseBody().writeTo(deflaterOutputStream);
            }
            httpServerExchange.send(byteArrayOutputStream.toByteArray());
        }
    }

    public static boolean acceptsEncoding(HttpServerExchange httpServerExchange, String string) {
        String string2 = httpServerExchange.getRequestHeader("Accept-Encoding");
        if (Functions.isNullOrEmpty(string2)) {
            return false;
        }
        for (String string3 : string2.split(",")) {
            if (Functions.isNullOrEmpty(string3) || !string.equals(string3.trim())) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ Compression[] $values() {
        return new Compression[0];
    }

    static {
        $VALUES = Compression.$values();
    }
}

