/*
 * Decompiled with CFR 0.152.
 */
package httpserver.net;

import httpserver.net.Connection;
import httpserver.net.ConnectionHandler;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;

public abstract class ConnectionListener {
    protected final int backlog;
    protected final ConnectionHandler handler;
    protected final int port;
    protected final InetAddress bindAddress;
    protected final boolean daemon;
    protected final Executor executor;
    protected boolean running = true;
    protected ServerSocket serverSocket;
    protected final List<Connection> connections = new LinkedList<Connection>();

    protected ConnectionListener(int n, InetAddress inetAddress, boolean bl, int n2, Executor executor, ConnectionHandler connectionHandler) {
        this.port = n;
        this.bindAddress = inetAddress;
        this.daemon = bl;
        this.backlog = n2;
        this.executor = executor;
        this.handler = connectionHandler;
    }

    public ConnectionListener start() throws IOException {
        this.serverSocket = new ServerSocket(this.port, this.backlog, this.bindAddress);
        Thread thread = new Thread(() -> {
            while (this.running) {
                try {
                    List<Connection> list = this.connections;
                    synchronized (list) {
                        this.connections.add(new Connection(this.executor, this.serverSocket.accept(), this.handler));
                        this.connections.removeIf(connection -> !connection.isAlive());
                    }
                }
                catch (Exception exception) {
                }
            }
        });
        thread.setDaemon(this.daemon);
        thread.start();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws IOException {
        this.running = false;
        try {
            this.serverSocket.close();
        }
        finally {
            List<Connection> list = this.connections;
            synchronized (list) {
                this.connections.forEach(Connection::stop);
            }
        }
    }
}

