/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.caching;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class CachingModule<T> {
    private Map<String, Entry> cacheEntries = new HashMap<String, Entry>();

    public T getOrAdd(String name, Supplier<T> valueFactory, Duration expiration) {
        Entry entry;
        if (this.cacheEntries.containsKey(name) && (entry = this.cacheEntries.get(name)) != null && !entry.isExpired()) {
            return entry.getValue();
        }
        T value = valueFactory.get();
        this.cacheEntries.put(name, new Entry(value, LocalDateTime.now().plus(expiration)));
        return value;
    }

    public void invalidate() {
        this.invalidate(null);
    }

    public void invalidate(String name) {
        if (name == null) {
            this.cacheEntries.clear();
            return;
        }
        this.cacheEntries.remove(name);
    }

    private class Entry {
        private T value;
        private LocalDateTime expirationDate;

        private Entry(T value, LocalDateTime expirationDate) {
            this.value = value;
            this.expirationDate = expirationDate;
        }

        public T getValue() {
            return this.value;
        }

        private boolean isExpired() {
            return LocalDateTime.now().isAfter(this.expirationDate);
        }
    }
}

