/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.mappers;

import com.github.collinalpert.java2db.annotations.ColumnName;
import com.github.collinalpert.java2db.annotations.ForeignKeyEntity;
import com.github.collinalpert.java2db.contracts.IdentifiableEnum;
import com.github.collinalpert.java2db.entities.BaseEntity;
import com.github.collinalpert.java2db.mappers.Mappable;
import com.github.collinalpert.java2db.modules.AnnotationModule;
import com.github.collinalpert.java2db.modules.ArrayModule;
import com.github.collinalpert.java2db.modules.FieldModule;
import com.github.collinalpert.java2db.modules.TableModule;
import com.github.collinalpert.java2db.utilities.IoC;
import com.github.collinalpert.java2db.utilities.UniqueIdentifier;
import com.github.collinalpert.java2db.utilities.Utilities;
import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class BaseMapper<E extends BaseEntity>
implements Mappable<E> {
    private static final AnnotationModule annotationModule = new AnnotationModule();
    private static final TableModule tableModule = new TableModule();
    private Class<E> clazz;

    public BaseMapper(Class<E> clazz) {
        this.clazz = clazz;
    }

    @Override
    public Optional<E> map(ResultSet set) throws SQLException {
        BaseEntity entity = (BaseEntity)IoC.createInstance(this.clazz);
        if (!set.next()) {
            UniqueIdentifier.unset();
            return Optional.empty();
        }
        this.setFields(set, entity);
        set.close();
        UniqueIdentifier.unset();
        return Optional.of(entity);
    }

    @Override
    public List<E> mapToList(ResultSet set) throws SQLException {
        ArrayList list = new ArrayList();
        this.mapInternal(set, list::add);
        return list;
    }

    @Override
    public Stream<E> mapToStream(ResultSet set) throws SQLException {
        Stream.Builder builder = Stream.builder();
        this.mapInternal(set, builder::add);
        return builder.build();
    }

    @Override
    public E[] mapToArray(ResultSet set) throws SQLException {
        ArrayModule<E> module = new ArrayModule<E>(this.clazz, 20);
        this.mapInternal(set, module::addElement);
        return (BaseEntity[])module.getArray();
    }

    private void mapInternal(ResultSet set, Consumer<E> handling) throws SQLException {
        while (set.next()) {
            BaseEntity entity = (BaseEntity)IoC.createInstance(this.clazz);
            this.setFields(set, entity);
            handling.accept(entity);
        }
        set.close();
        UniqueIdentifier.unset();
    }

    private <TEntity extends BaseEntity> void setFields(ResultSet set, TEntity entity) throws SQLException {
        this.setFields(set, entity, null);
    }

    private <TEntity extends BaseEntity> void setFields(ResultSet set, TEntity entity, String identifier) throws SQLException {
        FieldModule fieldModule = new FieldModule();
        List<Field> fields = fieldModule.getEntityFields(entity.getClass(), true);
        for (Field field : fields) {
            String columnName;
            field.setAccessible(true);
            if (field.getAnnotation(ForeignKeyEntity.class) != null) {
                if (field.getType().isEnum()) {
                    if (!IdentifiableEnum.class.isAssignableFrom(field.getType())) {
                        throw new IllegalArgumentException(String.format("The enum %s used in %s was annotated with a ForeignKeyEntity attribute but does not extend IdentifiableEnum.", field.getType().getSimpleName(), field.getDeclaringClass().getSimpleName()));
                    }
                    String foreignKeyName = this.getForeignKeyName(field);
                    Optional<IdentifiableEnum> foundEnum = Arrays.stream(field.getType().getEnumConstants()).map((? super T x) -> (IdentifiableEnum)x).filter(x -> Long.valueOf(Utilities.tryGetValue(() -> this.getAccessibleField(field.getDeclaringClass(), foreignKeyName).get(entity)).toString()).longValue() == x.getId()).findFirst();
                    foundEnum.ifPresent(identifiableEnum -> Utilities.tryAction(() -> field.set(entity, field.getType().cast(identifiableEnum))));
                    continue;
                }
                if (!BaseEntity.class.isAssignableFrom(field.getType())) {
                    throw new IllegalArgumentException(String.format("Type %s, which is annotated as a foreign key, does not extend BaseEntity.", field.getType().getSimpleName()));
                }
                if (set.getObject((identifier == null ? tableModule.getTableName(entity.getClass()) : identifier) + "_" + this.getForeignKeyName(field)) == null) continue;
                BaseEntity foreignKeyObject = (BaseEntity)IoC.createInstance(field.getType());
                this.setFields(set, foreignKeyObject, UniqueIdentifier.getIdentifier(field.getName()));
                Utilities.tryAction(() -> field.set(entity, foreignKeyObject));
                continue;
            }
            String columnLabel = (identifier == null ? tableModule.getTableName(entity.getClass()) : identifier) + "_" + (columnName = tableModule.getColumnName(field));
            Object value = this.getValue(set, columnLabel, field.getType());
            if (value == null) continue;
            Utilities.tryAction(() -> field.set(entity, value));
        }
    }

    private Object getValue(ResultSet set, String columnLabel, Class<?> type) throws SQLException {
        if (type == LocalDateTime.class) {
            Timestamp value = set.getTimestamp(columnLabel, Calendar.getInstance(Locale.getDefault()));
            return value == null ? null : value.toLocalDateTime();
        }
        if (type == LocalDate.class) {
            Date value = set.getDate(columnLabel, Calendar.getInstance(Locale.getDefault()));
            return value == null ? null : value.toLocalDate();
        }
        if (type == LocalTime.class) {
            Time value = set.getTime(columnLabel, Calendar.getInstance(Locale.getDefault()));
            return value == null ? null : value.toLocalTime();
        }
        return set.getObject(columnLabel);
    }

    private String getForeignKeyName(Field field) {
        String foreignKeyColumnName = field.getAnnotation(ForeignKeyEntity.class).value();
        try {
            Field foreignKeyField = field.getDeclaringClass().getDeclaredField(foreignKeyColumnName);
            return tableModule.getColumnName(foreignKeyField);
        }
        catch (NoSuchFieldException e) {
            for (Field declaredField : field.getDeclaringClass().getDeclaredFields()) {
                AnnotationModule.AnnotationInfo<ColumnName> info = annotationModule.getAnnotationInfo(declaredField, ColumnName.class, a -> a.value().equals(foreignKeyColumnName));
                if (!info.hasAnnotation()) continue;
                return info.getAnnotation().value();
            }
            return "";
        }
    }

    private Field getAccessibleField(Class<?> clazz, String name) throws NoSuchFieldException {
        Field field = clazz.getDeclaredField(name);
        field.setAccessible(true);
        return field;
    }
}

