/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.modules;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.function.Function;

public class AnnotationModule {
    public <A extends Annotation> boolean hasAnnotation(Field field, Class<A> annotationClass) {
        return field.getAnnotation(annotationClass) != null;
    }

    public <A extends Annotation> boolean hasAnnotation(Field field, Class<A> annotationClass, Function<A, Boolean> additionalCondition) {
        A annotation = field.getAnnotation(annotationClass);
        if (annotation == null) {
            return false;
        }
        return additionalCondition.apply(annotation);
    }

    public <A extends Annotation> AnnotationInfo<A> getAnnotationInfo(Field field, Class<A> annotationClass) {
        return this.getAnnotationInfo(field, annotationClass, x -> true);
    }

    public <A extends Annotation> AnnotationInfo<A> getAnnotationInfo(Field field, Class<A> annotationClass, Function<A, Boolean> additionalCondition) {
        A annotation = field.getAnnotation(annotationClass);
        if (annotation == null) {
            return new AnnotationInfo();
        }
        return new AnnotationInfo<A>(additionalCondition.apply(annotation), annotation);
    }

    public static final class AnnotationInfo<A extends Annotation> {
        private final boolean hasAnnotation;
        private final A annotation;

        public AnnotationInfo() {
            this(false, null);
        }

        public AnnotationInfo(boolean hasAnnotation, A annotation) {
            this.hasAnnotation = hasAnnotation;
            this.annotation = annotation;
        }

        public boolean hasAnnotation() {
            return this.hasAnnotation;
        }

        public A getAnnotation() {
            return this.annotation;
        }
    }
}

