/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.queries;

import com.github.collinalpert.java2db.database.DBConnection;
import com.github.collinalpert.java2db.entities.BaseEntity;
import com.github.collinalpert.java2db.modules.ArrayModule;
import com.github.collinalpert.java2db.queries.EntityQuery;
import com.github.collinalpert.java2db.queries.Queryable;
import com.github.collinalpert.lambda2sql.Lambda2Sql;
import com.github.collinalpert.lambda2sql.functions.SqlFunction;
import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Stream;

public class EntityProjectionQuery<E extends BaseEntity, R>
implements Queryable<R> {
    private final Class<R> returnType;
    private final SqlFunction<E, R> projection;
    private final EntityQuery<E> originalQuery;

    public EntityProjectionQuery(Class<R> returnType, SqlFunction<E, R> projection, EntityQuery<E> originalQuery) {
        this.returnType = returnType;
        this.projection = projection;
        this.originalQuery = originalQuery;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<R> getFirst() {
        try (DBConnection connection = new DBConnection();){
            Optional optional;
            block17: {
                ResultSet result;
                block15: {
                    Optional<R> optional2;
                    block16: {
                        result = connection.execute(this.getQuery());
                        try {
                            if (!result.next()) break block15;
                            optional2 = Optional.ofNullable(result.getObject(1, this.returnType));
                            if (result == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (result != null) {
                                try {
                                    result.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        result.close();
                    }
                    return optional2;
                }
                optional = Optional.empty();
                if (result == null) break block17;
                result.close();
            }
            return optional;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    @Override
    public List<R> toList() {
        ArrayList list = new ArrayList();
        return this.resultHandling(list, List::add, Collections.emptyList(), Function.identity());
    }

    @Override
    public Stream<R> toStream() {
        Stream.Builder streamBuilder = Stream.builder();
        return this.resultHandling(streamBuilder, Stream.Builder::accept, Stream.empty(), Stream.Builder::build);
    }

    @Override
    public R[] toArray() {
        ArrayModule<R> arrayModule = new ArrayModule<R>(this.returnType, 20);
        Object[] defaultValue = (Object[])Array.newInstance(this.returnType, 0);
        return this.resultHandling(arrayModule, ArrayModule::addElement, defaultValue, ArrayModule::getArray);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private <T, D> T resultHandling(D dataType, BiConsumer<D, R> valueConsumer, T defaultValue, Function<D, T> valueMapping) {
        try (DBConnection connection = new DBConnection();){
            D d;
            block14: {
                ResultSet result = connection.execute(this.getQuery());
                try {
                    while (result.next()) {
                        valueConsumer.accept(dataType, result.getObject(1, this.returnType));
                    }
                    d = valueMapping.apply(dataType);
                    if (result == null) break block14;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                result.close();
            }
            return (T)d;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    @Override
    public String getQuery() {
        StringBuilder builder = new StringBuilder("select ");
        String tableName = this.originalQuery.getTableName();
        String columnName = Lambda2Sql.toSql(this.projection, tableName);
        builder.append(columnName).append(" from `").append(tableName).append("`");
        builder.append(this.originalQuery.generateQueryClauses(tableName));
        return builder.toString();
    }
}

