/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.services;

import com.github.collinalpert.java2db.database.DBConnection;
import com.github.collinalpert.java2db.entities.BaseDeletableEntity;
import com.github.collinalpert.java2db.entities.BaseEntity;
import com.github.collinalpert.java2db.modules.LoggingModule;
import com.github.collinalpert.java2db.services.BaseService;
import com.github.collinalpert.lambda2sql.Lambda2Sql;
import com.github.collinalpert.lambda2sql.functions.SqlFunction;
import com.github.collinalpert.lambda2sql.functions.SqlPredicate;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;

public class BaseDeletableService<T extends BaseDeletableEntity>
extends BaseService<T> {
    private static final LoggingModule loggingModule = new LoggingModule();
    private final SqlFunction<T, Boolean> isDeletedFunc = BaseDeletableEntity::isDeleted;

    @Override
    public void delete(T instance) throws SQLException {
        this.delete(((BaseEntity)instance).getId());
    }

    @Override
    public void delete(long id) throws SQLException {
        super.update(id, this.isDeletedFunc, Boolean.valueOf(true));
    }

    @Override
    public void delete(List<T> entities) throws SQLException {
        StringJoiner joiner = new StringJoiner(", ", "(", ")");
        for (BaseDeletableEntity entity : entities) {
            joiner.add(Long.toString(entity.getId()));
        }
        String joinedIds = joiner.toString();
        try (DBConnection connection = new DBConnection();){
            connection.update(String.format("update `%s` set %s = 1 where `%s`.`id` in %s", this.tableName, Lambda2Sql.toSql(this.isDeletedFunc, this.tableName), this.tableName, joinedIds));
            loggingModule.logf("%s with ids %s successfully soft deleted!", this.type.getSimpleName(), joinedIds);
        }
    }

    @Override
    @SafeVarargs
    public final void delete(T ... entities) throws SQLException {
        this.delete(Arrays.asList(entities));
    }

    @Override
    public void delete(long ... ids) throws SQLException {
        ArrayList<Long> list = new ArrayList<Long>(ids.length);
        for (long id : ids) {
            list.add(id);
        }
        this.delete(x -> list.contains(x.getId()));
    }

    @Override
    public void delete(SqlPredicate<T> predicate) throws SQLException {
        String query = String.format("update %s set %s = 1 where %s", this.tableName, Lambda2Sql.toSql(this.isDeletedFunc, this.tableName), Lambda2Sql.toSql(predicate));
        try (DBConnection connection = new DBConnection();){
            connection.update(query);
            loggingModule.logf("%s successfully soft deleted!", this.type.getSimpleName());
        }
    }
}

