/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.lambda2sql;

import com.github.collinalpert.lambda2sql.LinkedListStack;
import com.trigersoft.jaque.expression.BinaryExpression;
import com.trigersoft.jaque.expression.ConstantExpression;
import com.trigersoft.jaque.expression.DelegateExpression;
import com.trigersoft.jaque.expression.Expression;
import com.trigersoft.jaque.expression.ExpressionType;
import com.trigersoft.jaque.expression.ExpressionVisitor;
import com.trigersoft.jaque.expression.InvocationExpression;
import com.trigersoft.jaque.expression.LambdaExpression;
import com.trigersoft.jaque.expression.MemberExpression;
import com.trigersoft.jaque.expression.ParameterExpression;
import com.trigersoft.jaque.expression.UnaryExpression;
import java.util.List;
import java.util.stream.Collectors;

public class ToSqlVisitor
implements ExpressionVisitor<StringBuilder> {
    private final String prefix;
    private LinkedListStack<List<ConstantExpression>> arguments;
    private StringBuilder sb;
    private Expression body;

    ToSqlVisitor(String prefix) {
        this.prefix = prefix;
        this.sb = new StringBuilder();
        this.arguments = new LinkedListStack();
    }

    private static String toSqlOp(int expressionType) {
        switch (expressionType) {
            case 10: {
                return "=";
            }
            case 2: {
                return "AND";
            }
            case 31: {
                return "OR";
            }
            case 8: {
                return "";
            }
        }
        return ExpressionType.toString(expressionType);
    }

    @Override
    public StringBuilder visit(BinaryExpression e) {
        boolean quote;
        if (e.getSecond() instanceof ParameterExpression && this.arguments.top().get(((ParameterExpression)e.getSecond()).getIndex()).getValue() == null) {
            if (e.getExpressionType() == 10) {
                return Expression.isNull(e.getFirst()).accept(this);
            }
            if (e.getExpressionType() == 29) {
                return Expression.unary(28, Boolean.TYPE, Expression.unary(15, Boolean.TYPE, e.getFirst())).accept(this);
            }
        }
        boolean bl = quote = e != this.body && e.getExpressionType() == 31;
        if (quote) {
            this.sb.append('(');
        }
        e.getFirst().accept(this);
        this.sb.append(' ').append(ToSqlVisitor.toSqlOp(e.getExpressionType())).append(' ');
        e.getSecond().accept(this);
        if (quote) {
            this.sb.append(')');
        }
        return this.sb;
    }

    @Override
    public StringBuilder visit(ConstantExpression e) {
        if (e.getValue() instanceof LambdaExpression) {
            ((LambdaExpression)e.getValue()).getBody().accept(this);
            return this.sb;
        }
        if (e.getValue() == null) {
            return this.sb.append("NULL");
        }
        if (e.getValue() instanceof String) {
            return this.sb.append("'").append(e.getValue().toString()).append("'");
        }
        return this.sb.append(e.getValue().toString());
    }

    @Override
    public StringBuilder visit(InvocationExpression e) {
        List list = e.getArguments().stream().filter(x -> x instanceof ConstantExpression).map(ConstantExpression.class::cast).collect(Collectors.toList());
        if (!list.isEmpty()) {
            this.arguments.push(list);
        }
        return e.getTarget().accept(this);
    }

    @Override
    public StringBuilder visit(LambdaExpression<?> e) {
        if (this.body == null && e.getBody() instanceof BinaryExpression) {
            this.body = e.getBody();
        }
        return e.getBody().accept(this);
    }

    @Override
    public StringBuilder visit(DelegateExpression e) {
        return e.getDelegate().accept(this);
    }

    @Override
    public StringBuilder visit(MemberExpression e) {
        Object name = e.getMember().getName();
        name = ((String)name).replaceAll("^(get)", "");
        name = ((String)name).substring(0, 1).toLowerCase() + ((String)name).substring(1);
        if (this.prefix == null) {
            return this.sb.append((String)name);
        }
        return this.sb.append(this.prefix).append(".").append((String)name);
    }

    @Override
    public StringBuilder visit(ParameterExpression e) {
        this.arguments.top().get(e.getIndex()).accept(this);
        if (e.getIndex() == this.arguments.top().size() - 1) {
            this.arguments.pop();
        }
        return this.sb;
    }

    @Override
    public StringBuilder visit(UnaryExpression e) {
        if (e.getFirst() instanceof UnaryExpression && e.getExpressionType() == 28 && e.getFirst().getExpressionType() == 15) {
            return ((UnaryExpression)e.getFirst()).getFirst().accept(this).append(" IS NOT NULL");
        }
        if (e.getExpressionType() == 15) {
            return e.getFirst().accept(this).append(" IS NULL");
        }
        this.sb.append(ToSqlVisitor.toSqlOp(e.getExpressionType()));
        return e.getFirst().accept(this);
    }
}

