/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.struct;

import develop.toolkit.struct.Pager;
import develop.toolkit.struct.SimplePager;
import java.util.List;

public class PagerResult<T> {
    private List<T> list;
    private long total;
    private Pager pager;
    private long pageTotal;

    public PagerResult(Pager pager, List<T> list, long total) {
        this.list = list;
        this.total = total;
        this.pager = pager;
        this.pageTotal = total % (long)pager.getSize() == 0L ? total / (long)pager.getSize() : total / (long)pager.getSize() + 1L;
    }

    public PagerResult(int page, int size, List<T> list, long total) {
        this(new SimplePager(page, size), list, total);
    }

    public List<T> getList() {
        return this.list;
    }

    public long getTotal() {
        return this.total;
    }

    public Pager getPager() {
        return this.pager;
    }

    public long getPageTotal() {
        return this.pageTotal;
    }
}

