/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.command;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.DockerCmdSyncExec;
import com.github.dockerjava.api.command.SyncDockerCmd;
import com.github.dockerjava.api.exception.ConflictException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Capability;
import com.github.dockerjava.api.model.Device;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.HealthCheck;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.Link;
import com.github.dockerjava.api.model.LogConfig;
import com.github.dockerjava.api.model.LxcConf;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.api.model.RestartPolicy;
import com.github.dockerjava.api.model.Ulimit;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.api.model.VolumesFrom;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckForNull;

public interface CreateContainerCmd
extends SyncDockerCmd<CreateContainerResponse> {
    @CheckForNull
    public AuthConfig getAuthConfig();

    public CreateContainerCmd withAuthConfig(AuthConfig var1);

    @CheckForNull
    public List<String> getAliases();

    @Deprecated
    @CheckForNull
    @JsonIgnore
    default public Bind[] getBinds() {
        return this.getHostConfig().getBinds();
    }

    @Deprecated
    default public CreateContainerCmd withBinds(Bind ... binds) {
        Objects.requireNonNull(binds, "binds was not specified");
        this.getHostConfig().setBinds(binds);
        return this;
    }

    @Deprecated
    default public CreateContainerCmd withBinds(List<Bind> binds) {
        Objects.requireNonNull(binds, "binds was not specified");
        return this.withBinds(binds.toArray(new Bind[binds.size()]));
    }

    public CreateContainerCmd withAliases(List<String> var1);

    public CreateContainerCmd withAliases(String ... var1);

    @CheckForNull
    public String[] getCmd();

    public CreateContainerCmd withCmd(String ... var1);

    public CreateContainerCmd withCmd(List<String> var1);

    @CheckForNull
    public HealthCheck getHealthcheck();

    public CreateContainerCmd withHealthcheck(HealthCheck var1);

    @CheckForNull
    public Boolean getArgsEscaped();

    public CreateContainerCmd withArgsEscaped(Boolean var1);

    @CheckForNull
    public String getDomainName();

    public CreateContainerCmd withDomainName(String var1);

    @CheckForNull
    public String[] getEntrypoint();

    public CreateContainerCmd withEntrypoint(String ... var1);

    public CreateContainerCmd withEntrypoint(List<String> var1);

    @CheckForNull
    public String[] getEnv();

    public CreateContainerCmd withEnv(String ... var1);

    public CreateContainerCmd withEnv(List<String> var1);

    @CheckForNull
    public ExposedPort[] getExposedPorts();

    public CreateContainerCmd withExposedPorts(List<ExposedPort> var1);

    public CreateContainerCmd withExposedPorts(ExposedPort ... var1);

    @CheckForNull
    public String getStopSignal();

    public CreateContainerCmd withStopSignal(String var1);

    @CheckForNull
    public Integer getStopTimeout();

    public CreateContainerCmd withStopTimeout(Integer var1);

    @CheckForNull
    public String getHostName();

    public CreateContainerCmd withHostName(String var1);

    @CheckForNull
    public String getImage();

    public CreateContainerCmd withImage(String var1);

    @CheckForNull
    public String getIpv4Address();

    public CreateContainerCmd withIpv4Address(String var1);

    @Deprecated
    @CheckForNull
    @JsonIgnore
    default public Link[] getLinks() {
        return this.getHostConfig().getLinks();
    }

    @Deprecated
    default public CreateContainerCmd withLinks(Link ... links) {
        Objects.requireNonNull(links, "links was not specified");
        this.getHostConfig().setLinks(links);
        return this;
    }

    @Deprecated
    default public CreateContainerCmd withLinks(List<Link> links) {
        Objects.requireNonNull(links, "links was not specified");
        return this.withLinks(links.toArray(new Link[links.size()]));
    }

    @CheckForNull
    public String getIpv6Address();

    public CreateContainerCmd withIpv6Address(String var1);

    @CheckForNull
    public Map<String, String> getLabels();

    public CreateContainerCmd withLabels(Map<String, String> var1);

    @CheckForNull
    public String getMacAddress();

    public CreateContainerCmd withMacAddress(String var1);

    @Deprecated
    @CheckForNull
    @JsonIgnore
    default public Long getMemory() {
        return this.getHostConfig().getMemory();
    }

    @Deprecated
    default public CreateContainerCmd withMemory(Long memory) {
        Objects.requireNonNull(memory, "memory was not specified");
        this.getHostConfig().withMemory(memory);
        return this;
    }

    @Deprecated
    @CheckForNull
    @JsonIgnore
    default public Long getMemorySwap() {
        return this.getHostConfig().getMemorySwap();
    }

    @Deprecated
    default public CreateContainerCmd withMemorySwap(Long memorySwap) {
        Objects.requireNonNull(memorySwap, "memorySwap was not specified");
        this.getHostConfig().withMemorySwap(memorySwap);
        return this;
    }

    @CheckForNull
    public String getName();

    @Deprecated
    @CheckForNull
    @JsonIgnore
    default public String getNetworkMode() {
        return this.getHostConfig().getNetworkMode();
    }

    @Deprecated
    default public CreateContainerCmd withNetworkMode(String networkMode) {
        Objects.requireNonNull(networkMode, "networkMode was not specified");
        this.getHostConfig().withNetworkMode(networkMode);
        return this;
    }

    @Deprecated
    @CheckForNull
    @JsonIgnore
    default public Ports getPortBindings() {
        return this.getHostConfig().getPortBindings();
    }

    @Deprecated
    default public CreateContainerCmd withPortBindings(PortBinding ... portBindings) {
        Objects.requireNonNull(portBindings, "portBindings was not specified");
        this.getHostConfig().withPortBindings(new Ports(portBindings));
        return this;
    }

    @Deprecated
    default public CreateContainerCmd withPortBindings(List<PortBinding> portBindings) {
        Objects.requireNonNull(portBindings, "portBindings was not specified");
        return this.withPortBindings(portBindings.toArray(new PortBinding[0]));
    }

    @Deprecated
    default public CreateContainerCmd withPortBindings(Ports portBindings) {
        Objects.requireNonNull(portBindings, "portBindings was not specified");
        this.getHostConfig().withPortBindings(portBindings);
        return this;
    }

    public CreateContainerCmd withName(String var1);

    @CheckForNull
    public String[] getPortSpecs();

    public CreateContainerCmd withPortSpecs(String ... var1);

    public CreateContainerCmd withPortSpecs(List<String> var1);

    @Deprecated
    @CheckForNull
    @JsonIgnore
    default public Boolean getPrivileged() {
        return this.getHostConfig().getPrivileged();
    }

    @Deprecated
    default public CreateContainerCmd withPrivileged(Boolean privileged) {
        Objects.requireNonNull(privileged, "no privileged was specified");
        this.getHostConfig().withPrivileged(privileged);
        return this;
    }

    @CheckForNull
    public String getUser();

    public CreateContainerCmd withUser(String var1);

    @CheckForNull
    public Volume[] getVolumes();

    public CreateContainerCmd withVolumes(Volume ... var1);

    public CreateContainerCmd withVolumes(List<Volume> var1);

    @Deprecated
    @CheckForNull
    @JsonIgnore
    default public VolumesFrom[] getVolumesFrom() {
        return this.getHostConfig().getVolumesFrom();
    }

    @Deprecated
    default public CreateContainerCmd withVolumesFrom(VolumesFrom ... volumesFrom) {
        Objects.requireNonNull(volumesFrom, "volumesFrom was not specified");
        this.getHostConfig().withVolumesFrom(volumesFrom);
        return this;
    }

    @Deprecated
    default public CreateContainerCmd withVolumesFrom(List<VolumesFrom> volumesFrom) {
        Objects.requireNonNull(volumesFrom, "volumesFrom was not specified");
        return this.withVolumesFrom(volumesFrom.toArray(new VolumesFrom[volumesFrom.size()]));
    }

    @CheckForNull
    public String getWorkingDir();

    public CreateContainerCmd withWorkingDir(String var1);

    @CheckForNull
    public Boolean isAttachStderr();

    public CreateContainerCmd withAttachStderr(Boolean var1);

    @CheckForNull
    public Boolean isAttachStdin();

    public CreateContainerCmd withAttachStdin(Boolean var1);

    @CheckForNull
    public Boolean isAttachStdout();

    public CreateContainerCmd withAttachStdout(Boolean var1);

    @CheckForNull
    public Boolean isNetworkDisabled();

    public CreateContainerCmd withNetworkDisabled(Boolean var1);

    @CheckForNull
    public Boolean isStdInOnce();

    public CreateContainerCmd withStdInOnce(Boolean var1);

    @CheckForNull
    public Boolean isStdinOpen();

    public CreateContainerCmd withStdinOpen(Boolean var1);

    @CheckForNull
    public Boolean isTty();

    public CreateContainerCmd withTty(Boolean var1);

    @Deprecated
    @CheckForNull
    @JsonIgnore
    default public Boolean getPublishAllPorts() {
        return this.getHostConfig().getPublishAllPorts();
    }

    @Deprecated
    default public CreateContainerCmd withPublishAllPorts(Boolean publishAllPorts) {
        Objects.requireNonNull(publishAllPorts, "no publishAllPorts was specified");
        this.getHostConfig().withPublishAllPorts(publishAllPorts);
        return this;
    }

    @CheckForNull
    @Deprecated
    @JsonIgnore
    default public String[] getExtraHosts() {
        return this.getHostConfig().getExtraHosts();
    }

    @Deprecated
    default public CreateContainerCmd withExtraHosts(String ... extraHosts) {
        Objects.requireNonNull(extraHosts, "extraHosts was not specified");
        this.getHostConfig().withExtraHosts(extraHosts);
        return this;
    }

    @Deprecated
    default public CreateContainerCmd withExtraHosts(List<String> extraHosts) {
        Objects.requireNonNull(extraHosts, "extraHosts was not specified");
        return this.withExtraHosts(extraHosts.toArray(new String[extraHosts.size()]));
    }

    @CheckForNull
    @Deprecated
    @JsonIgnore
    default public Capability[] getCapAdd() {
        return this.getHostConfig().getCapAdd();
    }

    @Deprecated
    default public CreateContainerCmd withCapAdd(Capability ... capAdd) {
        Objects.requireNonNull(capAdd, "capAdd was not specified");
        this.getHostConfig().withCapAdd(capAdd);
        return this;
    }

    @Deprecated
    default public CreateContainerCmd withCapAdd(List<Capability> capAdd) {
        Objects.requireNonNull(capAdd, "capAdd was not specified");
        return this.withCapAdd(capAdd.toArray(new Capability[capAdd.size()]));
    }

    @CheckForNull
    @Deprecated
    @JsonIgnore
    default public Capability[] getCapDrop() {
        return this.getHostConfig().getCapDrop();
    }

    @Deprecated
    default public CreateContainerCmd withCapDrop(Capability ... capDrop) {
        Objects.requireNonNull(capDrop, "capDrop was not specified");
        this.getHostConfig().withCapDrop(capDrop);
        return this;
    }

    @Deprecated
    default public CreateContainerCmd withCapDrop(List<Capability> capDrop) {
        Objects.requireNonNull(capDrop, "capDrop was not specified");
        return this.withCapDrop(capDrop.toArray(new Capability[capDrop.size()]));
    }

    @CheckForNull
    public List<String> getOnBuild();

    public CreateContainerCmd withOnBuild(List<String> var1);

    @CheckForNull
    public HostConfig getHostConfig();

    public CreateContainerCmd withHostConfig(HostConfig var1);

    @Deprecated
    @CheckForNull
    @JsonIgnore
    default public Integer getBlkioWeight() {
        return this.getHostConfig().getBlkioWeight();
    }

    @CheckForNull
    @Deprecated
    @JsonIgnore
    default public String getCgroupParent() {
        return this.getHostConfig().getCgroupParent();
    }

    @Deprecated
    @CheckForNull
    @JsonIgnore
    default public Integer getCpuPeriod() {
        Long result = this.getHostConfig().getCpuPeriod();
        return result != null ? Integer.valueOf(result.intValue()) : null;
    }

    @Deprecated
    @CheckForNull
    @JsonIgnore
    default public Integer getCpuShares() {
        return this.getHostConfig().getCpuShares();
    }

    @Deprecated
    @CheckForNull
    @JsonIgnore
    default public String getCpusetCpus() {
        return this.getHostConfig().getCpusetCpus();
    }

    @Deprecated
    @CheckForNull
    @JsonIgnore
    default public String getCpusetMems() {
        return this.getHostConfig().getCpusetMems();
    }

    @Deprecated
    @CheckForNull
    @JsonIgnore
    default public Device[] getDevices() {
        return this.getHostConfig().getDevices();
    }

    @Deprecated
    @CheckForNull
    @JsonIgnore
    default public String[] getDns() {
        return this.getHostConfig().getDns();
    }

    @Deprecated
    @CheckForNull
    @JsonIgnore
    default public String[] getDnsSearch() {
        return this.getHostConfig().getDnsSearch();
    }

    @Deprecated
    @CheckForNull
    @JsonIgnore
    default public LogConfig getLogConfig() {
        return this.getHostConfig().getLogConfig();
    }

    @Deprecated
    @CheckForNull
    @JsonIgnore
    default public LxcConf[] getLxcConf() {
        return this.getHostConfig().getLxcConf();
    }

    @Deprecated
    @CheckForNull
    @JsonIgnore
    default public Boolean getOomKillDisable() {
        return this.getHostConfig().getOomKillDisable();
    }

    @Deprecated
    @CheckForNull
    @JsonIgnore
    default public String getPidMode() {
        return this.getHostConfig().getPidMode();
    }

    @Deprecated
    @CheckForNull
    @JsonIgnore
    default public Boolean getReadonlyRootfs() {
        return this.getHostConfig().getReadonlyRootfs();
    }

    @Deprecated
    @CheckForNull
    @JsonIgnore
    default public RestartPolicy getRestartPolicy() {
        return this.getHostConfig().getRestartPolicy();
    }

    @Deprecated
    @CheckForNull
    @JsonIgnore
    default public Ulimit[] getUlimits() {
        return this.getHostConfig().getUlimits();
    }

    @Deprecated
    default public CreateContainerCmd withBlkioWeight(Integer blkioWeight) {
        this.getHostConfig().withBlkioWeight(blkioWeight);
        return this;
    }

    @Deprecated
    default public CreateContainerCmd withCgroupParent(String cgroupParent) {
        this.getHostConfig().withCgroupParent(cgroupParent);
        return this;
    }

    @Deprecated
    default public CreateContainerCmd withContainerIDFile(String containerIDFile) {
        this.getHostConfig().withContainerIDFile(containerIDFile);
        return this;
    }

    @Deprecated
    default public CreateContainerCmd withCpuPeriod(Integer cpuPeriod) {
        this.getHostConfig().withCpuPeriod(cpuPeriod != null ? Long.valueOf(cpuPeriod.longValue()) : null);
        return this;
    }

    @Deprecated
    default public CreateContainerCmd withCpuShares(Integer cpuShares) {
        this.getHostConfig().withCpuShares(cpuShares);
        return this;
    }

    @Deprecated
    default public CreateContainerCmd withCpusetCpus(String cpusetCpus) {
        this.getHostConfig().withCpusetCpus(cpusetCpus);
        return this;
    }

    @Deprecated
    default public CreateContainerCmd withCpusetMems(String cpusetMems) {
        this.getHostConfig().withCpusetMems(cpusetMems);
        return this;
    }

    @Deprecated
    default public CreateContainerCmd withDevices(Device ... devices) {
        this.getHostConfig().withDevices(devices);
        return this;
    }

    @Deprecated
    default public CreateContainerCmd withDevices(List<Device> devices) {
        this.getHostConfig().withDevices(devices);
        return this;
    }

    @Deprecated
    default public CreateContainerCmd withDns(String ... dns) {
        this.getHostConfig().withDns(dns);
        return this;
    }

    @Deprecated
    default public CreateContainerCmd withDns(List<String> dns) {
        this.getHostConfig().withDns(dns);
        return this;
    }

    @Deprecated
    default public CreateContainerCmd withDnsSearch(String ... dnsSearch) {
        this.getHostConfig().withDnsSearch(dnsSearch);
        return this;
    }

    @Deprecated
    default public CreateContainerCmd withDnsSearch(List<String> dnsSearch) {
        this.getHostConfig().withDnsSearch(dnsSearch);
        return this;
    }

    @Deprecated
    default public CreateContainerCmd withLogConfig(LogConfig logConfig) {
        this.getHostConfig().withLogConfig(logConfig);
        return this;
    }

    @Deprecated
    default public CreateContainerCmd withLxcConf(LxcConf ... lxcConf) {
        this.getHostConfig().withLxcConf(lxcConf);
        return this;
    }

    @Deprecated
    default public CreateContainerCmd withLxcConf(List<LxcConf> lxcConf) {
        this.getHostConfig().withLxcConf(lxcConf.toArray(new LxcConf[0]));
        return this;
    }

    @Deprecated
    default public CreateContainerCmd withOomKillDisable(Boolean oomKillDisable) {
        this.getHostConfig().withOomKillDisable(oomKillDisable);
        return this;
    }

    @Deprecated
    default public CreateContainerCmd withPidMode(String pidMode) {
        this.getHostConfig().withPidMode(pidMode);
        return this;
    }

    @Deprecated
    default public CreateContainerCmd withReadonlyRootfs(Boolean readonlyRootfs) {
        this.getHostConfig().withReadonlyRootfs(readonlyRootfs);
        return this;
    }

    @Deprecated
    default public CreateContainerCmd withRestartPolicy(RestartPolicy restartPolicy) {
        this.getHostConfig().withRestartPolicy(restartPolicy);
        return this;
    }

    @Deprecated
    @JsonIgnore
    default public CreateContainerCmd withUlimits(Ulimit ... ulimits) {
        this.getHostConfig().withUlimits(ulimits);
        return this;
    }

    @Deprecated
    default public CreateContainerCmd withUlimits(List<Ulimit> ulimits) {
        this.getHostConfig().withUlimits(ulimits);
        return this;
    }

    @CheckForNull
    public String getPlatform();

    public CreateContainerCmd withPlatform(String var1);

    @Override
    public CreateContainerResponse exec() throws NotFoundException, ConflictException;

    public static interface Exec
    extends DockerCmdSyncExec<CreateContainerCmd, CreateContainerResponse> {
    }
}

