/*
 * Decompiled with CFR 0.152.
 */
package de.ec.sql;

import de.ec.sql.ConditionValue;
import de.ec.sql.ConditionValues;
import de.ec.sql.Conditionable;
import de.ec.sql.QueryOptions;
import de.ec.sql.QueryPart;
import de.ec.sql.QueryUtils;
import de.ec.sql.StringJoiner;
import org.apache.commons.lang3.StringUtils;

public class ConditionPart<T extends Conditionable<T>>
implements QueryPart {
    private final Conditionable<T> conditionable;
    private final String name;
    private Object value;
    private Object[] values;
    private Operator operator;
    private boolean not;
    private boolean column;
    private boolean expression;

    protected ConditionPart(Conditionable<T> conditionable, String name) {
        this.conditionable = conditionable;
        this.name = name;
    }

    public ConditionPart<T> not() {
        this.not = true;
        return this;
    }

    public ConditionValue<T> eq() {
        return new ConditionValue(this, Operator.EQUALS);
    }

    public ConditionValue<T> ge() {
        return new ConditionValue(this, Operator.GE);
    }

    public ConditionValue<T> gt() {
        return new ConditionValue(this, Operator.GT);
    }

    public ConditionValue<T> le() {
        return new ConditionValue(this, Operator.LE);
    }

    public ConditionValue<T> lt() {
        return new ConditionValue(this, Operator.LT);
    }

    public ConditionValue<T> like() {
        return new ConditionValue(this, Operator.LIKE);
    }

    public ConditionValues<T> in() {
        return new ConditionValues(this);
    }

    protected T condition(ConditionValue<T> conditionValue) {
        this.operator = conditionValue.getOperator();
        this.value = conditionValue.getValue();
        this.column = conditionValue.isColumn();
        this.expression = conditionValue.isExpression();
        return (T)this.conditionable;
    }

    protected T condition(ConditionValues<T> conditionValues) {
        this.values = conditionValues.getValues();
        this.operator = Operator.IN;
        return (T)this.conditionable;
    }

    public T eq(Object value) {
        return this.op(value, Operator.EQUALS);
    }

    public T ge(Object value) {
        return this.op(value, Operator.GE);
    }

    public T gt(Object value) {
        return this.op(value, Operator.GT);
    }

    public T le(Object value) {
        return this.op(value, Operator.LE);
    }

    public T lt(Object value) {
        return this.op(value, Operator.LT);
    }

    public T like(Object value) {
        return this.op(value, Operator.LIKE);
    }

    public T isNull() {
        return this.op(null, Operator.IS_NULL);
    }

    public T in(Object ... values) {
        return this.in().values(values);
    }

    public T in(Iterable<Object> values) {
        return this.in().values(values);
    }

    protected T op(Object value, Operator operator) {
        this.value = value;
        this.operator = operator;
        return (T)this.conditionable;
    }

    @Override
    public String string(QueryOptions options) {
        if (this.value != null || this.values != null && this.values.length > 0 || this.operator == Operator.IS_NULL || this.operator == Operator.IS_NOT_NULL) {
            StringJoiner strings = new StringJoiner();
            if (this.not && this.operator == Operator.IS_NULL) {
                this.not = false;
                this.operator = Operator.IS_NOT_NULL;
            }
            if (this.not) {
                strings.add(options.cased("NOT"));
                strings.add(" ");
            }
            strings.add(QueryUtils.splitName(options, this.name).string(options));
            strings.add(" ");
            strings.add(this.operator.string(options));
            if (this.operator != Operator.IS_NULL && this.operator != Operator.IS_NOT_NULL) {
                strings.add(" ");
                if (this.expression) {
                    strings.add(QueryUtils.valueToString(options, this.value));
                } else if (this.column) {
                    strings.add(QueryUtils.splitName(options, this.value.toString()).string(options));
                } else if (this.value != null) {
                    if (options.prepare()) {
                        strings.add("?");
                        options.addPreparedValue(this.value);
                    } else {
                        strings.add(QueryUtils.valueToString(options, this.value));
                    }
                } else {
                    strings.add("(");
                    if (options.prepare()) {
                        strings.add(QueryUtils.preparedInValues(this.values.length));
                        for (Object value : this.values) {
                            options.addPreparedValue(value);
                        }
                    } else {
                        strings.add(StringUtils.join(QueryUtils.valuesToStrings(options, this.values), (String)", "));
                    }
                    strings.add(")");
                }
            }
            return strings.toString();
        }
        return "";
    }

    protected Conditionable<T> getConditionable() {
        return this.conditionable;
    }

    protected String getName() {
        return this.name;
    }

    protected Object getValue() {
        return this.value;
    }

    protected Object[] getValues() {
        return this.values;
    }

    protected Operator getOperator() {
        return this.operator;
    }

    protected boolean isNot() {
        return this.not;
    }

    protected boolean isColumn() {
        return this.column;
    }

    protected boolean isExpression() {
        return this.expression;
    }

    public static enum Operator implements QueryPart
    {
        EQUALS("="),
        LIKE("LIKE"),
        IN("IN"),
        IS_NULL("IS NULL"),
        IS_NOT_NULL("IS NOT NULL"),
        GE(">="),
        GT(">"),
        LE("<="),
        LT("<=");

        private String string;

        private Operator(String string2) {
            this.string = string2;
        }

        @Override
        public String string(QueryOptions options) {
            return options.cased(this.string);
        }
    }
}

