/*
 * Decompiled with CFR 0.152.
 */
package de.ec.sql;

import de.ec.sql.Condition;
import de.ec.sql.ConditionPart;
import de.ec.sql.QueryOptions;
import de.ec.sql.QueryPart;
import de.ec.sql.StringJoiner;
import de.ec.sql.ValueHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class Conditionable<T extends Conditionable<T>>
implements QueryPart {
    private final List<QueryPart> parts = new ArrayList<QueryPart>();
    private final Conditionable<T> conditionable = this;

    public T values(ValueHolder values) {
        if (values != null) {
            for (Map.Entry value : values) {
                this.col((String)value.getKey(), value.getValue());
            }
        }
        return (T)this;
    }

    public ConditionPart<T> col(String name) {
        if (!this.parts.isEmpty() && !(this.parts.get(this.parts.size() - 1) instanceof Operator)) {
            this.and();
        }
        ConditionPart<T> part = new ConditionPart<T>(this.conditionable(), name);
        this.parts.add(part);
        return part;
    }

    public T col(String name, Object value) {
        return this.col(name).eq(value);
    }

    public T col(String name, Object ... values) {
        return this.col(name).in(values);
    }

    public T group(Condition group) {
        if (!this.parts.isEmpty() && !(this.parts.get(this.parts.size() - 1) instanceof Operator)) {
            this.and();
        }
        this.parts.add(group);
        return (T)this.conditionable;
    }

    public Conditionable<T> and() {
        if (!this.parts.isEmpty() && this.parts.size() % 2 == 1) {
            this.parts.add(Operator.AND);
        }
        return this;
    }

    public Conditionable<T> or() {
        if (!this.parts.isEmpty() && this.parts.size() % 2 == 1) {
            this.parts.add(Operator.OR);
        }
        return this;
    }

    private Conditionable<T> conditionable() {
        return this.conditionable == null ? this : this.conditionable;
    }

    @Override
    public String string(QueryOptions options) {
        if (this.parts.isEmpty()) {
            return null;
        }
        if (this.parts.size() % 2 != 1) {
            throw new RuntimeException("wrong part count");
        }
        StringJoiner strings = new StringJoiner();
        String first = this.parts.get(0).string(options);
        boolean needsOp = false;
        if (first != null && !first.isEmpty()) {
            needsOp = true;
            strings.add(first);
        }
        for (int i = 1; i < this.parts.size(); i += 2) {
            String op = this.parts.get(i).string(options);
            String val = this.parts.get(i + 1).string(options);
            if (needsOp) {
                if (op == null || op.isEmpty() || val == null || val.isEmpty()) continue;
                strings.add(op).add(val);
                continue;
            }
            if (val == null || val.isEmpty()) continue;
            needsOp = true;
            strings.add(val);
        }
        return strings.toString(" ");
    }

    protected List<QueryPart> getParts() {
        return this.parts;
    }

    protected Conditionable<T> getConditionable() {
        return this.conditionable;
    }

    public static enum Operator implements QueryPart
    {
        AND("AND"),
        OR("OR");

        private final String string;

        private Operator(String string2) {
            this.string = string2;
        }

        @Override
        public String string(QueryOptions options) {
            return options.cased(this.string);
        }
    }
}

