/*
 * Decompiled with CFR 0.152.
 */
package de.ec.sql;

import de.ec.sql.BeforeFrom;
import de.ec.sql.BeforeGroupBy;
import de.ec.sql.BeforeJoin;
import de.ec.sql.BeforeOrderBy;
import de.ec.sql.BeforeWhere;
import de.ec.sql.Query;
import de.ec.sql.QueryBuilder;
import de.ec.sql.QueryOptions;
import de.ec.sql.QueryPart;
import de.ec.sql.QueryUtils;
import de.ec.sql.StringJoiner;
import de.ec.sql.Table;
import java.util.ArrayList;
import java.util.List;

public class From
implements QueryBuilder,
BeforeJoin,
BeforeWhere,
BeforeGroupBy,
BeforeOrderBy {
    private BeforeFrom builder;
    private final List<FromOrigin> origins = new ArrayList<FromOrigin>();
    private String sql;

    protected From(BeforeFrom builder) {
        this.builder = builder;
    }

    public From table(String table) {
        String[] parts;
        String alias = null;
        if (table.toUpperCase().contains(" AS ")) {
            table = table.replaceAll("\\s+[Aa][Ss]\\s+", " ");
        }
        if ((parts = table.split("\\s+")).length > 1) {
            table = parts[0];
            alias = parts[1];
        }
        this.origins.add(new FromOrigin().table(table).alias(alias));
        return this;
    }

    public From table(Table table) {
        return this.table(table.tableName());
    }

    public From tables(String ... tables) {
        for (String table : tables) {
            this.table(table);
        }
        return this;
    }

    public From tables(Table ... tables) {
        for (Table table : tables) {
            this.table(table);
        }
        return this;
    }

    public From subquery(Query query, String alias) {
        this.origins.add(new FromOrigin().subquery(query).alias(alias));
        return this;
    }

    @Override
    public String string(QueryOptions options) {
        assert (this.sql == null && !this.origins.isEmpty()) : "from statement must have at least one target";
        StringJoiner strings = new StringJoiner();
        if (this.builder != null) {
            strings.add(this.builder.string(options));
            strings.add(options.newLine());
        }
        if (this.sql != null) {
            strings.add(this.sql);
        } else {
            strings.add(options.padCased("FROM"));
            strings.add(" ");
            StringJoiner fromStrings = new StringJoiner();
            for (FromOrigin origin : this.origins) {
                fromStrings.add(origin.string(options));
            }
            strings.add(fromStrings.toString(", "));
        }
        return strings.toString();
    }

    public From() {
    }

    protected From builder(BeforeFrom builder) {
        this.builder = builder;
        return this;
    }

    protected From sql(String sql) {
        this.sql = sql;
        return this;
    }

    private class FromOrigin
    implements QueryPart {
        private String table;
        private Query subquery;
        private String alias;

        @Override
        public String string(QueryOptions options) {
            if (this.table != null) {
                return QueryUtils.splitName(options, this.table).string(options) + (this.alias != null ? " " + this.alias : "");
            }
            return "(" + this.subquery.string(options) + ")" + (this.alias != null ? " " + this.alias : "");
        }

        public String table() {
            return this.table;
        }

        public Query subquery() {
            return this.subquery;
        }

        public String alias() {
            return this.alias;
        }

        public FromOrigin table(String table) {
            this.table = table;
            return this;
        }

        public FromOrigin subquery(Query subquery) {
            this.subquery = subquery;
            return this;
        }

        public FromOrigin alias(String alias) {
            this.alias = alias;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FromOrigin)) {
                return false;
            }
            FromOrigin other = (FromOrigin)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$table = this.table();
            String other$table = other.table();
            if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
                return false;
            }
            Query this$subquery = this.subquery();
            Query other$subquery = other.subquery();
            if (this$subquery == null ? other$subquery != null : !this$subquery.equals(other$subquery)) {
                return false;
            }
            String this$alias = this.alias();
            String other$alias = other.alias();
            return !(this$alias == null ? other$alias != null : !this$alias.equals(other$alias));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FromOrigin;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $table = this.table();
            result = result * 59 + ($table == null ? 43 : $table.hashCode());
            Query $subquery = this.subquery();
            result = result * 59 + ($subquery == null ? 43 : $subquery.hashCode());
            String $alias = this.alias();
            result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
            return result;
        }

        public String toString() {
            return "From.FromOrigin(table=" + this.table() + ", subquery=" + this.subquery() + ", alias=" + this.alias() + ")";
        }
    }
}

