/*
 * Decompiled with CFR 0.152.
 */
package de.ec.sql;

import de.ec.sql.BeforeGroupBy;
import de.ec.sql.BeforeHaving;
import de.ec.sql.BeforeOrderBy;
import de.ec.sql.QueryBuilder;
import de.ec.sql.QueryOptions;
import de.ec.sql.QueryUtils;
import de.ec.sql.StringJoiner;
import java.util.ArrayList;
import java.util.List;

public class GroupBy
implements QueryBuilder,
BeforeOrderBy,
BeforeHaving {
    private BeforeGroupBy builder;
    private final List<String> columns = new ArrayList<String>();
    private String sql;

    protected GroupBy(BeforeGroupBy builder) {
        this.builder = builder;
    }

    public GroupBy column(String column) {
        this.columns.add(column);
        return this;
    }

    public GroupBy columns(String ... columns) {
        if (columns != null) {
            for (String column : columns) {
                this.columns.add(column);
            }
        }
        return this;
    }

    @Override
    public String string() {
        return this.string(QueryOptions.DEFAULT_OPTIONS);
    }

    @Override
    public String string(QueryOptions options) {
        StringJoiner strings = new StringJoiner();
        if (this.builder != null) {
            strings.add(this.builder.string(options));
        }
        if (this.sql != null) {
            strings.add(this.sql);
        } else if (!this.columns.isEmpty()) {
            strings.add(options.newLine());
            strings.add(options.padCased("GROUP BY"));
            StringJoiner columnsStrings = new StringJoiner();
            for (String column : this.columns) {
                columnsStrings.add(QueryUtils.splitName(options, column).string(options));
            }
            strings.add(" ");
            strings.add(columnsStrings.toString(", "));
        }
        return strings.toString();
    }

    public GroupBy() {
    }

    protected GroupBy builder(BeforeGroupBy builder) {
        this.builder = builder;
        return this;
    }

    protected GroupBy sql(String sql) {
        this.sql = sql;
        return this;
    }
}

